/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import gnu.java.math.MPN;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BigInteger
extends Number
implements Comparable {
    private static final long serialVersionUID = -8287574255936472291L;
    private static final int minFixNum = -100;
    private static final int maxFixNum = 1024;
    private static final int numFixNum = 1125;
    private static final BigInteger[] smallFixNums = new BigInteger[1125];
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    public static final BigInteger TEN;
    private static final int FLOOR = 1;
    private static final int CEILING = 2;
    private static final int TRUNCATE = 3;
    private static final int ROUND = 4;
    private static final int[] primes;
    private static final int[] k;
    private static final int[] t;
    private static final byte[] bit4_count;
    private transient int ival;
    private transient int[] words;
    private int bitCount;
    private int bitLength;
    private int firstNonzeroByteNum;
    private int lowestSetBit;
    private byte[] magnitude;
    private int signum;

    private final void init(int numBits, Random rnd) {
        int highbits = numBits & 0x1F;
        if (highbits > 0) {
            highbits = rnd.nextInt() >>> 32 - highbits;
        }
        int nwords = numBits / 32;
        while (highbits == 0 && nwords > 0) {
            highbits = rnd.nextInt();
            --nwords;
        }
        if (nwords == 0 && highbits >= 0) {
            this.ival = highbits;
        } else {
            this.ival = highbits < 0 ? nwords + 2 : nwords + 1;
            this.words = new int[this.ival];
            this.words[nwords] = highbits;
            while (--nwords >= 0) {
                this.words[nwords] = rnd.nextInt();
            }
        }
    }

    public static BigInteger probablePrime(int bitLength, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException();
        }
        return new BigInteger(bitLength, 100, rnd);
    }

    public static BigInteger valueOf(long val) {
        if (val >= -100L && val <= 1024L) {
            return smallFixNums[(int)val - -100];
        }
        int i = (int)val;
        if ((long)i == val) {
            return new BigInteger(i);
        }
        BigInteger result = BigInteger.alloc(2);
        result.ival = 2;
        result.words[0] = i;
        result.words[1] = (int)(val >> 32);
        return result;
    }

    private static final BigInteger make(int[] words, int len) {
        if (words == null) {
            return BigInteger.valueOf(len);
        }
        if ((len = BigInteger.wordsNeeded(words, len)) <= 1) {
            return len == 0 ? ZERO : BigInteger.valueOf(words[0]);
        }
        BigInteger num = new BigInteger();
        num.words = words;
        num.ival = len;
        return num;
    }

    private static final int[] byteArrayToIntArray(byte[] bytes, int sign) {
        int[] words = new int[bytes.length / 4 + 1];
        int nwords = words.length;
        int bptr = 0;
        int word = sign;
        int i = bytes.length % 4;
        while (i > 0) {
            word = word << 8 | bytes[bptr] & 0xFF;
            --i;
            ++bptr;
        }
        words[--nwords] = word;
        while (nwords > 0) {
            words[--nwords] = bytes[bptr++] << 24 | (bytes[bptr++] & 0xFF) << 16 | (bytes[bptr++] & 0xFF) << 8 | bytes[bptr++] & 0xFF;
        }
        return words;
    }

    private static final BigInteger alloc(int nwords) {
        BigInteger result = new BigInteger();
        if (nwords > 1) {
            result.words = new int[nwords];
        }
        return result;
    }

    private final void realloc(int nwords) {
        if (nwords == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < nwords || this.words.length > nwords + 2) {
            int[] new_words = new int[nwords];
            if (this.words == null) {
                new_words[0] = this.ival;
                this.ival = 1;
            } else {
                if (nwords < this.ival) {
                    this.ival = nwords;
                }
                System.arraycopy(this.words, 0, new_words, 0, this.ival);
            }
            this.words = new_words;
        }
    }

    private final boolean isNegative() {
        boolean bl = false;
        if ((this.words == null ? this.ival : this.words[this.ival - 1]) < 0) {
            bl = true;
        }
        return bl;
    }

    public int signum() {
        int top;
        int n = top = this.words == null ? this.ival : this.words[this.ival - 1];
        if (top == 0 && this.words == null) {
            return 0;
        }
        return top < 0 ? -1 : 1;
    }

    private static final int compareTo(BigInteger x, BigInteger y) {
        int y_len;
        boolean y_negative;
        if (x.words == null && y.words == null) {
            int n;
            if (x.ival < y.ival) {
                n = -1;
            } else {
                n = 0;
                if (x.ival > y.ival) {
                    n = 1;
                }
            }
            return n;
        }
        boolean x_negative = x.isNegative();
        if (x_negative != (y_negative = y.isNegative())) {
            return x_negative ? -1 : 1;
        }
        int n = 1;
        if (x.words != null) {
            n = x.ival;
        }
        int x_len = n;
        int n2 = 1;
        if (y.words != null) {
            n2 = y.ival;
        }
        if (x_len != (y_len = n2)) {
            boolean bl = false;
            if (x_len > y_len) {
                bl = true;
            }
            return bl != x_negative ? 1 : -1;
        }
        return MPN.cmp(x.words, y.words, x_len);
    }

    public int compareTo(Object obj) {
        if (obj instanceof BigInteger) {
            return BigInteger.compareTo(this, (BigInteger)obj);
        }
        throw new ClassCastException();
    }

    public int compareTo(BigInteger val) {
        return BigInteger.compareTo(this, val);
    }

    public BigInteger min(BigInteger val) {
        return BigInteger.compareTo(this, val) < 0 ? this : val;
    }

    public BigInteger max(BigInteger val) {
        return BigInteger.compareTo(this, val) > 0 ? this : val;
    }

    private final boolean isZero() {
        boolean bl = false;
        if (this.words == null && this.ival == 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean isOne() {
        boolean bl = false;
        if (this.words == null && this.ival == 1) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private static final int wordsNeeded(int[] words, int len) {
        block3: {
            i = len;
            if (i <= 0) break block3;
            if ((word = words[--i]) != -1) ** GOTO lbl11
            while (i > 0 && (word = words[i - 1]) < 0) {
                --i;
                if (word == -1) {
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --i;
lbl11:
                // 2 sources

                ** while (word == 0 && i > 0 && (word = words[i - 1]) >= 0)
            }
        }
        return i + 1;
    }

    private final BigInteger canonicalize() {
        if (this.words != null && (this.ival = BigInteger.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    private static final BigInteger add(int x, int y) {
        return BigInteger.valueOf((long)x + (long)y);
    }

    private static final BigInteger add(BigInteger x, int y) {
        if (x.words == null) {
            return BigInteger.add(x.ival, y);
        }
        BigInteger result = new BigInteger(0);
        result.setAdd(x, y);
        return result.canonicalize();
    }

    private final void setAdd(BigInteger x, int y) {
        if (x.words == null) {
            this.set((long)x.ival + (long)y);
            return;
        }
        int len = x.ival;
        this.realloc(len + 1);
        long carry = y;
        int i = 0;
        while (i < len) {
            this.words[i] = (int)(carry += (long)x.words[i] & 0xFFFFFFFFL);
            carry >>= 32;
            ++i;
        }
        if (x.words[len - 1] < 0) {
            --carry;
        }
        this.words[len] = (int)carry;
        this.ival = BigInteger.wordsNeeded(this.words, len + 1);
    }

    private final void setAdd(int y) {
        this.setAdd(this, y);
    }

    private final void set(long y) {
        int i = (int)y;
        if ((long)i == y) {
            this.ival = i;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = i;
            this.words[1] = (int)(y >> 32);
            this.ival = 2;
        }
    }

    private final void set(int[] words, int length) {
        this.ival = length;
        this.words = words;
    }

    private final void set(BigInteger y) {
        if (y.words == null) {
            this.set(y.ival);
        } else if (this != y) {
            this.realloc(y.ival);
            System.arraycopy(y.words, 0, this.words, 0, y.ival);
            this.ival = y.ival;
        }
    }

    private static final BigInteger add(BigInteger x, BigInteger y, int k) {
        BigInteger result;
        if (x.words == null && y.words == null) {
            return BigInteger.valueOf((long)k * (long)y.ival + (long)x.ival);
        }
        if (k != 1) {
            y = k == -1 ? BigInteger.neg(y) : BigInteger.times(y, BigInteger.valueOf(k));
        }
        if (x.words == null) {
            return BigInteger.add(y, x.ival);
        }
        if (y.words == null) {
            return BigInteger.add(x, y.ival);
        }
        if (y.ival > x.ival) {
            BigInteger tmp = x;
            x = y;
            y = result;
        }
        result = BigInteger.alloc(x.ival + 1);
        int i = y.ival;
        long carry = MPN.add_n(result.words, x.words, y.words, i);
        long y_ext = y.words[i - 1] < 0 ? 0xFFFFFFFFL : 0L;
        while (i < x.ival) {
            result.words[i] = (int)(carry += ((long)x.words[i] & 0xFFFFFFFFL) + y_ext);
            carry >>>= 32;
            ++i;
        }
        if (x.words[i - 1] < 0) {
            --y_ext;
        }
        result.words[i] = (int)(carry + y_ext);
        result.ival = i + 1;
        return result.canonicalize();
    }

    public BigInteger add(BigInteger val) {
        return BigInteger.add(this, val, 1);
    }

    public BigInteger subtract(BigInteger val) {
        return BigInteger.add(this, val, -1);
    }

    private static final BigInteger times(BigInteger x, int y) {
        boolean negative;
        if (y == 0) {
            return ZERO;
        }
        if (y == 1) {
            return x;
        }
        int[] xwords = x.words;
        int xlen = x.ival;
        if (xwords == null) {
            return BigInteger.valueOf((long)xlen * (long)y);
        }
        BigInteger result = BigInteger.alloc(xlen + 1);
        if (xwords[xlen - 1] < 0) {
            negative = true;
            BigInteger.negate(result.words, xwords, xlen);
            xwords = result.words;
        } else {
            negative = false;
        }
        if (y < 0) {
            negative ^= true;
            y = -y;
        }
        result.words[xlen] = MPN.mul_1(result.words, xwords, xlen, y);
        result.ival = xlen + 1;
        if (negative) {
            result.setNegative();
        }
        return result.canonicalize();
    }

    private static final BigInteger times(BigInteger x, BigInteger y) {
        int[] ywords;
        int[] xwords;
        if (y.words == null) {
            return BigInteger.times(x, y.ival);
        }
        if (x.words == null) {
            return BigInteger.times(y, x.ival);
        }
        boolean negative = false;
        int xlen = x.ival;
        int ylen = y.ival;
        if (x.isNegative()) {
            negative = true;
            xwords = new int[xlen];
            BigInteger.negate(xwords, x.words, xlen);
        } else {
            negative = false;
            xwords = x.words;
        }
        if (y.isNegative()) {
            negative ^= true;
            ywords = new int[ylen];
            BigInteger.negate(ywords, y.words, ylen);
        } else {
            ywords = y.words;
        }
        if (xlen < ylen) {
            int[] twords = xwords;
            xwords = ywords;
            ywords = twords;
            int tlen = xlen;
            xlen = ylen;
            ylen = tlen;
        }
        BigInteger result = BigInteger.alloc(xlen + ylen);
        MPN.mul(result.words, xwords, xlen, ywords, ylen);
        result.ival = xlen + ylen;
        if (negative) {
            result.setNegative();
        }
        return result.canonicalize();
    }

    public BigInteger multiply(BigInteger y) {
        return BigInteger.times(this, y);
    }

    private static final void divide(long x, long y, BigInteger quotient, BigInteger remainder, int rounding_mode) {
        boolean yNegative;
        boolean xNegative;
        if (x < 0L) {
            xNegative = true;
            if (x == Long.MIN_VALUE) {
                BigInteger.divide(BigInteger.valueOf(x), BigInteger.valueOf(y), quotient, remainder, rounding_mode);
                return;
            }
            x = -x;
        } else {
            xNegative = false;
        }
        if (y < 0L) {
            yNegative = true;
            if (y == Long.MIN_VALUE) {
                if (rounding_mode == 3) {
                    if (quotient != null) {
                        quotient.set(0L);
                    }
                    if (remainder != null) {
                        remainder.set(x);
                    }
                } else {
                    BigInteger.divide(BigInteger.valueOf(x), BigInteger.valueOf(y), quotient, remainder, rounding_mode);
                }
                return;
            }
            y = -y;
        } else {
            yNegative = false;
        }
        long q = x / y;
        long r = x % y;
        boolean qNegative = xNegative ^ yNegative;
        boolean add_one = false;
        if (r != 0L) {
            switch (rounding_mode) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    boolean bl = false;
                    if (rounding_mode == 1) {
                        bl = true;
                    }
                    if (qNegative != bl) break;
                    add_one = true;
                    break;
                }
                case 4: {
                    boolean bl = false;
                    if (r > y - (q & 1L) >> 1) {
                        bl = true;
                    }
                    add_one = bl;
                    break;
                }
            }
        }
        if (quotient != null) {
            if (add_one) {
                ++q;
            }
            if (qNegative) {
                q = -q;
            }
            quotient.set(q);
        }
        if (remainder != null) {
            if (add_one) {
                r = y - r;
                xNegative ^= true;
            }
            if (xNegative) {
                r = -r;
            }
            remainder.set(r);
        }
    }

    private static final void divide(BigInteger x, BigInteger y, BigInteger quotient, BigInteger remainder, int rounding_mode) {
        int qlen;
        int rlen;
        if (!(x.words != null && x.ival > 2 || y.words != null && y.ival > 2)) {
            long x_l = x.longValue();
            long y_l = y.longValue();
            if (x_l != Long.MIN_VALUE && y_l != Long.MIN_VALUE) {
                BigInteger.divide(x_l, y_l, quotient, remainder, rounding_mode);
                return;
            }
        }
        boolean xNegative = x.isNegative();
        boolean yNegative = y.isNegative();
        boolean qNegative = xNegative ^ yNegative;
        int n = 1;
        if (y.words != null) {
            n = y.ival;
        }
        int ylen = n;
        int[] ywords = new int[ylen];
        y.getAbsolute(ywords);
        while (ylen > 1 && ywords[ylen - 1] == 0) {
            --ylen;
        }
        int n2 = 1;
        if (x.words != null) {
            n2 = x.ival;
        }
        int xlen = n2;
        int[] xwords = new int[xlen + 2];
        x.getAbsolute(xwords);
        while (xlen > 1 && xwords[xlen - 1] == 0) {
            --xlen;
        }
        int cmpval = MPN.cmp(xwords, xlen, ywords, ylen);
        if (cmpval < 0) {
            int[] rwords = xwords;
            xwords = ywords;
            ywords = rwords;
            rlen = xlen;
            qlen = 1;
            xwords[0] = 0;
        } else if (cmpval == 0) {
            xwords[0] = 1;
            qlen = 1;
            ywords[0] = 0;
            rlen = 1;
        } else if (ylen == 1) {
            qlen = xlen;
            if (ywords[0] == 1 && xwords[xlen - 1] < 0) {
                ++qlen;
            }
            rlen = 1;
            ywords[0] = MPN.divmod_1(xwords, xwords, xlen, ywords[0]);
        } else {
            int nshift = MPN.count_leading_zeros(ywords[ylen - 1]);
            if (nshift != 0) {
                MPN.lshift(ywords, 0, ywords, ylen, nshift);
                int x_high = MPN.lshift(xwords, 0, xwords, xlen, nshift);
                xwords[xlen++] = x_high;
            }
            if (xlen == ylen) {
                xwords[xlen++] = 0;
            }
            MPN.divide(xwords, xlen, ywords, ylen);
            rlen = ylen;
            MPN.rshift0(ywords, xwords, 0, rlen, nshift);
            qlen = xlen + 1 - ylen;
            if (quotient != null) {
                int i = 0;
                while (i < qlen) {
                    xwords[i] = xwords[i + ylen];
                    ++i;
                }
            }
        }
        if (ywords[rlen - 1] < 0) {
            ywords[rlen] = 0;
            ++rlen;
        }
        boolean add_one = false;
        if (rlen > 1 || ywords[0] != 0) {
            switch (rounding_mode) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    boolean bl = false;
                    if (rounding_mode == 1) {
                        bl = true;
                    }
                    if (qNegative != bl) break;
                    add_one = true;
                    break;
                }
                case 4: {
                    BigInteger tmp = remainder == null ? new BigInteger() : remainder;
                    tmp.set(ywords, rlen);
                    tmp = BigInteger.shift(tmp, 1);
                    if (yNegative) {
                        tmp.setNegative();
                    }
                    int cmp = BigInteger.compareTo(tmp, y);
                    if (yNegative) {
                        cmp = -cmp;
                    }
                    boolean bl = false;
                    if (cmp != 1 && (cmp != 0 || (xwords[0] & 1) == 0)) break;
                    bl = add_one = true;
                }
            }
        }
        if (quotient != null) {
            quotient.set(xwords, qlen);
            if (qNegative) {
                if (add_one) {
                    quotient.setInvert();
                } else {
                    quotient.setNegative();
                }
            } else if (add_one) {
                quotient.setAdd(1);
            }
        }
        if (remainder != null) {
            remainder.set(ywords, rlen);
            if (add_one) {
                BigInteger tmp;
                if (y.words == null) {
                    tmp = remainder;
                    tmp.set(yNegative ? ywords[0] + y.ival : ywords[0] - y.ival);
                } else {
                    tmp = BigInteger.add(remainder, y, yNegative ? 1 : -1);
                }
                if (xNegative) {
                    remainder.setNegative(tmp);
                } else {
                    remainder.set(tmp);
                }
            } else if (xNegative) {
                remainder.setNegative();
            }
        }
    }

    public BigInteger divide(BigInteger val) {
        if (val.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger quot = new BigInteger();
        BigInteger.divide(this, val, quot, null, 3);
        return quot.canonicalize();
    }

    public BigInteger remainder(BigInteger val) {
        if (val.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger rem = new BigInteger();
        BigInteger.divide(this, val, null, rem, 3);
        return rem.canonicalize();
    }

    public BigInteger[] divideAndRemainder(BigInteger val) {
        if (val.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger[] result = new BigInteger[]{new BigInteger(), new BigInteger()};
        BigInteger.divide(this, val, result[0], result[1], 3);
        result[0].canonicalize();
        result[1].canonicalize();
        return result;
    }

    public BigInteger mod(BigInteger m) {
        if (m.isNegative() || m.isZero()) {
            throw new ArithmeticException("non-positive modulus");
        }
        BigInteger rem = new BigInteger();
        BigInteger.divide(this, m, null, rem, 1);
        return rem.canonicalize();
    }

    public BigInteger pow(int exponent) {
        if (exponent <= 0) {
            if (exponent == 0) {
                return ONE;
            }
            throw new ArithmeticException("negative exponent");
        }
        if (this.isZero()) {
            return this;
        }
        int n = 1;
        if (this.words != null) {
            n = this.ival;
        }
        int plen = n;
        int blen = (this.bitLength() * exponent >> 5) + 2 * plen;
        boolean bl = false;
        if (this.isNegative() && (exponent & 1) != 0) {
            bl = true;
        }
        boolean negative = bl;
        int[] pow2 = new int[blen];
        int[] rwords = new int[blen];
        int[] work = new int[blen];
        this.getAbsolute(pow2);
        int rlen = 1;
        rwords[0] = 1;
        block0: while (true) {
            int[] temp;
            if ((exponent & 1) != 0) {
                MPN.mul(work, pow2, plen, rwords, rlen);
                temp = work;
                work = rwords;
                rwords = temp;
                rlen += plen;
                while (rwords[rlen - 1] == 0) {
                    --rlen;
                }
            }
            if ((exponent >>= 1) == 0) break;
            MPN.mul(work, pow2, plen, pow2, plen);
            temp = work;
            work = pow2;
            pow2 = temp;
            plen *= 2;
            while (true) {
                if (pow2[plen - 1] != 0) continue block0;
                --plen;
            }
            break;
        }
        if (rwords[rlen - 1] < 0) {
            ++rlen;
        }
        if (negative) {
            BigInteger.negate(rwords, rwords, rlen);
        }
        return BigInteger.make(rwords, rlen);
    }

    private static final int[] euclidInv(int a, int b, int prevDiv) {
        if (b == 0) {
            throw new ArithmeticException("not invertible");
        }
        if (b == 1) {
            return new int[]{-prevDiv, 1};
        }
        int[] xy = BigInteger.euclidInv(b, a % b, a / b);
        a = xy[0];
        xy[0] = a * -prevDiv + xy[1];
        xy[1] = a;
        return xy;
    }

    private static final void euclidInv(BigInteger a, BigInteger b, BigInteger prevDiv, BigInteger[] xy) {
        if (b.isZero()) {
            throw new ArithmeticException("not invertible");
        }
        if (b.isOne()) {
            xy[0] = BigInteger.neg(prevDiv);
            xy[1] = ONE;
            return;
        }
        if (a.words == null) {
            int[] xyInt = BigInteger.euclidInv(b.ival, a.ival % b.ival, a.ival / b.ival);
            xy[0] = new BigInteger(xyInt[0]);
            xy[1] = new BigInteger(xyInt[1]);
        } else {
            BigInteger rem = new BigInteger();
            BigInteger quot = new BigInteger();
            BigInteger.divide(a, b, quot, rem, 1);
            rem.canonicalize();
            quot.canonicalize();
            BigInteger.euclidInv(b, rem, quot, xy);
        }
        BigInteger t = xy[0];
        xy[0] = BigInteger.add(xy[1], BigInteger.times(t, prevDiv), -1);
        xy[1] = t;
    }

    public BigInteger modInverse(BigInteger y) {
        if (y.isNegative() || y.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (y.isOne()) {
            return ZERO;
        }
        if (this.isOne()) {
            return ONE;
        }
        BigInteger result = new BigInteger();
        int swapped = 0;
        if (y.words == null) {
            int yval = y.ival;
            int xval = this.words != null || this.isNegative() ? this.mod((BigInteger)y).ival : this.ival;
            if (yval > xval) {
                int tmp = xval;
                xval = yval;
                yval = tmp;
                swapped = 1;
            }
            result.ival = BigInteger.euclidInv(yval, xval % yval, xval / yval)[1 - swapped];
            if (result.ival < 0) {
                result.ival += y.ival;
            }
        } else {
            BigInteger x;
            BigInteger bigInteger = x = this.isNegative() ? this.mod(y) : this;
            if (x.compareTo(y) < 0) {
                result = x;
                x = y;
                y = result;
                swapped = 1;
            }
            BigInteger rem = new BigInteger();
            BigInteger quot = new BigInteger();
            BigInteger.divide(x, y, quot, rem, 1);
            rem.canonicalize();
            quot.canonicalize();
            BigInteger[] xy = new BigInteger[2];
            BigInteger.euclidInv(y, rem, quot, xy);
            BigInteger bigInteger2 = result = swapped != 0 ? xy[0] : xy[1];
            if (result.isNegative()) {
                result = BigInteger.add(result, swapped != 0 ? x : y, 1);
            }
        }
        return result;
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        if (m.isNegative() || m.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (exponent.isNegative()) {
            return this.modInverse(m);
        }
        if (exponent.isOne()) {
            return this.mod(m);
        }
        BigInteger s = ONE;
        BigInteger t = this;
        BigInteger u = exponent;
        while (!u.isZero()) {
            if (u.and(ONE).isOne()) {
                s = BigInteger.times(s, t).mod(m);
            }
            u = u.shiftRight(1);
            t = BigInteger.times(t, t).mod(m);
        }
        return s;
    }

    private static final int gcd(int a, int b) {
        int tmp;
        if (b > a) {
            tmp = a;
            a = b;
            b = tmp;
        }
        while (b != 0) {
            if (b == 1) {
                return b;
            }
            tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    public BigInteger gcd(BigInteger y) {
        int xval = this.ival;
        int yval = y.ival;
        if (this.words == null) {
            if (xval == 0) {
                return BigInteger.abs(y);
            }
            if (y.words == null && xval != Integer.MIN_VALUE && yval != Integer.MIN_VALUE) {
                if (xval < 0) {
                    xval = -xval;
                }
                if (yval < 0) {
                    yval = -yval;
                }
                return BigInteger.valueOf(BigInteger.gcd(xval, yval));
            }
            xval = 1;
        }
        if (y.words == null) {
            if (yval == 0) {
                return BigInteger.abs(this);
            }
            yval = 1;
        }
        int len = (xval > yval ? xval : yval) + 1;
        int[] xwords = new int[len];
        int[] ywords = new int[len];
        this.getAbsolute(xwords);
        y.getAbsolute(ywords);
        len = MPN.gcd(xwords, ywords, len);
        BigInteger result = new BigInteger(0);
        result.ival = len;
        result.words = xwords;
        return result.canonicalize();
    }

    public boolean isProbablePrime(int certainty) {
        if (certainty < 1) {
            return true;
        }
        BigInteger rem = new BigInteger();
        int i = 0;
        while (i < primes.length) {
            if (this.words == null && this.ival == primes[i]) {
                return true;
            }
            BigInteger.divide(this, smallFixNums[primes[i] - -100], null, rem, 3);
            if (rem.canonicalize().isZero()) {
                return false;
            }
            ++i;
        }
        BigInteger pMinus1 = BigInteger.add(this, -1);
        int b = pMinus1.getLowestSetBit();
        BigInteger m = pMinus1.divide(BigInteger.valueOf((long)2 << b - 1));
        int bits = this.bitLength();
        i = 0;
        while (i < k.length) {
            if (bits <= k[i]) break;
            ++i;
        }
        int trials = t[i];
        if (certainty > 80) {
            trials *= 2;
        }
        int t = 0;
        while (t < trials) {
            BigInteger z = smallFixNums[primes[t] - -100].modPow(m, this);
            if (!z.isOne() && !z.equals(pMinus1)) {
                i = 0;
                while (i < b) {
                    if (z.isOne()) {
                        return false;
                    }
                    ++i;
                    if (z.equals(pMinus1)) break;
                    z = z.modPow(BigInteger.valueOf(2), this);
                }
                if (i == b && !z.equals(pMinus1)) {
                    return false;
                }
            }
            ++t;
        }
        return true;
    }

    private final void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int i = this.ival;
            while (--i >= 0) {
                this.words[i] = ~this.words[i];
            }
        }
    }

    private final void setShiftLeft(BigInteger x, int count) {
        int i;
        int xlen;
        int[] xwords;
        if (x.words == null) {
            if (count < 32) {
                this.set((long)x.ival << count);
                return;
            }
            xwords = new int[]{x.ival};
            xlen = 1;
        } else {
            xwords = x.words;
            xlen = x.ival;
        }
        int word_count = count >> 5;
        int new_len = xlen + word_count;
        if ((count &= 0x1F) == 0) {
            this.realloc(new_len);
            i = xlen;
            while (--i >= 0) {
                this.words[i + word_count] = xwords[i];
            }
        } else {
            this.realloc(++new_len);
            int shift_out = MPN.lshift(this.words, word_count, xwords, xlen, count);
            count = 32 - count;
            this.words[new_len - 1] = shift_out << count >> count;
        }
        this.ival = new_len;
        i = word_count;
        while (--i >= 0) {
            this.words[i] = 0;
        }
    }

    private final void setShiftRight(BigInteger x, int count) {
        if (x.words == null) {
            int n;
            if (count < 32) {
                n = x.ival >> count;
            } else {
                int n2 = 0;
                if (x.ival < 0) {
                    n2 = 1;
                }
                n = 0 - n2;
            }
            this.set(n);
        } else if (count == 0) {
            this.set(x);
        } else {
            int n = x.isNegative();
            int word_count = count >> 5;
            count &= 0x1F;
            int d_len = x.ival - word_count;
            if (d_len <= 0) {
                this.set(0 - n);
            } else {
                if (this.words == null || this.words.length < d_len) {
                    this.realloc(d_len);
                }
                MPN.rshift0(this.words, x.words, word_count, d_len, count);
                this.ival = d_len;
                if (n != 0) {
                    int n3 = d_len - 1;
                    this.words[n3] = this.words[n3] | -2 << 31 - count;
                }
            }
        }
    }

    private final void setShift(BigInteger x, int count) {
        if (count > 0) {
            this.setShiftLeft(x, count);
        } else {
            this.setShiftRight(x, -count);
        }
    }

    private static final BigInteger shift(BigInteger x, int count) {
        if (x.words == null) {
            if (count <= 0) {
                int n;
                if (count > -32) {
                    n = x.ival >> -count;
                } else {
                    int n2 = 0;
                    if (x.ival < 0) {
                        n2 = 1;
                    }
                    n = 0 - n2;
                }
                return BigInteger.valueOf(n);
            }
            if (count < 32) {
                return BigInteger.valueOf((long)x.ival << count);
            }
        }
        if (count == 0) {
            return x;
        }
        BigInteger result = new BigInteger(0);
        result.setShift(x, count);
        return result.canonicalize();
    }

    public BigInteger shiftLeft(int n) {
        return BigInteger.shift(this, n);
    }

    public BigInteger shiftRight(int n) {
        return BigInteger.shift(this, -n);
    }

    private final void format(int radix, StringBuffer buffer) {
        if (this.words == null) {
            buffer.append(Integer.toString(this.ival, radix));
        } else if (this.ival <= 2) {
            buffer.append(Long.toString(this.longValue(), radix));
        } else {
            int[] work;
            boolean neg = this.isNegative();
            if (neg || radix != 16) {
                work = new int[this.ival];
                this.getAbsolute(work);
            } else {
                work = this.words;
            }
            int len = this.ival;
            if (radix == 16) {
                if (neg) {
                    buffer.append('-');
                }
                int buf_start = buffer.length();
                int i = len;
                while (--i >= 0) {
                    int word = work[i];
                    int j = 8;
                    while (--j >= 0) {
                        int hex_digit = word >> 4 * j & 0xF;
                        if (hex_digit <= 0 && buffer.length() <= buf_start) continue;
                        buffer.append(Character.forDigit(hex_digit, 16));
                    }
                }
            } else {
                int i = buffer.length();
                do {
                    int digit = MPN.divmod_1(work, work, len, radix);
                    buffer.append(Character.forDigit(digit, radix));
                    while (len > 0 && work[len - 1] == 0) {
                        --len;
                    }
                } while (len != 0);
                if (neg) {
                    buffer.append('-');
                }
                int j = buffer.length() - 1;
                while (i < j) {
                    char tmp = buffer.charAt(i);
                    buffer.setCharAt(i, buffer.charAt(j));
                    buffer.setCharAt(j, tmp);
                    ++i;
                    --j;
                }
            }
        }
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        if (this.words == null) {
            return Integer.toString(this.ival, radix);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), radix);
        }
        int buf_size = this.ival * (MPN.chars_per_word(radix) + 1);
        StringBuffer buffer = new StringBuffer(buf_size);
        this.format(radix, buffer);
        return buffer.toString();
    }

    public int intValue() {
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    public long longValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return this.words == null ? this.ival : this.words[0] + this.words[this.ival - 1];
    }

    private static final boolean equals(BigInteger x, BigInteger y) {
        if (x.words == null && y.words == null) {
            boolean bl = false;
            if (x.ival == y.ival) {
                bl = true;
            }
            return bl;
        }
        if (x.words == null || y.words == null || x.ival != y.ival) {
            return false;
        }
        int i = x.ival;
        while (--i >= 0) {
            if (x.words[i] == y.words[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigInteger)) {
            return false;
        }
        return BigInteger.equals(this, (BigInteger)obj);
    }

    private static final BigInteger valueOf(String s, int radix) throws NumberFormatException {
        int len = s.length();
        if (len <= 15 && radix <= 16) {
            return BigInteger.valueOf(Long.parseLong(s, radix));
        }
        int byte_len = 0;
        byte[] bytes = new byte[len];
        boolean negative = false;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '-') {
                negative = true;
            } else if (ch != '_' && (byte_len != 0 || ch != ' ' && ch != '\t')) {
                int digit = Character.digit(ch, radix);
                if (digit < 0) break;
                bytes[byte_len++] = (byte)digit;
            }
            ++i;
        }
        return BigInteger.valueOf(bytes, byte_len, negative, radix);
    }

    private static final BigInteger valueOf(byte[] digits, int byte_len, boolean negative, int radix) {
        int chars_per_word = MPN.chars_per_word(radix);
        int[] words = new int[byte_len / chars_per_word + 1];
        int size = MPN.set_str(words, digits, byte_len, radix);
        if (size == 0) {
            return ZERO;
        }
        if (words[size - 1] < 0) {
            words[size++] = 0;
        }
        if (negative) {
            BigInteger.negate(words, words, size);
        }
        return BigInteger.make(words, size);
    }

    public double doubleValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return BigInteger.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    private final boolean checkBits(int n) {
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            boolean bl = false;
            if (n > 31 || (this.ival & (1 << n) - 1) != 0) {
                bl = true;
            }
            return bl;
        }
        int i = 0;
        while (i < n >> 5) {
            if (this.words[i] != 0) {
                return true;
            }
            ++i;
        }
        boolean bl = false;
        if ((n & 0x1F) != 0 && (this.words[i] & (1 << (n & 0x1F)) - 1) != 0) {
            bl = true;
        }
        return bl;
    }

    private final double roundToDouble(int exp, boolean neg, boolean remainder) {
        int il = this.bitLength();
        if ((exp += il - 1) < -1075) {
            return neg ? -0.0 : 0.0;
        }
        if (exp > 1023) {
            return neg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int ml = exp >= -1022 ? 53 : 53 + exp + 1022;
        int excess_bits = il - (ml + 1);
        long m = excess_bits > 0 ? (this.words == null ? (long)(this.ival >> excess_bits) : MPN.rshift_long(this.words, this.ival, excess_bits)) : this.longValue() << -excess_bits;
        if (exp == 1023 && m >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (remainder || this.checkBits(il - ml)) {
                return neg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return neg ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if ((m & 1L) == 1L && ((m & (long)2) == (long)2 || remainder || this.checkBits(excess_bits))) {
            if (((m += (long)2) & 0x40000000000000L) != 0L) {
                ++exp;
                m >>= 1;
            } else if (ml == 52 && (m & 0x20000000000000L) != 0L) {
                ++exp;
            }
        }
        long bits_sign = neg ? Long.MIN_VALUE : 0L;
        long bits_exp = (exp += 1023) <= 0 ? 0L : (long)exp << 52;
        long bits_mant = (m >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits_sign | bits_exp | bits_mant);
    }

    private final void getAbsolute(int[] words) {
        int i;
        int len;
        if (this.words == null) {
            len = 1;
            words[0] = this.ival;
        } else {
            i = len = this.ival;
            while (--i >= 0) {
                words[i] = this.words[i];
            }
        }
        if (words[len - 1] < 0) {
            BigInteger.negate(words, words, len);
        }
        i = words.length;
        while (--i > len) {
            words[i] = 0;
        }
    }

    private static final boolean negate(int[] dest, int[] src, int len) {
        long carry = 1L;
        boolean bl = false;
        if (src[len - 1] < 0) {
            bl = true;
        }
        boolean negative = bl;
        int i = 0;
        while (i < len) {
            dest[i] = (int)(carry += (long)(~src[i]) & 0xFFFFFFFFL);
            carry >>= 32;
            ++i;
        }
        boolean bl2 = false;
        if (negative && dest[len - 1] < 0) {
            bl2 = true;
        }
        return bl2;
    }

    private final void setNegative(BigInteger x) {
        int len = x.ival;
        if (x.words == null) {
            if (len == Integer.MIN_VALUE) {
                this.set(-((long)len));
            } else {
                this.set(-len);
            }
            return;
        }
        this.realloc(len + 1);
        if (BigInteger.negate(this.words, x.words, len)) {
            this.words[len++] = 0;
        }
        this.ival = len;
    }

    private final void setNegative() {
        this.setNegative(this);
    }

    private static final BigInteger abs(BigInteger x) {
        return x.isNegative() ? BigInteger.neg(x) : x;
    }

    public BigInteger abs() {
        return BigInteger.abs(this);
    }

    private static final BigInteger neg(BigInteger x) {
        if (x.words == null && x.ival != Integer.MIN_VALUE) {
            return BigInteger.valueOf(-x.ival);
        }
        BigInteger result = new BigInteger(0);
        result.setNegative(x);
        return result.canonicalize();
    }

    public BigInteger negate() {
        return BigInteger.neg(this);
    }

    public int bitLength() {
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public byte[] toByteArray() {
        int word;
        byte[] bytes = new byte[(this.bitLength() + 1 + 7) / 8];
        int nbytes = bytes.length;
        int wptr = 0;
        while (nbytes > 4) {
            word = this.words[wptr++];
            int i = 4;
            while (i > 0) {
                bytes[--nbytes] = (byte)word;
                --i;
                word >>= 8;
            }
        }
        word = this.words == null ? this.ival : this.words[wptr];
        while (nbytes > 0) {
            bytes[--nbytes] = (byte)word;
            word >>= 8;
        }
        return bytes;
    }

    private static final int swappedOp(int op) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(op);
    }

    private static final BigInteger bitOp(int op, BigInteger x, BigInteger y) {
        switch (op) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return x.and(y);
            }
            case 3: {
                return x;
            }
            case 5: {
                return y;
            }
            case 15: {
                return BigInteger.valueOf(-1);
            }
        }
        BigInteger result = new BigInteger();
        BigInteger.setBitOp(result, op, x, y);
        return result.canonicalize();
    }

    private static final void setBitOp(BigInteger result, int op, BigInteger x, BigInteger y) {
        int ni;
        int xlen;
        int xi;
        int ylen;
        int yi;
        if (y.words != null && (x.words == null || x.ival < y.ival)) {
            BigInteger temp = x;
            x = y;
            y = temp;
            op = BigInteger.swappedOp(op);
        }
        if (y.words == null) {
            yi = y.ival;
            ylen = 1;
        } else {
            yi = y.words[0];
            ylen = y.ival;
        }
        if (x.words == null) {
            xi = x.ival;
            xlen = 1;
        } else {
            xi = x.words[0];
            xlen = x.ival;
        }
        if (xlen > 1) {
            result.realloc(xlen);
        }
        int[] w = result.words;
        int i = 0;
        int finish = 0;
        block0 : switch (op) {
            case 0: {
                ni = 0;
                break;
            }
            case 1: {
                while (true) {
                    ni = xi & yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 1;
                break;
            }
            case 2: {
                while (true) {
                    ni = xi & ~yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 1;
                break;
            }
            case 3: {
                ni = xi;
                finish = 1;
                break;
            }
            case 4: {
                while (true) {
                    ni = ~xi & yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 2;
                break;
            }
            case 5: {
                while (true) {
                    ni = yi;
                    if (i + 1 >= ylen) break block0;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
            }
            case 6: {
                while (true) {
                    ni = xi ^ yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                int n = 0;
                if (yi < 0) {
                    n = 1;
                }
                finish = n + 1;
                break;
            }
            case 7: {
                while (true) {
                    ni = xi | yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 1;
                break;
            }
            case 8: {
                while (true) {
                    ni = ~(xi | yi);
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 2;
                break;
            }
            case 9: {
                while (true) {
                    ni = ~(xi ^ yi);
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                int n = 0;
                if (yi >= 0) {
                    n = 1;
                }
                finish = n + 1;
                break;
            }
            case 10: {
                while (true) {
                    ni = ~yi;
                    if (i + 1 >= ylen) break block0;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
            }
            case 11: {
                while (true) {
                    ni = xi | ~yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 1;
                break;
            }
            case 12: {
                ni = ~xi;
                finish = 2;
                break;
            }
            case 13: {
                while (true) {
                    ni = ~xi | yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 2;
                break;
            }
            case 14: {
                while (true) {
                    ni = ~(xi & yi);
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 2;
                break;
            }
            default: {
                ni = -1;
                break;
            }
        }
        if (i + 1 == xlen) {
            finish = 0;
        }
        switch (finish) {
            case 0: {
                if (i == 0 && w == null) {
                    result.ival = ni;
                    return;
                }
                w[i++] = ni;
                break;
            }
            case 1: {
                w[i] = ni;
                while (++i < xlen) {
                    w[i] = x.words[i];
                }
                break;
            }
            case 2: {
                w[i] = ni;
                while (++i < xlen) {
                    w[i] = ~x.words[i];
                }
                break;
            }
        }
        result.ival = i;
    }

    private static final BigInteger and(BigInteger x, int y) {
        if (x.words == null) {
            return BigInteger.valueOf(x.ival & y);
        }
        if (y >= 0) {
            return BigInteger.valueOf(x.words[0] & y);
        }
        int len = x.ival;
        int[] words = new int[len];
        words[0] = x.words[0] & y;
        while (--len > 0) {
            words[len] = x.words[len];
        }
        return BigInteger.make(words, x.ival);
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger and(BigInteger y) {
        if (y.words == null) {
            return BigInteger.and(this, y.ival);
        }
        if (this.words == null) {
            return BigInteger.and(y, this.ival);
        }
        BigInteger x = this;
        if (this.ival < y.ival) {
            void i;
            BigInteger temp = this;
            x = y;
            y = i;
        }
        int len = y.isNegative() ? x.ival : y.ival;
        int[] words = new int[len];
        int i = 0;
        while (i < y.ival) {
            words[i] = x.words[i] & y.words[i];
            ++i;
        }
        while (i < len) {
            words[i] = x.words[i];
            ++i;
        }
        return BigInteger.make(words, len);
    }

    public BigInteger or(BigInteger y) {
        return BigInteger.bitOp(7, this, y);
    }

    public BigInteger xor(BigInteger y) {
        return BigInteger.bitOp(6, this, y);
    }

    public BigInteger not() {
        return BigInteger.bitOp(12, this, ZERO);
    }

    public BigInteger andNot(BigInteger val) {
        return this.and(val.not());
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n).not());
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.or(ONE.shiftLeft(n));
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n)).isZero() ^ true;
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.xor(ONE.shiftLeft(n));
    }

    public int getLowestSetBit() {
        if (this.isZero()) {
            return -1;
        }
        if (this.words == null) {
            return MPN.findLowestBit(this.ival);
        }
        return MPN.findLowestBit(this.words);
    }

    private static final int bitCount(int i) {
        int count = 0;
        while (i != 0) {
            count += bit4_count[i & 0xF];
            i >>>= 4;
        }
        return count;
    }

    private static final int bitCount(int[] x, int len) {
        int count = 0;
        while (--len >= 0) {
            count += BigInteger.bitCount(x[len]);
        }
        return count;
    }

    public int bitCount() {
        int i;
        int x_len;
        int[] x_words = this.words;
        if (x_words == null) {
            x_len = 1;
            i = BigInteger.bitCount(this.ival);
        } else {
            x_len = this.ival;
            i = BigInteger.bitCount(x_words, x_len);
        }
        return this.isNegative() ? x_len * 32 - i : i;
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int n = 0;
        if (this.signum < 0) {
            n = 1;
        }
        this.words = BigInteger.byteArrayToIntArray(this.magnitude, 0 - n);
        BigInteger result = BigInteger.make(this.words, this.words.length);
        this.ival = result.ival;
        this.words = result.words;
    }

    private final void writeObject(ObjectOutputStream s) throws IOException, ClassNotFoundException {
        this.signum = this.signum();
        this.magnitude = this.toByteArray();
        s.defaultWriteObject();
    }

    private final /* synthetic */ void this() {
        this.bitCount = -1;
        this.bitLength = -1;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
    }

    private BigInteger() {
        this.this();
    }

    private BigInteger(int value) {
        this.this();
        this.ival = value;
    }

    public BigInteger(String val, int radix) {
        this.this();
        BigInteger result = BigInteger.valueOf(val, radix);
        this.ival = result.ival;
        this.words = result.words;
    }

    public BigInteger(String val) {
        this(val, 10);
    }

    public BigInteger(byte[] val) {
        this.this();
        if (val == null || val.length < 1) {
            throw new NumberFormatException();
        }
        int n = 0;
        if (val[0] < 0) {
            n = 1;
        }
        this.words = BigInteger.byteArrayToIntArray(val, 0 - n);
        BigInteger result = BigInteger.make(this.words, this.words.length);
        this.ival = result.ival;
        this.words = result.words;
    }

    public BigInteger(int signum, byte[] magnitude) {
        this.this();
        if (magnitude == null || signum > 1 || signum < -1) {
            throw new NumberFormatException();
        }
        if (signum == 0) {
            int i = magnitude.length - 1;
            while (i >= 0 && magnitude[i] == 0) {
                --i;
            }
            if (i >= 0) {
                throw new NumberFormatException();
            }
            return;
        }
        this.words = BigInteger.byteArrayToIntArray(magnitude, 0);
        BigInteger result = BigInteger.make(this.words, this.words.length);
        this.ival = result.ival;
        this.words = result.words;
        if (signum < 0) {
            this.setNegative();
        }
    }

    public BigInteger(int numBits, Random rnd) {
        this.this();
        if (numBits < 0) {
            throw new IllegalArgumentException();
        }
        this.init(numBits, rnd);
    }

    public BigInteger(int bitLength, int certainty, Random rnd) {
        this(bitLength, rnd);
        while (!this.isProbablePrime(certainty)) {
            this.init(bitLength, rnd);
        }
        return;
    }

    static {
        int i = 1125;
        while (--i >= 0) {
            BigInteger.smallFixNums[i] = new BigInteger(i + -100);
        }
        ZERO = smallFixNums[100];
        ONE = smallFixNums[101];
        TEN = smallFixNums[110];
        primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
        k = new int[]{100, 150, 200, 250, 300, 350, 400, 500, 600, 800, 1250, Integer.MAX_VALUE};
        t = new int[]{27, 18, 15, 12, 9, 8, 7, 6, 5, 4, 3, 2};
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 4;
        bit4_count = byArray;
    }
}

