/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.external.ExternalCodec;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class ByteArrayStopCodec
extends ExternalCodec<byte[]> {
    private final int stop;

    public ByteArrayStopCodec(ByteArrayInputStream inputStream, ByteArrayOutputStream outputStream, byte stopByte) {
        super(inputStream, outputStream);
        this.stop = 0xFF & stopByte;
    }

    @Override
    public byte[] read() {
        int b;
        ByteArrayOutputStream readingBAOS = new ByteArrayOutputStream();
        readingBAOS.reset();
        while ((b = this.inputStream.read()) != -1 && b != this.stop) {
            readingBAOS.write(b);
        }
        return readingBAOS.toByteArray();
    }

    @Override
    public byte[] read(int length) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(byte[] value) {
        try {
            this.outputStream.write(value);
            this.outputStream.write(this.stop);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

