#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# Ⱦե뤿Υ饹
#
package FreePWING::Reference;

require 5.005;
require Exporter;
use FileHandle;
use English;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(Exporter);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ȾեΥϥɥ
	'handle' => FileHandle->new(),

	# Ⱦե̾
	'file_name' => '',

	# ޤǤ˽񤭹ȥ
	'entry_count' => 0,

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name)
#           file_name
#		Ⱦե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽å
# :
# 	񤭹Ѥ˻Ⱦե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # Ⱦե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} = 
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ȾեĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;

    $self->close_internal();
    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#	close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
}

#
# :
#	add_block_entry(source_position, target_position, target_file_name)
#           source_position
# 		ȸΰ
#           target_position
# 		ΰ
#           target_file_name
# 		Υե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦե˥֥åȥȥɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_block_entry {
    my $self = shift;
    my ($source_position, $target_position, $target_file_name)
	= @ARG;

    if (!$self->{'handle'}->printf("block\t%08x\t%08x\t%s\n",
				   $source_position, $target_position,
				   $target_file_name)) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
    $self->{'entry_count'}++;
    return 1;
}

#
# :
#	add_position_entry(source_position, target_position,
#		target_file_name)
#           source_position
# 		ȸΰ
#           target_position
# 		ΰ (0 ʾ)
#           target_file_name
# 		Υե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦե˰ֻȥȥɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_position_entry {
    my $self = shift;
    my ($source_position, $target_position, $target_file_name)
	= @ARG;

    if (!$self->{'handle'}->printf("position\t%08x\t%08x\t%s\n",
				   $source_position, $target_position,
				   $target_file_name)) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
    $self->{'entry_count'}++;
    return 1;
}

#
# :
#	add_tag_entry(source_position, target_tag)
#           source_position
# 		ȸΰ
#           target_tag
# 		ΰ (̾)
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦե˥ȥȥɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_tag_entry {
    my $self = shift;
    my ($source_position, $target_tag) = @ARG;

    if (!$self->{'handle'}->printf("tag\t%08x\t%s\n", $source_position,
				   $target_tag)) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
    $self->{'entry_count'}++;
    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub reference_file_name {
    my $self = shift;
    return $self->{'reference_file_name'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
