require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_EVP_H)) {
    eval 'sub OPENSSL_EVP_H () {1;}' unless defined(&OPENSSL_EVP_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_ENVELOPE_H () {1;}' unless defined(&HEADER_ENVELOPE_H);
    }
    require 'stdarg.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    require 'openssl/opensslconf.ph';
    require 'openssl/types.ph';
    require 'openssl/core.ph';
    require 'openssl/core_dispatch.ph';
    require 'openssl/symhacks.ph';
    require 'openssl/bio.ph';
    require 'openssl/evperr.ph';
    require 'openssl/params.ph';
    eval 'sub EVP_MAX_MD_SIZE () {64;}' unless defined(&EVP_MAX_MD_SIZE);
    eval 'sub EVP_MAX_KEY_LENGTH () {64;}' unless defined(&EVP_MAX_KEY_LENGTH);
    eval 'sub EVP_MAX_IV_LENGTH () {16;}' unless defined(&EVP_MAX_IV_LENGTH);
    eval 'sub EVP_MAX_BLOCK_LENGTH () {32;}' unless defined(&EVP_MAX_BLOCK_LENGTH);
    eval 'sub PKCS5_SALT_LEN () {8;}' unless defined(&PKCS5_SALT_LEN);
    eval 'sub PKCS5_DEFAULT_ITER () {2048;}' unless defined(&PKCS5_DEFAULT_ITER);
    require 'openssl/objects.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub EVP_PK_RSA () {0x1;}' unless defined(&EVP_PK_RSA);
	eval 'sub EVP_PK_DSA () {0x2;}' unless defined(&EVP_PK_DSA);
	eval 'sub EVP_PK_DH () {0x4;}' unless defined(&EVP_PK_DH);
	eval 'sub EVP_PK_EC () {0x8;}' unless defined(&EVP_PK_EC);
	eval 'sub EVP_PKT_SIGN () {0x10;}' unless defined(&EVP_PKT_SIGN);
	eval 'sub EVP_PKT_ENC () {0x20;}' unless defined(&EVP_PKT_ENC);
	eval 'sub EVP_PKT_EXCH () {0x40;}' unless defined(&EVP_PKT_EXCH);
	eval 'sub EVP_PKS_RSA () {0x100;}' unless defined(&EVP_PKS_RSA);
	eval 'sub EVP_PKS_DSA () {0x200;}' unless defined(&EVP_PKS_DSA);
	eval 'sub EVP_PKS_EC () {0x400;}' unless defined(&EVP_PKS_EC);
    }
    eval 'sub EVP_PKEY_NONE () { &NID_undef;}' unless defined(&EVP_PKEY_NONE);
    eval 'sub EVP_PKEY_RSA () { &NID_rsaEncryption;}' unless defined(&EVP_PKEY_RSA);
    eval 'sub EVP_PKEY_RSA2 () { &NID_rsa;}' unless defined(&EVP_PKEY_RSA2);
    eval 'sub EVP_PKEY_RSA_PSS () { &NID_rsassaPss;}' unless defined(&EVP_PKEY_RSA_PSS);
    eval 'sub EVP_PKEY_DSA () { &NID_dsa;}' unless defined(&EVP_PKEY_DSA);
    eval 'sub EVP_PKEY_DSA1 () { &NID_dsa_2;}' unless defined(&EVP_PKEY_DSA1);
    eval 'sub EVP_PKEY_DSA2 () { &NID_dsaWithSHA;}' unless defined(&EVP_PKEY_DSA2);
    eval 'sub EVP_PKEY_DSA3 () { &NID_dsaWithSHA1;}' unless defined(&EVP_PKEY_DSA3);
    eval 'sub EVP_PKEY_DSA4 () { &NID_dsaWithSHA1_2;}' unless defined(&EVP_PKEY_DSA4);
    eval 'sub EVP_PKEY_DH () { &NID_dhKeyAgreement;}' unless defined(&EVP_PKEY_DH);
    eval 'sub EVP_PKEY_DHX () { &NID_dhpublicnumber;}' unless defined(&EVP_PKEY_DHX);
    eval 'sub EVP_PKEY_EC () { &NID_X9_62_id_ecPublicKey;}' unless defined(&EVP_PKEY_EC);
    eval 'sub EVP_PKEY_SM2 () { &NID_sm2;}' unless defined(&EVP_PKEY_SM2);
    eval 'sub EVP_PKEY_HMAC () { &NID_hmac;}' unless defined(&EVP_PKEY_HMAC);
    eval 'sub EVP_PKEY_CMAC () { &NID_cmac;}' unless defined(&EVP_PKEY_CMAC);
    eval 'sub EVP_PKEY_SCRYPT () { &NID_id_scrypt;}' unless defined(&EVP_PKEY_SCRYPT);
    eval 'sub EVP_PKEY_TLS1_PRF () { &NID_tls1_prf;}' unless defined(&EVP_PKEY_TLS1_PRF);
    eval 'sub EVP_PKEY_HKDF () { &NID_hkdf;}' unless defined(&EVP_PKEY_HKDF);
    eval 'sub EVP_PKEY_POLY1305 () { &NID_poly1305;}' unless defined(&EVP_PKEY_POLY1305);
    eval 'sub EVP_PKEY_SIPHASH () { &NID_siphash;}' unless defined(&EVP_PKEY_SIPHASH);
    eval 'sub EVP_PKEY_X25519 () { &NID_X25519;}' unless defined(&EVP_PKEY_X25519);
    eval 'sub EVP_PKEY_ED25519 () { &NID_ED25519;}' unless defined(&EVP_PKEY_ED25519);
    eval 'sub EVP_PKEY_X448 () { &NID_X448;}' unless defined(&EVP_PKEY_X448);
    eval 'sub EVP_PKEY_ED448 () { &NID_ED448;}' unless defined(&EVP_PKEY_ED448);
    eval 'sub EVP_PKEY_KEYMGMT () {-1;}' unless defined(&EVP_PKEY_KEYMGMT);
    eval 'sub EVP_PKEY_KEY_PARAMETERS () {(  &OSSL_KEYMGMT_SELECT_ALL_PARAMETERS );}' unless defined(&EVP_PKEY_KEY_PARAMETERS);
    eval 'sub EVP_PKEY_PRIVATE_KEY () {(  &EVP_PKEY_KEY_PARAMETERS |  &OSSL_KEYMGMT_SELECT_PRIVATE_KEY );}' unless defined(&EVP_PKEY_PRIVATE_KEY);
    eval 'sub EVP_PKEY_PUBLIC_KEY () {(  &EVP_PKEY_KEY_PARAMETERS |  &OSSL_KEYMGMT_SELECT_PUBLIC_KEY );}' unless defined(&EVP_PKEY_PUBLIC_KEY);
    eval 'sub EVP_PKEY_KEYPAIR () {(  &EVP_PKEY_PUBLIC_KEY |  &OSSL_KEYMGMT_SELECT_PRIVATE_KEY );}' unless defined(&EVP_PKEY_KEYPAIR);
    if(defined(&__cplusplus)) {
    }
    eval 'sub EVP_PKEY_MO_SIGN () {0x1;}' unless defined(&EVP_PKEY_MO_SIGN);
    eval 'sub EVP_PKEY_MO_VERIFY () {0x2;}' unless defined(&EVP_PKEY_MO_VERIFY);
    eval 'sub EVP_PKEY_MO_ENCRYPT () {0x4;}' unless defined(&EVP_PKEY_MO_ENCRYPT);
    eval 'sub EVP_PKEY_MO_DECRYPT () {0x8;}' unless defined(&EVP_PKEY_MO_DECRYPT);
    unless(defined(&EVP_MD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	}
	eval 'sub EVP_MD_FLAG_ONESHOT () {0x1;}' unless defined(&EVP_MD_FLAG_ONESHOT);
	eval 'sub EVP_MD_FLAG_XOF () {0x2;}' unless defined(&EVP_MD_FLAG_XOF);
	eval 'sub EVP_MD_FLAG_DIGALGID_MASK () {0x18;}' unless defined(&EVP_MD_FLAG_DIGALGID_MASK);
	eval 'sub EVP_MD_FLAG_DIGALGID_NULL () {0x;}' unless defined(&EVP_MD_FLAG_DIGALGID_NULL);
	eval 'sub EVP_MD_FLAG_DIGALGID_ABSENT () {0x8;}' unless defined(&EVP_MD_FLAG_DIGALGID_ABSENT);
	eval 'sub EVP_MD_FLAG_DIGALGID_CUSTOM () {0x18;}' unless defined(&EVP_MD_FLAG_DIGALGID_CUSTOM);
	eval 'sub EVP_MD_FLAG_FIPS () {0x400;}' unless defined(&EVP_MD_FLAG_FIPS);
	eval 'sub EVP_MD_CTRL_DIGALGID () {0x1;}' unless defined(&EVP_MD_CTRL_DIGALGID);
	eval 'sub EVP_MD_CTRL_MICALG () {0x2;}' unless defined(&EVP_MD_CTRL_MICALG);
	eval 'sub EVP_MD_CTRL_XOF_LEN () {0x3;}' unless defined(&EVP_MD_CTRL_XOF_LEN);
	eval 'sub EVP_MD_CTRL_TLSTREE () {0x4;}' unless defined(&EVP_MD_CTRL_TLSTREE);
	eval 'sub EVP_MD_CTRL_ALG_CTRL () {0x1000;}' unless defined(&EVP_MD_CTRL_ALG_CTRL);
    }
    eval 'sub EVP_MD_CTX_FLAG_ONESHOT () {0x1;}' unless defined(&EVP_MD_CTX_FLAG_ONESHOT);
    eval 'sub EVP_MD_CTX_FLAG_CLEANED () {0x2;}' unless defined(&EVP_MD_CTX_FLAG_CLEANED);
    eval 'sub EVP_MD_CTX_FLAG_REUSE () {0x4;}' unless defined(&EVP_MD_CTX_FLAG_REUSE);
    eval 'sub EVP_MD_CTX_FLAG_NON_FIPS_ALLOW () {0x8;}' unless defined(&EVP_MD_CTX_FLAG_NON_FIPS_ALLOW);
    eval 'sub EVP_MD_CTX_FLAG_PAD_MASK () {0xf0;}' unless defined(&EVP_MD_CTX_FLAG_PAD_MASK);
    eval 'sub EVP_MD_CTX_FLAG_PAD_PKCS1 () {0x;}' unless defined(&EVP_MD_CTX_FLAG_PAD_PKCS1);
    eval 'sub EVP_MD_CTX_FLAG_PAD_X931 () {0x10;}' unless defined(&EVP_MD_CTX_FLAG_PAD_X931);
    eval 'sub EVP_MD_CTX_FLAG_PAD_PSS () {0x20;}' unless defined(&EVP_MD_CTX_FLAG_PAD_PSS);
    eval 'sub EVP_MD_CTX_FLAG_NO_INIT () {0x100;}' unless defined(&EVP_MD_CTX_FLAG_NO_INIT);
    eval 'sub EVP_MD_CTX_FLAG_FINALISE () {0x200;}' unless defined(&EVP_MD_CTX_FLAG_FINALISE);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub EVP_CIPH_STREAM_CIPHER () {0x;}' unless defined(&EVP_CIPH_STREAM_CIPHER);
    eval 'sub EVP_CIPH_ECB_MODE () {0x1;}' unless defined(&EVP_CIPH_ECB_MODE);
    eval 'sub EVP_CIPH_CBC_MODE () {0x2;}' unless defined(&EVP_CIPH_CBC_MODE);
    eval 'sub EVP_CIPH_CFB_MODE () {0x3;}' unless defined(&EVP_CIPH_CFB_MODE);
    eval 'sub EVP_CIPH_OFB_MODE () {0x4;}' unless defined(&EVP_CIPH_OFB_MODE);
    eval 'sub EVP_CIPH_CTR_MODE () {0x5;}' unless defined(&EVP_CIPH_CTR_MODE);
    eval 'sub EVP_CIPH_GCM_MODE () {0x6;}' unless defined(&EVP_CIPH_GCM_MODE);
    eval 'sub EVP_CIPH_CCM_MODE () {0x7;}' unless defined(&EVP_CIPH_CCM_MODE);
    eval 'sub EVP_CIPH_XTS_MODE () {0x10001;}' unless defined(&EVP_CIPH_XTS_MODE);
    eval 'sub EVP_CIPH_WRAP_MODE () {0x10002;}' unless defined(&EVP_CIPH_WRAP_MODE);
    eval 'sub EVP_CIPH_OCB_MODE () {0x10003;}' unless defined(&EVP_CIPH_OCB_MODE);
    eval 'sub EVP_CIPH_SIV_MODE () {0x10004;}' unless defined(&EVP_CIPH_SIV_MODE);
    eval 'sub EVP_CIPH_MODE () {0xf0007;}' unless defined(&EVP_CIPH_MODE);
    eval 'sub EVP_CIPH_VARIABLE_LENGTH () {0x8;}' unless defined(&EVP_CIPH_VARIABLE_LENGTH);
    eval 'sub EVP_CIPH_CUSTOM_IV () {0x10;}' unless defined(&EVP_CIPH_CUSTOM_IV);
    eval 'sub EVP_CIPH_ALWAYS_CALL_INIT () {0x20;}' unless defined(&EVP_CIPH_ALWAYS_CALL_INIT);
    eval 'sub EVP_CIPH_CTRL_INIT () {0x40;}' unless defined(&EVP_CIPH_CTRL_INIT);
    eval 'sub EVP_CIPH_CUSTOM_KEY_LENGTH () {0x80;}' unless defined(&EVP_CIPH_CUSTOM_KEY_LENGTH);
    eval 'sub EVP_CIPH_NO_PADDING () {0x100;}' unless defined(&EVP_CIPH_NO_PADDING);
    eval 'sub EVP_CIPH_RAND_KEY () {0x200;}' unless defined(&EVP_CIPH_RAND_KEY);
    eval 'sub EVP_CIPH_CUSTOM_COPY () {0x400;}' unless defined(&EVP_CIPH_CUSTOM_COPY);
    eval 'sub EVP_CIPH_CUSTOM_IV_LENGTH () {0x800;}' unless defined(&EVP_CIPH_CUSTOM_IV_LENGTH);
    eval 'sub EVP_CIPH_FLAG_DEFAULT_ASN1 () {0;}' unless defined(&EVP_CIPH_FLAG_DEFAULT_ASN1);
    eval 'sub EVP_CIPH_FLAG_LENGTH_BITS () {0x2000;}' unless defined(&EVP_CIPH_FLAG_LENGTH_BITS);
    eval 'sub EVP_CIPH_FLAG_FIPS () {0;}' unless defined(&EVP_CIPH_FLAG_FIPS);
    eval 'sub EVP_CIPH_FLAG_NON_FIPS_ALLOW () {0;}' unless defined(&EVP_CIPH_FLAG_NON_FIPS_ALLOW);
    eval 'sub EVP_CIPH_FLAG_CTS () {0x4000;}' unless defined(&EVP_CIPH_FLAG_CTS);
    eval 'sub EVP_CIPH_FLAG_CUSTOM_CIPHER () {0x100000;}' unless defined(&EVP_CIPH_FLAG_CUSTOM_CIPHER);
    eval 'sub EVP_CIPH_FLAG_AEAD_CIPHER () {0x200000;}' unless defined(&EVP_CIPH_FLAG_AEAD_CIPHER);
    eval 'sub EVP_CIPH_FLAG_TLS1_1_MULTIBLOCK () {0x400000;}' unless defined(&EVP_CIPH_FLAG_TLS1_1_MULTIBLOCK);
    eval 'sub EVP_CIPH_FLAG_PIPELINE () {0x800000;}' unless defined(&EVP_CIPH_FLAG_PIPELINE);
    eval 'sub EVP_CIPH_FLAG_CUSTOM_ASN1 () {0x1000000;}' unless defined(&EVP_CIPH_FLAG_CUSTOM_ASN1);
    eval 'sub EVP_CIPH_FLAG_CIPHER_WITH_MAC () {0x2000000;}' unless defined(&EVP_CIPH_FLAG_CIPHER_WITH_MAC);
    eval 'sub EVP_CIPH_FLAG_GET_WRAP_CIPHER () {0x4000000;}' unless defined(&EVP_CIPH_FLAG_GET_WRAP_CIPHER);
    eval 'sub EVP_CIPH_FLAG_INVERSE_CIPHER () {0x8000000;}' unless defined(&EVP_CIPH_FLAG_INVERSE_CIPHER);
    eval 'sub EVP_CIPHER_CTX_FLAG_WRAP_ALLOW () {0x1;}' unless defined(&EVP_CIPHER_CTX_FLAG_WRAP_ALLOW);
    eval 'sub EVP_CTRL_INIT () {0x;}' unless defined(&EVP_CTRL_INIT);
    eval 'sub EVP_CTRL_SET_KEY_LENGTH () {0x1;}' unless defined(&EVP_CTRL_SET_KEY_LENGTH);
    eval 'sub EVP_CTRL_GET_RC2_KEY_BITS () {0x2;}' unless defined(&EVP_CTRL_GET_RC2_KEY_BITS);
    eval 'sub EVP_CTRL_SET_RC2_KEY_BITS () {0x3;}' unless defined(&EVP_CTRL_SET_RC2_KEY_BITS);
    eval 'sub EVP_CTRL_GET_RC5_ROUNDS () {0x4;}' unless defined(&EVP_CTRL_GET_RC5_ROUNDS);
    eval 'sub EVP_CTRL_SET_RC5_ROUNDS () {0x5;}' unless defined(&EVP_CTRL_SET_RC5_ROUNDS);
    eval 'sub EVP_CTRL_RAND_KEY () {0x6;}' unless defined(&EVP_CTRL_RAND_KEY);
    eval 'sub EVP_CTRL_PBE_PRF_NID () {0x7;}' unless defined(&EVP_CTRL_PBE_PRF_NID);
    eval 'sub EVP_CTRL_COPY () {0x8;}' unless defined(&EVP_CTRL_COPY);
    eval 'sub EVP_CTRL_AEAD_SET_IVLEN () {0x9;}' unless defined(&EVP_CTRL_AEAD_SET_IVLEN);
    eval 'sub EVP_CTRL_AEAD_GET_TAG () {0x10;}' unless defined(&EVP_CTRL_AEAD_GET_TAG);
    eval 'sub EVP_CTRL_AEAD_SET_TAG () {0x11;}' unless defined(&EVP_CTRL_AEAD_SET_TAG);
    eval 'sub EVP_CTRL_AEAD_SET_IV_FIXED () {0x12;}' unless defined(&EVP_CTRL_AEAD_SET_IV_FIXED);
    eval 'sub EVP_CTRL_GCM_SET_IVLEN () { &EVP_CTRL_AEAD_SET_IVLEN;}' unless defined(&EVP_CTRL_GCM_SET_IVLEN);
    eval 'sub EVP_CTRL_GCM_GET_TAG () { &EVP_CTRL_AEAD_GET_TAG;}' unless defined(&EVP_CTRL_GCM_GET_TAG);
    eval 'sub EVP_CTRL_GCM_SET_TAG () { &EVP_CTRL_AEAD_SET_TAG;}' unless defined(&EVP_CTRL_GCM_SET_TAG);
    eval 'sub EVP_CTRL_GCM_SET_IV_FIXED () { &EVP_CTRL_AEAD_SET_IV_FIXED;}' unless defined(&EVP_CTRL_GCM_SET_IV_FIXED);
    eval 'sub EVP_CTRL_GCM_IV_GEN () {0x13;}' unless defined(&EVP_CTRL_GCM_IV_GEN);
    eval 'sub EVP_CTRL_CCM_SET_IVLEN () { &EVP_CTRL_AEAD_SET_IVLEN;}' unless defined(&EVP_CTRL_CCM_SET_IVLEN);
    eval 'sub EVP_CTRL_CCM_GET_TAG () { &EVP_CTRL_AEAD_GET_TAG;}' unless defined(&EVP_CTRL_CCM_GET_TAG);
    eval 'sub EVP_CTRL_CCM_SET_TAG () { &EVP_CTRL_AEAD_SET_TAG;}' unless defined(&EVP_CTRL_CCM_SET_TAG);
    eval 'sub EVP_CTRL_CCM_SET_IV_FIXED () { &EVP_CTRL_AEAD_SET_IV_FIXED;}' unless defined(&EVP_CTRL_CCM_SET_IV_FIXED);
    eval 'sub EVP_CTRL_CCM_SET_L () {0x14;}' unless defined(&EVP_CTRL_CCM_SET_L);
    eval 'sub EVP_CTRL_CCM_SET_MSGLEN () {0x15;}' unless defined(&EVP_CTRL_CCM_SET_MSGLEN);
    eval 'sub EVP_CTRL_AEAD_TLS1_AAD () {0x16;}' unless defined(&EVP_CTRL_AEAD_TLS1_AAD);
    eval 'sub EVP_CTRL_AEAD_SET_MAC_KEY () {0x17;}' unless defined(&EVP_CTRL_AEAD_SET_MAC_KEY);
    eval 'sub EVP_CTRL_GCM_SET_IV_INV () {0x18;}' unless defined(&EVP_CTRL_GCM_SET_IV_INV);
    eval 'sub EVP_CTRL_TLS1_1_MULTIBLOCK_AAD () {0x19;}' unless defined(&EVP_CTRL_TLS1_1_MULTIBLOCK_AAD);
    eval 'sub EVP_CTRL_TLS1_1_MULTIBLOCK_ENCRYPT () {0x1a;}' unless defined(&EVP_CTRL_TLS1_1_MULTIBLOCK_ENCRYPT);
    eval 'sub EVP_CTRL_TLS1_1_MULTIBLOCK_DECRYPT () {0x1b;}' unless defined(&EVP_CTRL_TLS1_1_MULTIBLOCK_DECRYPT);
    eval 'sub EVP_CTRL_TLS1_1_MULTIBLOCK_MAX_BUFSIZE () {0x1c;}' unless defined(&EVP_CTRL_TLS1_1_MULTIBLOCK_MAX_BUFSIZE);
    eval 'sub EVP_CTRL_SSL3_MASTER_SECRET () {0x1d;}' unless defined(&EVP_CTRL_SSL3_MASTER_SECRET);
    eval 'sub EVP_CTRL_SET_SBOX () {0x1e;}' unless defined(&EVP_CTRL_SET_SBOX);
    eval 'sub EVP_CTRL_SBOX_USED () {0x1f;}' unless defined(&EVP_CTRL_SBOX_USED);
    eval 'sub EVP_CTRL_KEY_MESH () {0x20;}' unless defined(&EVP_CTRL_KEY_MESH);
    eval 'sub EVP_CTRL_BLOCK_PADDING_MODE () {0x21;}' unless defined(&EVP_CTRL_BLOCK_PADDING_MODE);
    eval 'sub EVP_CTRL_SET_PIPELINE_OUTPUT_BUFS () {0x22;}' unless defined(&EVP_CTRL_SET_PIPELINE_OUTPUT_BUFS);
    eval 'sub EVP_CTRL_SET_PIPELINE_INPUT_BUFS () {0x23;}' unless defined(&EVP_CTRL_SET_PIPELINE_INPUT_BUFS);
    eval 'sub EVP_CTRL_SET_PIPELINE_INPUT_LENS () {0x24;}' unless defined(&EVP_CTRL_SET_PIPELINE_INPUT_LENS);
    eval 'sub EVP_CTRL_GET_IVLEN () {0x25;}' unless defined(&EVP_CTRL_GET_IVLEN);
    eval 'sub EVP_CTRL_SET_SPEED () {0x27;}' unless defined(&EVP_CTRL_SET_SPEED);
    eval 'sub EVP_CTRL_PROCESS_UNPROTECTED () {0x28;}' unless defined(&EVP_CTRL_PROCESS_UNPROTECTED);
    eval 'sub EVP_CTRL_GET_WRAP_CIPHER () {0x29;}' unless defined(&EVP_CTRL_GET_WRAP_CIPHER);
    eval 'sub EVP_CTRL_TLSTREE () {0x2a;}' unless defined(&EVP_CTRL_TLSTREE);
    eval 'sub EVP_PADDING_PKCS7 () {1;}' unless defined(&EVP_PADDING_PKCS7);
    eval 'sub EVP_PADDING_ISO7816_4 () {2;}' unless defined(&EVP_PADDING_ISO7816_4);
    eval 'sub EVP_PADDING_ANSI923 () {3;}' unless defined(&EVP_PADDING_ANSI923);
    eval 'sub EVP_PADDING_ISO10126 () {4;}' unless defined(&EVP_PADDING_ISO10126);
    eval 'sub EVP_PADDING_ZERO () {5;}' unless defined(&EVP_PADDING_ZERO);
    eval 'sub EVP_AEAD_TLS1_AAD_LEN () {13;}' unless defined(&EVP_AEAD_TLS1_AAD_LEN);
    eval 'sub EVP_GCM_TLS_FIXED_IV_LEN () {4;}' unless defined(&EVP_GCM_TLS_FIXED_IV_LEN);
    eval 'sub EVP_GCM_TLS_EXPLICIT_IV_LEN () {8;}' unless defined(&EVP_GCM_TLS_EXPLICIT_IV_LEN);
    eval 'sub EVP_GCM_TLS_TAG_LEN () {16;}' unless defined(&EVP_GCM_TLS_TAG_LEN);
    eval 'sub EVP_CCM_TLS_FIXED_IV_LEN () {4;}' unless defined(&EVP_CCM_TLS_FIXED_IV_LEN);
    eval 'sub EVP_CCM_TLS_EXPLICIT_IV_LEN () {8;}' unless defined(&EVP_CCM_TLS_EXPLICIT_IV_LEN);
    eval 'sub EVP_CCM_TLS_IV_LEN () {12;}' unless defined(&EVP_CCM_TLS_IV_LEN);
    eval 'sub EVP_CCM_TLS_TAG_LEN () {16;}' unless defined(&EVP_CCM_TLS_TAG_LEN);
    eval 'sub EVP_CCM8_TLS_TAG_LEN () {8;}' unless defined(&EVP_CCM8_TLS_TAG_LEN);
    eval 'sub EVP_CHACHAPOLY_TLS_TAG_LEN () {16;}' unless defined(&EVP_CHACHAPOLY_TLS_TAG_LEN);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub EVP_PKEY_assign_RSA {
	    my($pkey,$rsa) = @_;
    	    eval q( &EVP_PKEY_assign(($pkey), &EVP_PKEY_RSA, ($rsa)));
	}' unless defined(&EVP_PKEY_assign_RSA);
    }
    unless(defined(&OPENSSL_NO_DSA)) {
	eval 'sub EVP_PKEY_assign_DSA {
	    my($pkey,$dsa) = @_;
    	    eval q( &EVP_PKEY_assign(($pkey), &EVP_PKEY_DSA, ($dsa)));
	}' unless defined(&EVP_PKEY_assign_DSA);
    }
    if(!defined(&OPENSSL_NO_DH)  && !defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub EVP_PKEY_assign_DH {
	    my($pkey,$dh) = @_;
    	    eval q( &EVP_PKEY_assign(($pkey), &EVP_PKEY_DH,($dh)));
	}' unless defined(&EVP_PKEY_assign_DH);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_EC)) {
	    eval 'sub EVP_PKEY_assign_EC_KEY {
	        my($pkey,$eckey) = @_;
    		eval q( &EVP_PKEY_assign(($pkey),  &EVP_PKEY_EC, ($eckey)));
	    }' unless defined(&EVP_PKEY_assign_EC_KEY);
	}
    }
    unless(defined(&OPENSSL_NO_SIPHASH)) {
	eval 'sub EVP_PKEY_assign_SIPHASH {
	    my($pkey,$shkey) = @_;
    	    eval q( &EVP_PKEY_assign(($pkey),  &EVP_PKEY_SIPHASH,($shkey)));
	}' unless defined(&EVP_PKEY_assign_SIPHASH);
    }
    unless(defined(&OPENSSL_NO_POLY1305)) {
	eval 'sub EVP_PKEY_assign_POLY1305 {
	    my($pkey,$polykey) = @_;
    	    eval q( &EVP_PKEY_assign(($pkey),  &EVP_PKEY_POLY1305,($polykey)));
	}' unless defined(&EVP_PKEY_assign_POLY1305);
    }
    eval 'sub EVP_get_digestbynid {
        my($a) = @_;
	    eval q( &EVP_get_digestbyname( &OBJ_nid2sn($a)));
    }' unless defined(&EVP_get_digestbynid);
    eval 'sub EVP_get_digestbyobj {
        my($a) = @_;
	    eval q( &EVP_get_digestbynid( &OBJ_obj2nid($a)));
    }' unless defined(&EVP_get_digestbyobj);
    eval 'sub EVP_get_cipherbynid {
        my($a) = @_;
	    eval q( &EVP_get_cipherbyname( &OBJ_nid2sn($a)));
    }' unless defined(&EVP_get_cipherbynid);
    eval 'sub EVP_get_cipherbyobj {
        my($a) = @_;
	    eval q( &EVP_get_cipherbynid( &OBJ_obj2nid($a)));
    }' unless defined(&EVP_get_cipherbyobj);
    eval 'sub EVP_MD_type () { &EVP_MD_get_type;}' unless defined(&EVP_MD_type);
    eval 'sub EVP_MD_nid () { &EVP_MD_get_type;}' unless defined(&EVP_MD_nid);
    eval 'sub EVP_MD_name () { &EVP_MD_get0_name;}' unless defined(&EVP_MD_name);
    eval 'sub EVP_MD_pkey_type () { &EVP_MD_get_pkey_type;}' unless defined(&EVP_MD_pkey_type);
    eval 'sub EVP_MD_size () { &EVP_MD_get_size;}' unless defined(&EVP_MD_size);
    eval 'sub EVP_MD_block_size () { &EVP_MD_get_block_size;}' unless defined(&EVP_MD_block_size);
    eval 'sub EVP_MD_flags () { &EVP_MD_get_flags;}' unless defined(&EVP_MD_flags);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub EVP_MD_CTX_get0_name {
        my($e) = @_;
	    eval q( &EVP_MD_get0_name( &EVP_MD_CTX_get0_md($e)));
    }' unless defined(&EVP_MD_CTX_get0_name);
    eval 'sub EVP_MD_CTX_get_size {
        my($e) = @_;
	    eval q( &EVP_MD_get_size( &EVP_MD_CTX_get0_md($e)));
    }' unless defined(&EVP_MD_CTX_get_size);
    eval 'sub EVP_MD_CTX_size () { &EVP_MD_CTX_get_size;}' unless defined(&EVP_MD_CTX_size);
    eval 'sub EVP_MD_CTX_get_block_size {
        my($e) = @_;
	    eval q( &EVP_MD_get_block_size( &EVP_MD_CTX_get0_md($e)));
    }' unless defined(&EVP_MD_CTX_get_block_size);
    eval 'sub EVP_MD_CTX_block_size () { &EVP_MD_CTX_get_block_size;}' unless defined(&EVP_MD_CTX_block_size);
    eval 'sub EVP_MD_CTX_get_type {
        my($e) = @_;
	    eval q( &EVP_MD_get_type( &EVP_MD_CTX_get0_md($e)));
    }' unless defined(&EVP_MD_CTX_get_type);
    eval 'sub EVP_MD_CTX_type () { &EVP_MD_CTX_get_type;}' unless defined(&EVP_MD_CTX_type);
    eval 'sub EVP_MD_CTX_pkey_ctx () { &EVP_MD_CTX_get_pkey_ctx;}' unless defined(&EVP_MD_CTX_pkey_ctx);
    eval 'sub EVP_MD_CTX_md_data () { &EVP_MD_CTX_get0_md_data;}' unless defined(&EVP_MD_CTX_md_data);
    eval 'sub EVP_CIPHER_nid () { &EVP_CIPHER_get_nid;}' unless defined(&EVP_CIPHER_nid);
    eval 'sub EVP_CIPHER_name () { &EVP_CIPHER_get0_name;}' unless defined(&EVP_CIPHER_name);
    eval 'sub EVP_CIPHER_block_size () { &EVP_CIPHER_get_block_size;}' unless defined(&EVP_CIPHER_block_size);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub EVP_CIPHER_key_length () { &EVP_CIPHER_get_key_length;}' unless defined(&EVP_CIPHER_key_length);
    eval 'sub EVP_CIPHER_iv_length () { &EVP_CIPHER_get_iv_length;}' unless defined(&EVP_CIPHER_iv_length);
    eval 'sub EVP_CIPHER_flags () { &EVP_CIPHER_get_flags;}' unless defined(&EVP_CIPHER_flags);
    eval 'sub EVP_CIPHER_mode () { &EVP_CIPHER_get_mode;}' unless defined(&EVP_CIPHER_mode);
    eval 'sub EVP_CIPHER_type () { &EVP_CIPHER_get_type;}' unless defined(&EVP_CIPHER_type);
    eval 'sub EVP_CIPHER_CTX_encrypting () { &EVP_CIPHER_CTX_is_encrypting;}' unless defined(&EVP_CIPHER_CTX_encrypting);
    eval 'sub EVP_CIPHER_CTX_nid () { &EVP_CIPHER_CTX_get_nid;}' unless defined(&EVP_CIPHER_CTX_nid);
    eval 'sub EVP_CIPHER_CTX_block_size () { &EVP_CIPHER_CTX_get_block_size;}' unless defined(&EVP_CIPHER_CTX_block_size);
    eval 'sub EVP_CIPHER_CTX_key_length () { &EVP_CIPHER_CTX_get_key_length;}' unless defined(&EVP_CIPHER_CTX_key_length);
    eval 'sub EVP_CIPHER_CTX_iv_length () { &EVP_CIPHER_CTX_get_iv_length;}' unless defined(&EVP_CIPHER_CTX_iv_length);
    eval 'sub EVP_CIPHER_CTX_tag_length () { &EVP_CIPHER_CTX_get_tag_length;}' unless defined(&EVP_CIPHER_CTX_tag_length);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub EVP_CIPHER_CTX_num () { &EVP_CIPHER_CTX_get_num;}' unless defined(&EVP_CIPHER_CTX_num);
    eval 'sub EVP_CIPHER_CTX_get0_name {
        my($c) = @_;
	    eval q( &EVP_CIPHER_get0_name( &EVP_CIPHER_CTX_get0_cipher($c)));
    }' unless defined(&EVP_CIPHER_CTX_get0_name);
    eval 'sub EVP_CIPHER_CTX_get_type {
        my($c) = @_;
	    eval q( &EVP_CIPHER_get_type( &EVP_CIPHER_CTX_get0_cipher($c)));
    }' unless defined(&EVP_CIPHER_CTX_get_type);
    eval 'sub EVP_CIPHER_CTX_type () { &EVP_CIPHER_CTX_get_type;}' unless defined(&EVP_CIPHER_CTX_type);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub EVP_CIPHER_CTX_flags {
	    my($c) = @_;
    	    eval q( &EVP_CIPHER_get_flags( &EVP_CIPHER_CTX_get0_cipher($c)));
	}' unless defined(&EVP_CIPHER_CTX_flags);
    }
    eval 'sub EVP_CIPHER_CTX_get_mode {
        my($c) = @_;
	    eval q( &EVP_CIPHER_get_mode( &EVP_CIPHER_CTX_get0_cipher($c)));
    }' unless defined(&EVP_CIPHER_CTX_get_mode);
    eval 'sub EVP_CIPHER_CTX_mode () { &EVP_CIPHER_CTX_get_mode;}' unless defined(&EVP_CIPHER_CTX_mode);
    eval 'sub EVP_ENCODE_LENGTH {
        my($l) = @_;
	    eval q((((($l)+2)/3*4)+(($l)/48+1)*2+80));
    }' unless defined(&EVP_ENCODE_LENGTH);
    eval 'sub EVP_DECODE_LENGTH {
        my($l) = @_;
	    eval q(((($l)+3)/4*3+80));
    }' unless defined(&EVP_DECODE_LENGTH);
    eval 'sub EVP_SignInit_ex {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestInit_ex($a,$b,$c));
    }' unless defined(&EVP_SignInit_ex);
    eval 'sub EVP_SignInit {
        my($a,$b) = @_;
	    eval q( &EVP_DigestInit($a,$b));
    }' unless defined(&EVP_SignInit);
    eval 'sub EVP_SignUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_SignUpdate);
    eval 'sub EVP_VerifyInit_ex {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestInit_ex($a,$b,$c));
    }' unless defined(&EVP_VerifyInit_ex);
    eval 'sub EVP_VerifyInit {
        my($a,$b) = @_;
	    eval q( &EVP_DigestInit($a,$b));
    }' unless defined(&EVP_VerifyInit);
    eval 'sub EVP_VerifyUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_VerifyUpdate);
    eval 'sub EVP_OpenUpdate {
        my($a,$b,$c,$d,$e) = @_;
	    eval q( &EVP_DecryptUpdate($a,$b,$c,$d,$e));
    }' unless defined(&EVP_OpenUpdate);
    eval 'sub EVP_SealUpdate {
        my($a,$b,$c,$d,$e) = @_;
	    eval q( &EVP_EncryptUpdate($a,$b,$c,$d,$e));
    }' unless defined(&EVP_SealUpdate);
    if(defined(&CONST_STRICT)) {
    } else {
	eval 'sub BIO_set_md {
	    my($b,$md) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_MD,0,( &void *)($md)));
	}' unless defined(&BIO_set_md);
    }
    eval 'sub BIO_get_md {
        my($b,$mdp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_MD,0,($mdp)));
    }' unless defined(&BIO_get_md);
    eval 'sub BIO_get_md_ctx {
        my($b,$mdcp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_MD_CTX,0,($mdcp)));
    }' unless defined(&BIO_get_md_ctx);
    eval 'sub BIO_set_md_ctx {
        my($b,$mdcp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_MD_CTX,0,($mdcp)));
    }' unless defined(&BIO_set_md_ctx);
    eval 'sub BIO_get_cipher_status {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_CIPHER_STATUS,0, &NULL));
    }' unless defined(&BIO_get_cipher_status);
    eval 'sub BIO_get_cipher_ctx {
        my($b,$c_pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_CIPHER_CTX,0,($c_pp)));
    }' unless defined(&BIO_get_cipher_ctx);
    eval 'sub EVP_add_cipher_alias {
        my($n,$alias) = @_;
	    eval q( &OBJ_NAME_add(($alias), &OBJ_NAME_TYPE_CIPHER_METH| &OBJ_NAME_ALIAS,($n)));
    }' unless defined(&EVP_add_cipher_alias);
    eval 'sub EVP_add_digest_alias {
        my($n,$alias) = @_;
	    eval q( &OBJ_NAME_add(($alias), &OBJ_NAME_TYPE_MD_METH| &OBJ_NAME_ALIAS,($n)));
    }' unless defined(&EVP_add_digest_alias);
    eval 'sub EVP_delete_cipher_alias {
        my($alias) = @_;
	    eval q( &OBJ_NAME_remove($alias, &OBJ_NAME_TYPE_CIPHER_METH| &OBJ_NAME_ALIAS););
    }' unless defined(&EVP_delete_cipher_alias);
    eval 'sub EVP_delete_digest_alias {
        my($alias) = @_;
	    eval q( &OBJ_NAME_remove($alias, &OBJ_NAME_TYPE_MD_METH| &OBJ_NAME_ALIAS););
    }' unless defined(&EVP_delete_digest_alias);
    eval 'sub EVP_MD_CTX_create () {
        eval q( &EVP_MD_CTX_new());
    }' unless defined(&EVP_MD_CTX_create);
    eval 'sub EVP_MD_CTX_init {
        my($ctx) = @_;
	    eval q( &EVP_MD_CTX_reset(($ctx)));
    }' unless defined(&EVP_MD_CTX_init);
    eval 'sub EVP_MD_CTX_destroy {
        my($ctx) = @_;
	    eval q( &EVP_MD_CTX_free(($ctx)));
    }' unless defined(&EVP_MD_CTX_destroy);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub EVP_CIPHER_CTX_init {
	    my($c) = @_;
    	    eval q( &EVP_CIPHER_CTX_reset($c));
	}' unless defined(&EVP_CIPHER_CTX_init);
	eval 'sub EVP_CIPHER_CTX_cleanup {
	    my($c) = @_;
    	    eval q( &EVP_CIPHER_CTX_reset($c));
	}' unless defined(&EVP_CIPHER_CTX_cleanup);
    }
    unless(defined(&OPENSSL_NO_MD2)) {
    }
    unless(defined(&OPENSSL_NO_MD4)) {
    }
    unless(defined(&OPENSSL_NO_MD5)) {
    }
    unless(defined(&OPENSSL_NO_BLAKE2)) {
    }
    unless(defined(&OPENSSL_NO_MDC2)) {
    }
    unless(defined(&OPENSSL_NO_RMD160)) {
    }
    unless(defined(&OPENSSL_NO_WHIRLPOOL)) {
    }
    unless(defined(&OPENSSL_NO_SM3)) {
    }
    unless(defined(&OPENSSL_NO_DES)) {
	eval 'sub EVP_des_cfb () { &EVP_des_cfb64;}' unless defined(&EVP_des_cfb);
	eval 'sub EVP_des_ede_cfb () { &EVP_des_ede_cfb64;}' unless defined(&EVP_des_ede_cfb);
	eval 'sub EVP_des_ede3_cfb () { &EVP_des_ede3_cfb64;}' unless defined(&EVP_des_ede3_cfb);
    }
    unless(defined(&OPENSSL_NO_RC4)) {
	unless(defined(&OPENSSL_NO_MD5)) {
	}
    }
    unless(defined(&OPENSSL_NO_IDEA)) {
	eval 'sub EVP_idea_cfb () { &EVP_idea_cfb64;}' unless defined(&EVP_idea_cfb);
    }
    unless(defined(&OPENSSL_NO_RC2)) {
	eval 'sub EVP_rc2_cfb () { &EVP_rc2_cfb64;}' unless defined(&EVP_rc2_cfb);
    }
    unless(defined(&OPENSSL_NO_BF)) {
	eval 'sub EVP_bf_cfb () { &EVP_bf_cfb64;}' unless defined(&EVP_bf_cfb);
    }
    unless(defined(&OPENSSL_NO_CAST)) {
	eval 'sub EVP_cast5_cfb () { &EVP_cast5_cfb64;}' unless defined(&EVP_cast5_cfb);
    }
    unless(defined(&OPENSSL_NO_RC5)) {
	eval 'sub EVP_rc5_32_12_16_cfb () { &EVP_rc5_32_12_16_cfb64;}' unless defined(&EVP_rc5_32_12_16_cfb);
    }
    eval 'sub EVP_aes_128_cfb () { &EVP_aes_128_cfb128;}' unless defined(&EVP_aes_128_cfb);
    unless(defined(&OPENSSL_NO_OCB)) {
    }
    eval 'sub EVP_aes_192_cfb () { &EVP_aes_192_cfb128;}' unless defined(&EVP_aes_192_cfb);
    unless(defined(&OPENSSL_NO_OCB)) {
    }
    eval 'sub EVP_aes_256_cfb () { &EVP_aes_256_cfb128;}' unless defined(&EVP_aes_256_cfb);
    unless(defined(&OPENSSL_NO_OCB)) {
    }
    unless(defined(&OPENSSL_NO_ARIA)) {
	eval 'sub EVP_aria_128_cfb () { &EVP_aria_128_cfb128;}' unless defined(&EVP_aria_128_cfb);
	eval 'sub EVP_aria_192_cfb () { &EVP_aria_192_cfb128;}' unless defined(&EVP_aria_192_cfb);
	eval 'sub EVP_aria_256_cfb () { &EVP_aria_256_cfb128;}' unless defined(&EVP_aria_256_cfb);
    }
    unless(defined(&OPENSSL_NO_CAMELLIA)) {
	eval 'sub EVP_camellia_128_cfb () { &EVP_camellia_128_cfb128;}' unless defined(&EVP_camellia_128_cfb);
	eval 'sub EVP_camellia_192_cfb () { &EVP_camellia_192_cfb128;}' unless defined(&EVP_camellia_192_cfb);
	eval 'sub EVP_camellia_256_cfb () { &EVP_camellia_256_cfb128;}' unless defined(&EVP_camellia_256_cfb);
    }
    unless(defined(&OPENSSL_NO_CHACHA)) {
	unless(defined(&OPENSSL_NO_POLY1305)) {
	}
    }
    unless(defined(&OPENSSL_NO_SEED)) {
	eval 'sub EVP_seed_cfb () { &EVP_seed_cfb128;}' unless defined(&EVP_seed_cfb);
    }
    unless(defined(&OPENSSL_NO_SM4)) {
	eval 'sub EVP_sm4_cfb () { &EVP_sm4_cfb128;}' unless defined(&EVP_sm4_cfb);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub OPENSSL_add_all_algorithms_conf () {
	    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ADD_ALL_CIPHERS |  &OPENSSL_INIT_ADD_ALL_DIGESTS |  &OPENSSL_INIT_LOAD_CONFIG,  &NULL));
	}' unless defined(&OPENSSL_add_all_algorithms_conf);
	eval 'sub OPENSSL_add_all_algorithms_noconf () {
	    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ADD_ALL_CIPHERS |  &OPENSSL_INIT_ADD_ALL_DIGESTS,  &NULL));
	}' unless defined(&OPENSSL_add_all_algorithms_noconf);
	if(defined(&OPENSSL_LOAD_CONF)) {
	    eval 'sub OpenSSL_add_all_algorithms () {
	        eval q( &OPENSSL_add_all_algorithms_conf());
	    }' unless defined(&OpenSSL_add_all_algorithms);
	} else {
	    eval 'sub OpenSSL_add_all_algorithms () {
	        eval q( &OPENSSL_add_all_algorithms_noconf());
	    }' unless defined(&OpenSSL_add_all_algorithms);
	}
	eval 'sub OpenSSL_add_all_ciphers () {
	    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ADD_ALL_CIPHERS,  &NULL));
	}' unless defined(&OpenSSL_add_all_ciphers);
	eval 'sub OpenSSL_add_all_digests () {
	    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ADD_ALL_DIGESTS,  &NULL));
	}' unless defined(&OpenSSL_add_all_digests);
	eval 'sub EVP_cleanup () {
	    eval q( &while(0)  &continue);
	}' unless defined(&EVP_cleanup);
    }
    eval 'sub EVP_RAND_STATE_UNINITIALISED () {0;}' unless defined(&EVP_RAND_STATE_UNINITIALISED);
    eval 'sub EVP_RAND_STATE_READY () {1;}' unless defined(&EVP_RAND_STATE_READY);
    eval 'sub EVP_RAND_STATE_ERROR () {2;}' unless defined(&EVP_RAND_STATE_ERROR);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub EVP_PKEY_id () { &EVP_PKEY_get_id;}' unless defined(&EVP_PKEY_id);
    eval 'sub EVP_PKEY_base_id () { &EVP_PKEY_get_base_id;}' unless defined(&EVP_PKEY_base_id);
    eval 'sub EVP_PKEY_bits () { &EVP_PKEY_get_bits;}' unless defined(&EVP_PKEY_bits);
    eval 'sub EVP_PKEY_security_bits () { &EVP_PKEY_get_security_bits;}' unless defined(&EVP_PKEY_security_bits);
    eval 'sub EVP_PKEY_size () { &EVP_PKEY_get_size;}' unless defined(&EVP_PKEY_size);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_ENGINE)) {
	}
	unless(defined(&OPENSSL_NO_POLY1305)) {
	}
	unless(defined(&OPENSSL_NO_SIPHASH)) {
	}
	unless(defined(&OPENSSL_NO_DSA)) {
	}
	unless(defined(&OPENSSL_NO_DH)) {
	}
	unless(defined(&OPENSSL_NO_EC)) {
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub EVP_PKEY_set1_tls_encodedpoint {
	    my($pkey, $pt, $ptlen) = @_;
    	    eval q( &EVP_PKEY_set1_encoded_public_key(($pkey), ($pt), ($ptlen)));
	}' unless defined(&EVP_PKEY_set1_tls_encodedpoint);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub EVP_PKEY_get1_tls_encodedpoint {
	    my($pkey, $ppt) = @_;
    	    eval q( &EVP_PKEY_get1_encoded_public_key(($pkey), ($ppt)));
	}' unless defined(&EVP_PKEY_get1_tls_encodedpoint);
    }
    unless(defined(&OPENSSL_NO_SCRYPT)) {
    }
    eval 'sub EVP_PBE_TYPE_OUTER () {0x;}' unless defined(&EVP_PBE_TYPE_OUTER);
    eval 'sub EVP_PBE_TYPE_PRF () {0x1;}' unless defined(&EVP_PBE_TYPE_PRF);
    eval 'sub EVP_PBE_TYPE_KDF () {0x2;}' unless defined(&EVP_PBE_TYPE_KDF);
    eval 'sub ASN1_PKEY_ALIAS () {0x1;}' unless defined(&ASN1_PKEY_ALIAS);
    eval 'sub ASN1_PKEY_DYNAMIC () {0x2;}' unless defined(&ASN1_PKEY_DYNAMIC);
    eval 'sub ASN1_PKEY_SIGPARAM_NULL () {0x4;}' unless defined(&ASN1_PKEY_SIGPARAM_NULL);
    eval 'sub ASN1_PKEY_CTRL_PKCS7_SIGN () {0x1;}' unless defined(&ASN1_PKEY_CTRL_PKCS7_SIGN);
    eval 'sub ASN1_PKEY_CTRL_PKCS7_ENCRYPT () {0x2;}' unless defined(&ASN1_PKEY_CTRL_PKCS7_ENCRYPT);
    eval 'sub ASN1_PKEY_CTRL_DEFAULT_MD_NID () {0x3;}' unless defined(&ASN1_PKEY_CTRL_DEFAULT_MD_NID);
    eval 'sub ASN1_PKEY_CTRL_CMS_SIGN () {0x5;}' unless defined(&ASN1_PKEY_CTRL_CMS_SIGN);
    eval 'sub ASN1_PKEY_CTRL_CMS_ENVELOPE () {0x7;}' unless defined(&ASN1_PKEY_CTRL_CMS_ENVELOPE);
    eval 'sub ASN1_PKEY_CTRL_CMS_RI_TYPE () {0x8;}' unless defined(&ASN1_PKEY_CTRL_CMS_RI_TYPE);
    eval 'sub ASN1_PKEY_CTRL_SET1_TLS_ENCPT () {0x9;}' unless defined(&ASN1_PKEY_CTRL_SET1_TLS_ENCPT);
    eval 'sub ASN1_PKEY_CTRL_GET1_TLS_ENCPT () {0xa;}' unless defined(&ASN1_PKEY_CTRL_GET1_TLS_ENCPT);
    eval 'sub ASN1_PKEY_CTRL_CMS_IS_RI_TYPE_SUPPORTED () {0xb;}' unless defined(&ASN1_PKEY_CTRL_CMS_IS_RI_TYPE_SUPPORTED);
    eval 'sub EVP_PKEY_OP_UNDEFINED () {0;}' unless defined(&EVP_PKEY_OP_UNDEFINED);
    eval 'sub EVP_PKEY_OP_PARAMGEN () {(1<<1);}' unless defined(&EVP_PKEY_OP_PARAMGEN);
    eval 'sub EVP_PKEY_OP_KEYGEN () {(1<<2);}' unless defined(&EVP_PKEY_OP_KEYGEN);
    eval 'sub EVP_PKEY_OP_FROMDATA () {(1<<3);}' unless defined(&EVP_PKEY_OP_FROMDATA);
    eval 'sub EVP_PKEY_OP_SIGN () {(1<<4);}' unless defined(&EVP_PKEY_OP_SIGN);
    eval 'sub EVP_PKEY_OP_VERIFY () {(1<<5);}' unless defined(&EVP_PKEY_OP_VERIFY);
    eval 'sub EVP_PKEY_OP_VERIFYRECOVER () {(1<<6);}' unless defined(&EVP_PKEY_OP_VERIFYRECOVER);
    eval 'sub EVP_PKEY_OP_SIGNCTX () {(1<<7);}' unless defined(&EVP_PKEY_OP_SIGNCTX);
    eval 'sub EVP_PKEY_OP_VERIFYCTX () {(1<<8);}' unless defined(&EVP_PKEY_OP_VERIFYCTX);
    eval 'sub EVP_PKEY_OP_ENCRYPT () {(1<<9);}' unless defined(&EVP_PKEY_OP_ENCRYPT);
    eval 'sub EVP_PKEY_OP_DECRYPT () {(1<<10);}' unless defined(&EVP_PKEY_OP_DECRYPT);
    eval 'sub EVP_PKEY_OP_DERIVE () {(1<<11);}' unless defined(&EVP_PKEY_OP_DERIVE);
    eval 'sub EVP_PKEY_OP_ENCAPSULATE () {(1<<12);}' unless defined(&EVP_PKEY_OP_ENCAPSULATE);
    eval 'sub EVP_PKEY_OP_DECAPSULATE () {(1<<13);}' unless defined(&EVP_PKEY_OP_DECAPSULATE);
    eval 'sub EVP_PKEY_OP_TYPE_SIG () {( &EVP_PKEY_OP_SIGN |  &EVP_PKEY_OP_VERIFY |  &EVP_PKEY_OP_VERIFYRECOVER |  &EVP_PKEY_OP_SIGNCTX |  &EVP_PKEY_OP_VERIFYCTX);}' unless defined(&EVP_PKEY_OP_TYPE_SIG);
    eval 'sub EVP_PKEY_OP_TYPE_CRYPT () {( &EVP_PKEY_OP_ENCRYPT |  &EVP_PKEY_OP_DECRYPT);}' unless defined(&EVP_PKEY_OP_TYPE_CRYPT);
    eval 'sub EVP_PKEY_OP_TYPE_NOGEN () {( &EVP_PKEY_OP_TYPE_SIG |  &EVP_PKEY_OP_TYPE_CRYPT |  &EVP_PKEY_OP_DERIVE);}' unless defined(&EVP_PKEY_OP_TYPE_NOGEN);
    eval 'sub EVP_PKEY_OP_TYPE_GEN () {( &EVP_PKEY_OP_PARAMGEN |  &EVP_PKEY_OP_KEYGEN);}' unless defined(&EVP_PKEY_OP_TYPE_GEN);
    eval 'sub EVP_PKEY_CTRL_MD () {1;}' unless defined(&EVP_PKEY_CTRL_MD);
    eval 'sub EVP_PKEY_CTRL_PEER_KEY () {2;}' unless defined(&EVP_PKEY_CTRL_PEER_KEY);
    eval 'sub EVP_PKEY_CTRL_SET_MAC_KEY () {6;}' unless defined(&EVP_PKEY_CTRL_SET_MAC_KEY);
    eval 'sub EVP_PKEY_CTRL_DIGESTINIT () {7;}' unless defined(&EVP_PKEY_CTRL_DIGESTINIT);
    eval 'sub EVP_PKEY_CTRL_SET_IV () {8;}' unless defined(&EVP_PKEY_CTRL_SET_IV);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub EVP_PKEY_CTRL_PKCS7_ENCRYPT () {3;}' unless defined(&EVP_PKEY_CTRL_PKCS7_ENCRYPT);
	eval 'sub EVP_PKEY_CTRL_PKCS7_DECRYPT () {4;}' unless defined(&EVP_PKEY_CTRL_PKCS7_DECRYPT);
	eval 'sub EVP_PKEY_CTRL_PKCS7_SIGN () {5;}' unless defined(&EVP_PKEY_CTRL_PKCS7_SIGN);
	eval 'sub EVP_PKEY_CTRL_CMS_ENCRYPT () {9;}' unless defined(&EVP_PKEY_CTRL_CMS_ENCRYPT);
	eval 'sub EVP_PKEY_CTRL_CMS_DECRYPT () {10;}' unless defined(&EVP_PKEY_CTRL_CMS_DECRYPT);
	eval 'sub EVP_PKEY_CTRL_CMS_SIGN () {11;}' unless defined(&EVP_PKEY_CTRL_CMS_SIGN);
    }
    eval 'sub EVP_PKEY_CTRL_CIPHER () {12;}' unless defined(&EVP_PKEY_CTRL_CIPHER);
    eval 'sub EVP_PKEY_CTRL_GET_MD () {13;}' unless defined(&EVP_PKEY_CTRL_GET_MD);
    eval 'sub EVP_PKEY_CTRL_SET_DIGEST_SIZE () {14;}' unless defined(&EVP_PKEY_CTRL_SET_DIGEST_SIZE);
    eval 'sub EVP_PKEY_CTRL_SET1_ID () {15;}' unless defined(&EVP_PKEY_CTRL_SET1_ID);
    eval 'sub EVP_PKEY_CTRL_GET1_ID () {16;}' unless defined(&EVP_PKEY_CTRL_GET1_ID);
    eval 'sub EVP_PKEY_CTRL_GET1_ID_LEN () {17;}' unless defined(&EVP_PKEY_CTRL_GET1_ID_LEN);
    eval 'sub EVP_PKEY_ALG_CTRL () {0x1000;}' unless defined(&EVP_PKEY_ALG_CTRL);
    eval 'sub EVP_PKEY_FLAG_AUTOARGLEN () {2;}' unless defined(&EVP_PKEY_FLAG_AUTOARGLEN);
    eval 'sub EVP_PKEY_FLAG_SIGCTX_CUSTOM () {4;}' unless defined(&EVP_PKEY_FLAG_SIGCTX_CUSTOM);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub EVP_PKEY_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_EVP_PKEY, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&EVP_PKEY_get_ex_new_index);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
