/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.readers;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.Log;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.BlockCompressedAsciiLineReader;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.PositionalBufferedStream;
import java.io.IOException;
import java.io.InputStream;

public class AsciiLineReader
implements LineReader,
LocationAware {
    private static final Log log = Log.getInstance(AsciiLineReader.class);
    private static final int BUFFER_OVERFLOW_INCREASE_FACTOR = 2;
    private static final byte LINEFEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private PositionalBufferedStream is;
    private char[] lineBuffer;
    private int lineTerminatorLength = -1;

    protected AsciiLineReader() {
    }

    @Deprecated
    public AsciiLineReader(InputStream is) {
        this(new PositionalBufferedStream(is));
    }

    @Deprecated
    public AsciiLineReader(PositionalBufferedStream is) {
        this.is = is;
        this.lineBuffer = new char[10000];
    }

    public static AsciiLineReader from(InputStream inputStream) {
        if (inputStream instanceof BlockCompressedInputStream) {
            return new BlockCompressedAsciiLineReader((BlockCompressedInputStream)inputStream);
        }
        if (inputStream instanceof PositionalBufferedStream) {
            return new AsciiLineReader((PositionalBufferedStream)inputStream);
        }
        log.warn("Creating an indexable source for an AsciiFeatureCodec using a stream that is neither a PositionalBufferedStream nor a BlockCompressedInputStream");
        return new AsciiLineReader(new PositionalBufferedStream(inputStream));
    }

    @Override
    public long getPosition() {
        if (this.is == null) {
            throw new TribbleException("getPosition() called but no default stream was provided to the class on creation");
        }
        return this.is.getPosition();
    }

    public int getLineTerminatorLength() {
        return this.lineTerminatorLength;
    }

    @Deprecated
    public String readLine(PositionalBufferedStream stream) throws IOException {
        int linePosition = 0;
        while (true) {
            int b;
            if ((b = stream.read()) == -1) {
                if (linePosition > 0) {
                    this.lineTerminatorLength = 0;
                    return new String(this.lineBuffer, 0, linePosition);
                }
                return null;
            }
            char c = (char)(b & 0xFF);
            if (c == '\n' || c == '\r') {
                if (c == '\r' && stream.peek() == 10) {
                    stream.read();
                    this.lineTerminatorLength = 2;
                } else {
                    this.lineTerminatorLength = 1;
                }
                return new String(this.lineBuffer, 0, linePosition);
            }
            if (linePosition > this.lineBuffer.length - 3) {
                char[] temp = new char[2 * this.lineBuffer.length];
                System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                this.lineBuffer = temp;
            }
            this.lineBuffer[linePosition++] = c;
        }
    }

    @Override
    public String readLine() throws IOException {
        if (this.is == null) {
            throw new TribbleException("readLine() called without an explicit stream argument but no default stream was provided to the class on creation");
        }
        return this.readLine(this.is);
    }

    @Override
    public void close() {
        if (this.is != null) {
            this.is.close();
        }
        this.lineBuffer = null;
    }

    public String toString() {
        return "AsciiLineReader(" + (this.is == null ? "closed" : String.valueOf(this.is.getPosition())) + ")";
    }
}

