/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

import edu.cornell.med.icb.stat.ZScoreCalculator;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;

public abstract class PredictionStatisticCalculator {
    public double optimalThreshold;
    protected double statistic;
    protected boolean highestStatisticIsBest;
    protected double zero;
    double TP;
    double TN;
    double FN;
    double FP;

    protected void evaluateContingencyTable(double threshold, double[] decisionValues, double[] labels) {
        double[] copyOfDecisionValues = new double[decisionValues.length];
        System.arraycopy(decisionValues, 0, copyOfDecisionValues, 0, decisionValues.length);
        for (int i = 0; i < copyOfDecisionValues.length; ++i) {
            copyOfDecisionValues[i] = copyOfDecisionValues[i] < threshold ? 0.0 : 1.0;
        }
        int tp = 0;
        int tn = 0;
        int fn = 0;
        int fp = 0;
        for (int i = 0; i < copyOfDecisionValues.length; ++i) {
            double binaryDecision = copyOfDecisionValues[i];
            double trueLabel = labels[i];
            if (trueLabel == 1.0) {
                if (binaryDecision == 1.0) {
                    ++tp;
                    continue;
                }
                ++fn;
                continue;
            }
            if (binaryDecision == 0.0) {
                ++tn;
                continue;
            }
            ++fp;
        }
        this.TP = tp;
        this.TN = tn;
        this.FN = fn;
        this.FP = fp;
    }

    public abstract String getMeasureName();

    public double thresholdIndependentStatistic(ObjectList<double[]> decisionValueList, ObjectList<double[]> labelList) {
        DoubleArraySet thresholds = new DoubleArraySet();
        ObjectListIterator objectListIterator = decisionValueList.iterator();
        while (objectListIterator.hasNext()) {
            double[] decisionValues;
            for (double value : decisionValues = (double[])objectListIterator.next()) {
                thresholds.add(value);
            }
        }
        double selectedThreshold = -1.0;
        double optimalStatistic = this.highestStatisticIsBest ? Double.MIN_VALUE : Double.MAX_VALUE;
        DoubleIterator doubleIterator = thresholds.iterator();
        while (doubleIterator.hasNext()) {
            double threshold = (Double)doubleIterator.next();
            double statisticsValueAtThreshold = this.evaluateStatisticAtThreshold(threshold, decisionValueList, labelList);
            if (!(this.predictivePotential(statisticsValueAtThreshold) > this.predictivePotential(optimalStatistic))) continue;
            optimalStatistic = statisticsValueAtThreshold;
            selectedThreshold = threshold;
        }
        this.statistic = optimalStatistic;
        this.optimalThreshold = selectedThreshold;
        return this.statistic;
    }

    protected double predictivePotential(double statisticsValueAtThreshold) {
        return Math.abs(statisticsValueAtThreshold - this.zero);
    }

    public double thresholdIndependentStatistic(double[] decisionValues, double[] labels) {
        DoubleArraySet thresholds = new DoubleArraySet();
        for (double value : decisionValues) {
            thresholds.add(value);
        }
        double selectedThreshold = -1.0;
        double optimalStatistic = this.highestStatisticIsBest ? Double.MIN_VALUE : Double.MAX_VALUE;
        DoubleIterator doubleIterator = thresholds.iterator();
        while (doubleIterator.hasNext()) {
            double threshold = (Double)doubleIterator.next();
            double statisticsValueAtThreshold = this.evaluateStatisticAtThreshold(threshold, decisionValues, labels);
            if (this.highestStatisticIsBest && statisticsValueAtThreshold > optimalStatistic) {
                optimalStatistic = statisticsValueAtThreshold;
                selectedThreshold = threshold;
                continue;
            }
            if (this.highestStatisticIsBest || !(statisticsValueAtThreshold < optimalStatistic)) continue;
            optimalStatistic = statisticsValueAtThreshold;
            selectedThreshold = threshold;
        }
        this.statistic = optimalStatistic;
        this.optimalThreshold = selectedThreshold;
        return this.statistic;
    }

    public double thresholdIndependentStatisticStd(ObjectList<double[]> decisionValueList, ObjectList<double[]> trueLabelList) {
        ZScoreCalculator calc = new ZScoreCalculator();
        for (int i = 0; i < decisionValueList.size(); ++i) {
            double mccSingleSplit = this.evaluateStatisticAtThreshold(this.optimalThreshold, (double[])decisionValueList.get(i), (double[])trueLabelList.get(i));
            calc.observe(mccSingleSplit);
        }
        calc.calculateStats();
        return calc.stdDev();
    }

    public double thresholdIndependentStatisticSte(ObjectList<double[]> decisionValueList, ObjectList<double[]> trueLabelList) {
        return this.thresholdIndependentStatisticStd(decisionValueList, trueLabelList) / Math.sqrt(decisionValueList.size());
    }

    public double evaluateStatisticAtThreshold(double threshold, ObjectList<double[]> decisionValueList, ObjectList<double[]> labelList) {
        double averageStatistic = 0.0;
        double count = 0.0;
        for (int i = 0; i < decisionValueList.size(); ++i) {
            double statisticSingleSplit = this.evaluateStatisticAtThreshold(threshold, (double[])decisionValueList.get(i), (double[])labelList.get(i));
            averageStatistic += statisticSingleSplit;
            count += 1.0;
        }
        return averageStatistic / count;
    }

    public abstract double evaluateStatisticAtThreshold(double var1, double[] var3, double[] var4);
}

