/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    protected static final int TEXT_SPACING = 2;
    static final long serialVersionUID = 8012999415147721601L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int textY;
        int textX;
        Measurements mes = this.getMeasurements(c);
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        int borderWidth = width - (mes.outerSpacing.left + mes.outerSpacing.right);
        int borderHeight = height - (mes.outerSpacing.top + mes.outerSpacing.bottom);
        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class BorderPainter {
            private Component c;
            private Border b;
            private int x;
            private int y;
            private int width;
            private int height;

            public void paint(Graphics g) {
                if (this.b != null) {
                    this.b.paintBorder(this.c, g, this.x, this.y, this.width, this.height);
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final void paint(Graphics g, int clipX, int clipY, int clipWidth, int clipHeight) {
                Shape oldClip = g.getClip();
                try {
                    g.clipRect(clipX, clipY, clipWidth, clipHeight);
                    this.paint(g);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    g.setClip(oldClip);
                    throw throwable;
                }
                {
                    Object var8_9 = null;
                    g.setClip(oldClip);
                    return;
                }
            }

            public void paintExcept(Graphics g, int holeX, int holeY, int holeWidth, int holeHeight) {
                int stripeHeight = holeY - this.y;
                if (stripeHeight > 0) {
                    this.paint(g, this.x, this.y, this.width, stripeHeight);
                }
                if ((stripeHeight = holeHeight) > 0) {
                    this.paint(g, this.x, holeY, holeX - this.x, stripeHeight);
                    this.paint(g, holeX + holeWidth, holeY, this.x + this.width - (holeX + holeWidth), stripeHeight);
                }
                if ((stripeHeight = this.height - (holeY - this.y + holeHeight)) > 0) {
                    this.paint(g, this.x, this.y + this.height - stripeHeight, this.width, stripeHeight);
                }
            }

            public BorderPainter(Component c, Border b, int x, int y, int width, int height) {
                this.c = c;
                this.b = b;
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
            }
        }
        BorderPainter bp = new BorderPainter(c, this.getBorder(), x + mes.outerSpacing.left, y + mes.outerSpacing.top, borderWidth, borderHeight);
        switch (this.getRealTitleJustification(c)) {
            case 1: {
                textX = x + 2 + 5;
                break;
            }
            case 2: {
                textX = x + (borderWidth - mes.textWidth) / 2;
                break;
            }
            case 3: {
                textX = x + borderWidth - (mes.textWidth + 5);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (this.titlePosition) {
            case 1: {
                textY = y + 2;
                break;
            }
            default: {
                textY = y + mes.outerSpacing.top + mes.borderInsets.top - mes.textAscent + mes.lineHeight;
                break;
            }
            case 3: {
                textY = y + mes.outerSpacing.top + mes.borderInsets.top + 2;
                break;
            }
            case 4: {
                textY = y + height - mes.outerSpacing.bottom - mes.borderInsets.bottom - 2 - (mes.textAscent + mes.textDescent);
                break;
            }
            case 5: 
            case 6: {
                textY = y + height - (mes.textAscent + mes.textDescent);
                break;
            }
        }
        if (mes.trimmedText == null) {
            bp.paint(g);
            return;
        }
        try {
            g.setFont(mes.font);
            g.setColor(this.getTitleColor());
            g.drawString(mes.trimmedText, textX, textY + mes.textAscent);
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            g.setFont(oldFont);
            g.setColor(oldColor);
            throw throwable;
        }
        {
            Object var16_17 = null;
            g.setFont(oldFont);
            g.setColor(oldColor);
            bp.paintExcept(g, textX, textY, mes.textWidth, mes.textAscent + mes.textDescent);
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getMeasurements(c).getContentInsets(insets);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        if (this.border != null) {
            return this.border;
        }
        return UIManager.getBorder("TitledBorder.border");
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        if (this.titleFont != null) {
            return this.titleFont;
        }
        return UIManager.getFont("TitledBorder.font");
    }

    public Color getTitleColor() {
        if (this.titleColor != null) {
            return this.titleColor;
        }
        return UIManager.getColor("TitledBorder.titleColor");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int titlePosition) {
        if (titlePosition < 0 || titlePosition > 6) {
            throw new IllegalArgumentException();
        }
        this.titlePosition = titlePosition;
    }

    public void setTitleJustification(int titleJustification) {
        if (titleJustification < 0 || titleJustification > 5) {
            throw new IllegalArgumentException();
        }
        this.titleJustification = titleJustification;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(Component c) {
        return this.getMeasurements(c).getMinimumSize();
    }

    protected Font getFont(Component c) {
        Font f = this.getTitleFont();
        if (f != null) {
            return f;
        }
        return new Font("Dialog", 0, 12);
    }

    private final int getRealTitleJustification(Component c) {
        switch (this.titleJustification) {
            case 0: 
            case 4: {
                if (c == null || c.getComponentOrientation().isLeftToRight()) {
                    return 1;
                }
                return 3;
            }
            case 5: {
                if (c == null || c.getComponentOrientation().isLeftToRight()) {
                    return 3;
                }
                return 1;
            }
        }
        return this.titleJustification;
    }

    private final Measurements getMeasurements(Component c) {
        Measurements m = new Measurements();
        m.font = this.getFont(c);
        FontMetrics fmet = c.getFontMetrics(m.font);
        m.border = this.getBorder();
        m.borderInsets = m.border != null ? m.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        if (this.title != null) {
            m.trimmedText = this.title.trim();
            if (m.trimmedText.length() == 0) {
                m.trimmedText = null;
            }
        }
        if (m.trimmedText != null) {
            m.textAscent = fmet.getAscent();
            m.textDescent = fmet.getDescent() + fmet.getLeading();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
            LineMetrics lmet = m.font.getLineMetrics(m.trimmedText, 0, m.trimmedText.length(), frc);
            m.lineHeight = (int)lmet.getStrikethroughOffset();
            if (m.lineHeight == 0) {
                m.lineHeight = (int)(0.3333 * (double)m.textAscent);
            }
            m.textWidth = fmet.stringWidth(m.trimmedText) + 3;
        } else {
            m.textAscent = 0;
            m.textDescent = 0;
        }
        m.innerSpacing = new Insets(2, 2, 2, 2);
        m.outerSpacing = new Insets(2, 2, 2, 2);
        switch (this.titlePosition) {
            case 1: {
                m.outerSpacing.top += m.textAscent + m.textDescent + 2;
                break;
            }
            case 2: {
                m.outerSpacing.top += m.textDescent + m.lineHeight;
                m.innerSpacing.top += m.textAscent - m.lineHeight;
                break;
            }
            case 3: {
                m.innerSpacing.top += m.textAscent + m.textDescent + 2;
                break;
            }
            case 4: {
                m.innerSpacing.bottom += m.textAscent + m.textDescent + 2;
                break;
            }
            case 5: {
                m.innerSpacing.bottom += Math.max(m.textAscent - m.lineHeight, 0);
                m.outerSpacing.bottom += m.textDescent + m.lineHeight;
                break;
            }
            case 6: {
                m.outerSpacing.bottom += m.textAscent + m.textDescent;
                break;
            }
            default: {
                m.outerSpacing.top += m.textAscent;
            }
        }
        return m;
    }

    public TitledBorder(String title) {
        this(null, title, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String title) {
        this(border, title, 4, 2, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        this(border, title, titleJustification, titlePosition, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        this(border, title, titleJustification, titlePosition, titleFont, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this.border = border;
        this.title = title;
        this.setTitleJustification(titleJustification);
        this.setTitlePosition(titlePosition);
        this.titleFont = titleFont;
        this.titleColor = titleColor;
    }

    private static class Measurements {
        Font font;
        int textAscent;
        int textDescent;
        int lineHeight;
        String trimmedText;
        int textWidth;
        Border border;
        Insets outerSpacing;
        Insets borderInsets;
        Insets innerSpacing;

        public Insets getContentInsets(Insets i) {
            if (i == null) {
                i = new Insets(0, 0, 0, 0);
            }
            i.left = this.outerSpacing.left + this.borderInsets.left + this.innerSpacing.left;
            i.right = this.outerSpacing.right + this.borderInsets.right + this.innerSpacing.right;
            i.top = this.outerSpacing.top + this.borderInsets.top + this.innerSpacing.top;
            i.bottom = this.outerSpacing.bottom + this.borderInsets.bottom + this.innerSpacing.bottom;
            return i;
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getContentInsets(null);
            int width = Math.max(insets.left + insets.right, this.textWidth + 10);
            return new Dimension(width, insets.top + insets.bottom);
        }

        private Measurements() {
        }
    }
}

