/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class URLClassLoader
extends SecureClassLoader {
    private static HashMap urlloaders = new HashMap();
    private static HashMap factoryCache = new HashMap(5);
    private final Vector urls;
    private final Vector urlinfos;
    private final URLStreamHandlerFactory factory;
    private final AccessControlContext securityContext;
    private String thisString;

    protected void addURL(URL newUrl) {
        this.urls.add(newUrl);
        this.addURLImpl(newUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addURLImpl(URL newUrl) {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            if (newUrl == null) {
                return;
            }
            this.thisString = null;
            URLLoader loader = (URLLoader)urlloaders.get(newUrl);
            if (loader == null) {
                String file = newUrl.getFile();
                String protocol = newUrl.getProtocol();
                loader = !file.endsWith("/") && !file.endsWith(File.separator) ? new JarURLLoader(this, newUrl) : ("file".equals(protocol) ? new FileURLLoader(this, newUrl) : new RemoteURLLoader(this, newUrl));
                urlloaders.put(newUrl, loader);
            }
            this.urlinfos.add(loader);
            Vector extraUrls = loader.getClassPath();
            if (extraUrls != null) {
                Iterator it = extraUrls.iterator();
                while (it.hasNext()) {
                    URL url = (URL)it.next();
                    URLLoader extraLoader = (URLLoader)urlloaders.get(url);
                    if (this.urlinfos.contains(extraLoader)) continue;
                    this.addURLImpl(url);
                }
            }
            return;
        }
    }

    private final void addURLs(URL[] newUrls) {
        int i = 0;
        while (i < newUrls.length) {
            this.urls.add(newUrls[i]);
            this.addURLImpl(newUrls[i]);
            ++i;
        }
    }

    private final String getAttributeValue(Attributes.Name name, Attributes first, Attributes second) {
        String result = null;
        if (first != null) {
            result = first.getValue(name);
        }
        if (result == null) {
            result = second.getValue(name);
        }
        return result;
    }

    protected Package definePackage(String name, Manifest manifest, URL url) throws IllegalArgumentException {
        StringBuffer xform = new StringBuffer(name);
        int i = xform.length() - 1;
        while (i >= 0) {
            if (xform.charAt(i) == '.') {
                xform.setCharAt(i, '/');
            }
            --i;
        }
        xform.append('/');
        String xformName = xform.toString();
        Attributes entryAttr = manifest.getAttributes(xformName);
        Attributes attr = manifest.getMainAttributes();
        String specTitle = this.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, entryAttr, attr);
        String specVersion = this.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, entryAttr, attr);
        String specVendor = this.getAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, entryAttr, attr);
        String implTitle = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, entryAttr, attr);
        String implVersion = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, entryAttr, attr);
        String implVendor = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttr, attr);
        String sealed = attr.getValue(Attributes.Name.SEALED);
        if ("false".equals(sealed)) {
            url = null;
        }
        return this.definePackage(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, url);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClass(final String className) throws ClassNotFoundException {
        resourceName = className.replace('.', '/') + ".class";
        resource = this.findURLResource(resourceName);
        if (resource == null) {
            throw new ClassNotFoundException(className + " not found in " + this);
        }
        try {
            in = resource.getInputStream();
            try {
                block14: {
                    length = resource.getLength();
                    if (length == -1) break block14;
                    data = new byte[length];
                    pos = 0;
                    while (length - pos > 0) {
                        len = in.read(data, pos, length - pos);
                        if (len == -1) {
                            throw new EOFException("Not enough data reading from: " + in);
                        }
                        pos += len;
                    }
                    ** GOTO lbl-1000
                }
                out = new ByteArrayOutputStream(4096);
                b = new byte[4096];
                l = 0;
                while (true) {
                    block15: {
                        if (l != -1) break block15;
                        data = out.toByteArray();
                        break;
                    }
                    l = in.read(b);
                    if (l == -1) continue;
                    out.write(b, 0, l);
                }
            }
            catch (Throwable var6_17) {
                var7_18 = null;
                in.close();
                throw var6_17;
            }
lbl-1000:
            // 2 sources

            {
                var7_19 = null;
            }
            in.close();
            classData = data;
            source = resource.getCodeSource();
            packageName = null;
            lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            if (packageName != null && this.getPackage(packageName) == null) {
                manifest = resource.loader.getManifest();
                if (manifest == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                } else {
                    this.definePackage(packageName, manifest, resource.loader.baseURL);
                }
            }
            sm = System.getSecurityManager();
            result = null;
            result = sm != null && this.securityContext != null ? (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return URLClassLoader.this.defineClass(className, classData, 0, classData.length, source);
                }
            }, this.securityContext) : this.defineClass(className, classData, 0, classData.length, source);
            resourceCertificates = resource.getCertificates();
            if (resourceCertificates != null) {
                super.setSigners(result, resourceCertificates);
            }
            return result;
        }
        catch (IOException ioe) {
            cnfe = new ClassNotFoundException(className + " not found in " + this);
            cnfe.initCause(ioe);
            throw cnfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            block6: {
                if (this.thisString != null) break block6;
                StringBuffer sb = new StringBuffer();
                sb.append(this.getClass().getName());
                sb.append("{urls=[");
                URL[] thisURLs = this.getURLs();
                int i = 0;
                while (true) {
                    if (i >= thisURLs.length) {
                        sb.append(']');
                        sb.append(", parent=");
                        sb.append(this.getParent());
                        sb.append('}');
                        this.thisString = sb.toString();
                        break;
                    }
                    sb.append(thisURLs[i]);
                    if (i < thisURLs.length - 1) {
                        sb.append(',');
                    }
                    ++i;
                }
            }
            return this.thisString;
        }
    }

    private final Resource findURLResource(String resourceName) {
        int max = this.urlinfos.size();
        int i = 0;
        while (i < max) {
            Resource resource;
            URLLoader loader = (URLLoader)this.urlinfos.elementAt(i);
            if (loader != null && (resource = loader.getResource(resourceName)) != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public URL findResource(String resourceName) {
        Resource resource = this.findURLResource(resourceName);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URLStreamHandler getURLStreamHandler(String protocol) {
        if (this.factory == null) {
            return null;
        }
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            HashMap cache = (HashMap)factoryCache.get(this.factory);
            URLStreamHandler handler = (URLStreamHandler)cache.get(protocol);
            if (handler == null) {
                handler = this.factory.createURLStreamHandler(protocol);
                cache.put(protocol, handler);
            }
            return handler;
        }
    }

    public Enumeration findResources(String resourceName) throws IOException {
        Vector resources = new Vector();
        int max = this.urlinfos.size();
        int i = 0;
        while (i < max) {
            URLLoader loader = (URLLoader)this.urlinfos.elementAt(i);
            Resource resource = loader.getResource(resourceName);
            if (resource != null) {
                resources.add(resource.getURL());
            }
            ++i;
        }
        return resources.elements();
    }

    protected PermissionCollection getPermissions(CodeSource source) {
        PermissionCollection permissions = super.getPermissions(source);
        URL url = source.getLocation();
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String file = url.getFile();
            if (file.endsWith("/") || file.endsWith(File.separator)) {
                permissions.add(new FilePermission(file + '-', "read"));
            } else {
                permissions.add(new FilePermission(file, "read"));
            }
        } else {
            String host = url.getHost();
            if (host != null) {
                permissions.add(new SocketPermission(host, "connect,accept"));
            }
        }
        return permissions;
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    public static URLClassLoader newInstance(URL[] urls) throws SecurityException {
        return URLClassLoader.newInstance(urls, null);
    }

    public static URLClassLoader newInstance(URL[] urls, final ClassLoader parent) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new URLClassLoader(urls, parent);
        }
        final Object securityContext = sm.getSecurityContext();
        if (!(securityContext instanceof AccessControlContext)) {
            throw new SecurityException("securityContext must be AccessControlContext: " + securityContext);
        }
        URLClassLoader loader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return new URLClassLoader(parent, (AccessControlContext)securityContext);
            }
        });
        loader.addURLs(urls);
        return loader;
    }

    private final /* synthetic */ void this() {
        this.urls = new Vector();
        this.urlinfos = new Vector();
    }

    public URLClassLoader(URL[] urls) throws SecurityException {
        this.this();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(urls);
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) throws SecurityException {
        super(parent);
        this.this();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(urls);
    }

    URLClassLoader(ClassLoader parent, AccessControlContext securityContext) {
        super(parent);
        this.this();
        this.factory = null;
        this.securityContext = securityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) throws SecurityException {
        super(parent);
        this.this();
        this.securityContext = null;
        this.factory = factory;
        this.addURLs(urls);
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            if (factory != null && factoryCache.get(factory) == null) {
                factoryCache.put(factory, new HashMap(5));
            }
            return;
        }
    }

    static abstract class URLLoader {
        final URLClassLoader classloader;
        final URL baseURL;
        final CodeSource noCertCodeSource;

        abstract Resource getResource(String var1);

        Manifest getManifest() {
            return null;
        }

        Vector getClassPath() {
            return null;
        }

        URLLoader(URLClassLoader classloader, URL baseURL) {
            this(classloader, baseURL, baseURL);
        }

        URLLoader(URLClassLoader classloader, URL baseURL, URL overrideURL) {
            this.classloader = classloader;
            this.baseURL = baseURL;
            this.noCertCodeSource = new CodeSource(overrideURL, null);
        }
    }

    static final class JarURLLoader
    extends URLLoader {
        final JarFile jarfile;
        final URL baseJarURL;
        Vector classPath;

        final Resource getResource(String name) {
            JarEntry je;
            if (this.jarfile == null) {
                return null;
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((je = this.jarfile.getJarEntry(name)) != null) {
                return new JarURLResource(this, name, je);
            }
            return null;
        }

        final Manifest getManifest() {
            try {
                return this.jarfile == null ? null : this.jarfile.getManifest();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        final Vector getClassPath() {
            return this.classPath;
        }

        public JarURLLoader(URLClassLoader classloader, URL baseURL) {
            super(classloader, baseURL);
            String external = baseURL.toExternalForm();
            StringBuffer sb = new StringBuffer(external.length() + 6);
            sb.append("jar:");
            sb.append(external);
            sb.append("!/");
            String jarURL = sb.toString();
            this.classPath = null;
            URL baseJarURL = null;
            JarFile jarfile = null;
            try {
                String classPathString;
                Attributes attributes;
                baseJarURL = new URL(null, jarURL, classloader.getURLStreamHandler("jar"));
                jarfile = ((JarURLConnection)baseJarURL.openConnection()).getJarFile();
                Manifest manifest = jarfile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (classPathString = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    this.classPath = new Vector();
                    StringTokenizer st = new StringTokenizer(classPathString, " ");
                    while (st.hasMoreElements()) {
                        String e = st.nextToken();
                        try {
                            URL url = new URL(baseURL, e);
                            this.classPath.add(url);
                        }
                        catch (MalformedURLException xx) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.baseJarURL = baseJarURL;
            this.jarfile = jarfile;
        }
    }

    static final class FileURLLoader
    extends URLLoader {
        File dir;

        final Resource getResource(String name) {
            try {
                File file = new File(this.dir, name).getCanonicalFile();
                if (file.exists() && !file.isDirectory()) {
                    return new FileResource(this, file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        FileURLLoader(URLClassLoader classloader, URL url) {
            super(classloader, url);
            this.dir = new File(this.baseURL.getFile());
        }
    }

    static final class RemoteURLLoader
    extends URLLoader {
        private final String protocol;

        final Resource getResource(String name) {
            try {
                int response;
                URL url = new URL(this.baseURL, name, this.classloader.getURLStreamHandler(this.protocol));
                URLConnection connection = url.openConnection();
                int length = connection.getContentLength();
                InputStream stream = connection.getInputStream();
                if (connection instanceof HttpURLConnection && (response = ((HttpURLConnection)connection).getResponseCode()) / 100 != 2) {
                    return null;
                }
                if (stream != null) {
                    return new RemoteResource(this, name, url, stream, length);
                }
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }

        RemoteURLLoader(URLClassLoader classloader, URL url) {
            super(classloader, url);
            this.protocol = url.getProtocol();
        }
    }

    static abstract class Resource {
        final URLLoader loader;

        CodeSource getCodeSource() {
            Certificate[] certs = this.getCertificates();
            if (certs == null) {
                return this.loader.noCertCodeSource;
            }
            return new CodeSource(this.loader.baseURL, certs);
        }

        Certificate[] getCertificates() {
            return null;
        }

        abstract URL getURL();

        abstract int getLength();

        abstract InputStream getInputStream() throws IOException;

        Resource(URLLoader loader) {
            this.loader = loader;
        }
    }

    static final class FileResource
    extends Resource {
        final File file;

        final InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public final int getLength() {
            return (int)this.file.length();
        }

        public final URL getURL() {
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException e) {
                InternalError ie = new InternalError();
                ie.initCause(e);
                throw ie;
            }
        }

        FileResource(FileURLLoader loader, File file) {
            super(loader);
            this.file = file;
        }
    }

    static final class RemoteResource
    extends Resource {
        private final URL url;
        private final InputStream stream;
        private final int length;

        final InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public final int getLength() {
            return this.length;
        }

        public final URL getURL() {
            return this.url;
        }

        RemoteResource(RemoteURLLoader loader, String name, URL url, InputStream stream, int length) {
            super(loader);
            this.url = url;
            this.stream = stream;
            this.length = length;
        }
    }

    static final class JarURLResource
    extends Resource {
        private final JarEntry entry;
        private final String name;

        final InputStream getInputStream() throws IOException {
            return ((JarURLLoader)this.loader).jarfile.getInputStream(this.entry);
        }

        final int getLength() {
            return (int)this.entry.getSize();
        }

        final Certificate[] getCertificates() {
            return ((JarEntry)((JarURLLoader)this.loader).jarfile.getEntry(this.name)).getCertificates();
        }

        final URL getURL() {
            try {
                return new URL(((JarURLLoader)this.loader).baseJarURL, this.name, this.loader.classloader.getURLStreamHandler("jar"));
            }
            catch (MalformedURLException e) {
                InternalError ie = new InternalError();
                ie.initCause(e);
                throw ie;
            }
        }

        JarURLResource(JarURLLoader loader, String name, JarEntry entry) {
            super(loader);
            this.entry = entry;
            this.name = name;
        }
    }
}

