/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.ShortBufferException;

public class ExemptionMechanism {
    private static final String SERVICE = "ExemptionMechanism";
    private ExemptionMechanismSpi emSpi;
    private Provider provider;
    private String mechanism;
    private boolean virgin;

    public static final ExemptionMechanism getInstance(String mechanism) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        String msg = "";
        int i = 0;
        while (i < provs.length) {
            try {
                return ExemptionMechanism.getInstance(mechanism, provs[i]);
            }
            catch (NoSuchAlgorithmException nsae) {
                msg = nsae.getMessage();
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(msg);
    }

    public static final ExemptionMechanism getInstance(String mechanism, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return ExemptionMechanism.getInstance(mechanism, p);
    }

    public static final ExemptionMechanism getInstance(String mechanism, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new ExemptionMechanism((ExemptionMechanismSpi)Engine.getInstance(SERVICE, mechanism, provider), provider, mechanism);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ite.getCause();
            }
            throw new NoSuchAlgorithmException(mechanism);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(mechanism);
        }
    }

    public final byte[] genExemptionBlob() throws IllegalStateException, ExemptionMechanismException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGenExemptionBlob();
    }

    public final int genExemptionBlob(byte[] output) throws IllegalStateException, ExemptionMechanismException, ShortBufferException {
        return this.genExemptionBlob(output, 0);
    }

    public final int genExemptionBlob(byte[] output, int outputOffset) throws IllegalStateException, ExemptionMechanismException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGenExemptionBlob(output, outputOffset);
    }

    public final String getName() {
        return this.mechanism;
    }

    public final int getOutputSize(int inputLength) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGetOutputSize(inputLength);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws ExemptionMechanismException, InvalidKeyException {
        this.emSpi.engineInit(key);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameters params) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.emSpi.engineInit(key, params);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.emSpi.engineInit(key, params);
        this.virgin = false;
    }

    public final boolean isCryptoAllowed(Key key) throws ExemptionMechanismException {
        return true;
    }

    protected void finalize() {
    }

    protected ExemptionMechanism(ExemptionMechanismSpi emSpi, Provider provider, String mechanism) {
        this.emSpi = emSpi;
        this.provider = provider;
        this.mechanism = mechanism;
        this.virgin = true;
    }
}

