/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.compression;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.campagnelab.goby.compression.ChunkCodec;
import org.campagnelab.goby.compression.GzipOutputStreamWithCustomLevel;
import org.campagnelab.goby.compression.ProtobuffCollectionHandler;

public class GZipChunkCodec
implements ChunkCodec {
    private ProtobuffCollectionHandler parser;
    private final byte[] bytes = new byte[7];
    public static final byte REGISTRATION_CODE = -1;

    @Override
    public void setHandler(ProtobuffCollectionHandler parser) {
        this.parser = parser;
    }

    @Override
    public boolean validate(byte c, DataInputStream input) {
        try {
            int length = 7;
            if (input.read(this.bytes, 0, 7) != 7) {
                return false;
            }
            return this.bytes[3] == 31 && this.bytes[4] == -117 && this.bytes[5] == 8;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String name() {
        return "gzip";
    }

    @Override
    public byte registrationCode() {
        return -1;
    }

    @Override
    public ByteArrayOutputStream encode(Message readCollection) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(10000);
        GzipOutputStreamWithCustomLevel gzipOutputStream = new GzipOutputStreamWithCustomLevel(-1, byteBuffer);
        readCollection.writeTo((OutputStream)gzipOutputStream);
        ((OutputStream)gzipOutputStream).flush();
        ((OutputStream)gzipOutputStream).close();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message decode(byte[] bytes) throws IOException {
        try (GZIPInputStream uncompressStream = new GZIPInputStream((InputStream)new FastByteArrayInputStream(bytes));){
            GeneratedMessage generatedMessage = this.parser.parse(uncompressStream);
            return generatedMessage;
        }
    }

    @Override
    public int getSuggestedChunkSize() {
        return 10000;
    }
}

