#ifndef __STK_CONTROL
#define __STK_CONTROL
/* This file defines an interface common for the control
   as keyboard or joystick...
*/


/** The interface for a control. \\
  The axe are represented by value between -1 to 1.
  The button are pressure value (0:not used 1:used).
  It could be used as a null control.
 */
/* we have three Axe X, Y & Z and 4 buttons */
class Stk_Control
{
public:

    Stk_Control();
    
        /// Is this control Present and Working ?
    virtual int IsPresent() const;

        /// Read State of a control
    virtual void ReadState();

        /// Print Information about the control
    virtual void Print() const;
    
        /// Positon of axe X (range -1 .. 1)
    virtual float getPositionAxeX() const;
        /// Positon of axe Y (range -1 .. 1)
    virtual float getPositionAxeY() const;
        /// Positon of axe Z (range -1 .. 1)
    virtual float getPositionAxeZ() const;

        /// Position of button 1
    virtual float getButton1() const;
        /// Position of button 2
    virtual float getButton2() const;
        /// Position of button 3
    virtual float getButton3() const;
        /// Position of button 4
    virtual float getButton4() const;

    virtual ~Stk_Control();
};

#endif
