# -*- encoding: utf-8 -*-

require File.dirname(__FILE__) + '/helper.rb'
require "color/rgb/jp/compiler/compiler"

class TestCompiler < Test::Unit::TestCase

  def trad(encoding = "UTF-8", prefix = "##")
    Color::RGB::JP::Compiler::Compiler.new(
        Color::RGB::JP::Traditional,
        encoding, prefix, "test generator")
  end

  def test_execute
    r = ""
    trad.execute(StringIO.new(<<-SRC), StringIO.new(r), true)
    [##sakura-iro]
    SRC

    assert_equal(<<-EXPECTED, r)
    [#fef4f4]
    EXPECTED
  end

  def test_execute_sjis
    $KCODE = "s"
    c = trad("Shift_JIS")
    r = ""
    c.execute(StringIO.new(<<-SRC), StringIO.new(r), true)
    color: ###{Fixture::Shift_JIS::SakuraIroKanji};
    background-color: ###{Fixture::Shift_JIS::SakuraIroHiragana};
    bgcolor="###{Fixture::Shift_JIS::SakuraIroKatakana}"
    SRC

    assert_equal(<<-EXPECTED, r)
    color: #fef4f4;
    background-color: #fef4f4;
    bgcolor="#fef4f4"
    EXPECTED
  end

  def test_execute_utf8
    $KCODE = "e"
    c = trad("EUC-JP")
    r = ""
    c.execute(StringIO.new(<<-SRC), StringIO.new(r), true)
    color: ###{Fixture::EUC_JP::SakuraIroKanji};
    background-color: ###{Fixture::EUC_JP::SakuraIroHiragana};
    bgcolor="###{Fixture::EUC_JP::SakuraIroKatakana}"
    SRC

    assert_equal(<<-EXPECTED, r)
    color: #fef4f4;
    background-color: #fef4f4;
    bgcolor="#fef4f4"
    EXPECTED
  end

  def test_execute_prefix
    $KCODE = "u"
    c = trad("UTF-8", "@@")
    r = ""
    c.execute(StringIO.new(<<-SRC), StringIO.new(r), true)
    [##sakura-iro]
    [@ @sakura-iro]
    [@@ sakura-iro]
    [@@sakura-iro]
    SRC

    assert_equal(<<-EXPECTED, r)
    [##sakura-iro]
    [@ @sakura-iro]
    [@@ sakura-iro]
    [#fef4f4]
    EXPECTED
  end

  def test_execute_alias
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC), StringIO.new(r), true)
##alias myred sakura-iro
##alias mywarn myred
    [##myred]
    [##mywarn]
    SRC

    assert_equal(<<-EXPECTED, r)
    [#fef4f4]
    [#fef4f4]
    EXPECTED
  end

  def test_execute_trim_mode
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
    ##sakura-iro
    ##sakura-iro
    ##sakura-iro
    SRC

    assert_equal("#fef4f4#fef4f4#fef4f4", r)
  end

  def test_execute_trim_mode2
    $KCODE = "u"
    c = trad("UTF-8", "##")
    c.trim_mode = ""
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
    ##sakura-iro
    ##sakura-iro
    ##sakura-iro
    SRC

    assert_equal("\n#fef4f4\n#fef4f4\n#fef4f4\n", r)
  end

  def test_execute_unknown_color
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
##alias baz bazzz
##foobar
##baz
    SRC

    assert_equal("##foobar##baz", r)
  end

  def test_execute_erb
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
<%= ##sakura-iro %>
    SRC

    assert_equal("#fef4f4", r)
  end

  def test_execute_erb_include_util
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
% include Color::RGB::JP::ERBUtil
<%= lookup("sakura-iro").name.kanji %>
    SRC

    assert_equal(Fixture::UTF_8::SakuraIroKanji, r)
  end

  def test_execute_color_name_in_erb
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
<%= ##sakura-iro.class %>
<%= ##sakura-iro.html %>
    SRC

    assert_equal("Color::RGB#fef4f4", r)
  end

  def test_execute_invalid_erb
    $KCODE = "u"
    c = trad("UTF-8", "##")
    r = ""
    c.execute(StringIO.new(<<-SRC.gsub(/^    /, "")), StringIO.new(r), true)
    <%
    ##sakura-iro
    SRC

    assert_equal("\nColor::RGB::JP::ERBUtil.to_rgb(%q{sakura-iro})\n", r)
  end
end
