/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.SortKey;
import gnu.xml.xpath.Expr;
import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Node;

class XSLComparator
implements Comparator {
    final List sortKeys;

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Node && o2 instanceof Node) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            Iterator i = this.sortKeys.iterator();
            while (i.hasNext()) {
                int d;
                SortKey sortKey = (SortKey)i.next();
                String k1 = sortKey.key(n1);
                String k2 = sortKey.key(n2);
                if ("text".equals(sortKey.dataType)) {
                    Locale locale = sortKey.lang == null ? Locale.getDefault() : new Locale(sortKey.lang);
                    Collator collator = Collator.getInstance(locale);
                    int d2 = collator.compare(k1, k2);
                    if (d2 == 0) continue;
                    switch (sortKey.caseOrder) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    if (sortKey.descending) {
                        d2 = -d2;
                    }
                    return d2;
                }
                if (!"number".equals(sortKey.dataType)) continue;
                double kn1 = Expr._number(n1, k1);
                double kn2 = Expr._number(n2, k2);
                if (Double.isNaN(kn1) || Double.isInfinite(kn2)) {
                    d = -1;
                } else if (Double.isNaN(kn2) || Double.isInfinite(kn1)) {
                    d = 1;
                } else {
                    int n = 1;
                    if (!(kn1 > kn2)) {
                        int n3 = 0;
                        if (kn1 < kn2) {
                            n3 = 1;
                        }
                        n = 0 - n3;
                    }
                    d = n;
                }
                return sortKey.descending ? -d : d;
            }
        }
        return 0;
    }

    XSLComparator(List sortKeys) {
        this.sortKeys = sortKeys;
    }
}

