/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.VMObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectStreamClass
implements Serializable {
    static final Class[] noArgs = new Class[0];
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes;
    private static final long serialVersionUID = -6120832682080437368L;
    private ObjectStreamClass superClass;
    private Class clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize;
    int objectFieldCount;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    Method writeObjectMethod;
    boolean realClassIsSerializable;
    boolean realClassIsExternalizable;
    ObjectStreamField[] fieldMapping;
    Constructor firstNonSerializableParentConstructor;
    private Constructor constructor;
    boolean isProxyClass;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$io$Externalizable;

    public static ObjectStreamClass lookup(Class cl) {
        if (cl == null) {
            return null;
        }
        Class clazz = class$java$io$Serializable;
        if (clazz == null) {
            clazz = class$java$io$Serializable = ObjectStreamClass.class("[Ljava.io.Serializable;", false);
        }
        if (!clazz.isAssignableFrom(cl)) {
            return null;
        }
        return ObjectStreamClass.lookupForClassObject(cl);
    }

    static ObjectStreamClass lookupForClassObject(Class cl) {
        if (cl == null) {
            return null;
        }
        ObjectStreamClass osc = (ObjectStreamClass)classLookupTable.get(cl);
        if (osc != null) {
            return osc;
        }
        osc = new ObjectStreamClass(cl);
        classLookupTable.put(cl, osc);
        return osc;
    }

    public String getName() {
        return this.name;
    }

    public Class forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] copy = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, copy, 0, this.fields.length);
        return copy;
    }

    public ObjectStreamField getField(String name) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].getName().equals(name)) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    boolean isSerializable() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    boolean isExternalizable() {
        boolean bl = false;
        if ((this.flags & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    static ObjectStreamClass[] getObjectStreamClasses(Class clazz) {
        ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
        if (osc == null) {
            return new ObjectStreamClass[0];
        }
        Vector oscs = new Vector();
        while (osc != null) {
            oscs.addElement(osc);
            osc = osc.getSuper();
        }
        int count = oscs.size();
        ObjectStreamClass[] sorted_oscs = new ObjectStreamClass[count];
        int i = count - 1;
        while (i >= 0) {
            sorted_oscs[count - i - 1] = (ObjectStreamClass)oscs.elementAt(i);
            --i;
        }
        return sorted_oscs;
    }

    int getFlags() {
        return this.flags;
    }

    void setClass(Class cl, ObjectStreamClass superClass) throws InvalidClassException {
        this.clazz = cl;
        this.cacheMethods();
        long class_uid = this.getClassUID(cl);
        if (this.uid == 0L) {
            this.uid = class_uid;
        } else if (this.uid != class_uid) {
            String msg = cl + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + class_uid;
            throw new InvalidClassException(msg);
        }
        boolean bl = false;
        if (this.clazz != null && Proxy.isProxyClass(this.clazz)) {
            bl = true;
        }
        this.isProxyClass = bl;
        this.superClass = superClass;
        this.calculateOffsets();
        try {
            Object[] exportedFields = this.getSerialPersistentFields(this.clazz);
            if (exportedFields == null) {
                return;
            }
            ObjectStreamField[] newFieldList = new ObjectStreamField[exportedFields.length + this.fields.length];
            Arrays.sort(exportedFields);
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < this.fields.length && j < exportedFields.length) {
                int comp = this.fields[i].compareTo(exportedFields[j]);
                if (comp < 0) {
                    newFieldList[k] = this.fields[i];
                    this.fields[i].setPersistent(false);
                    this.fields[i].setToSet(false);
                    ++i;
                } else if (comp > 0) {
                    newFieldList[k] = exportedFields[j];
                    newFieldList[k].setPersistent(true);
                    newFieldList[k].setToSet(false);
                    try {
                        newFieldList[k].lookupField(this.clazz);
                        newFieldList[k].checkFieldType();
                    }
                    catch (NoSuchFieldException _) {
                        // empty catch block
                    }
                    ++j;
                } else {
                    try {
                        ((ObjectStreamField)exportedFields[j]).lookupField(this.clazz);
                        ((ObjectStreamField)exportedFields[j]).checkFieldType();
                    }
                    catch (NoSuchFieldException _) {
                        // empty catch block
                    }
                    if (!this.fields[i].getType().equals(((ObjectStreamField)exportedFields[j]).getType())) {
                        throw new InvalidClassException("serialPersistentFields must be compatible with imported fields (about " + this.fields[i].getName() + ')');
                    }
                    newFieldList[k] = this.fields[i];
                    this.fields[i].setPersistent(true);
                    ++i;
                    ++j;
                }
                ++k;
            }
            if (i < this.fields.length) {
                while (i < this.fields.length) {
                    this.fields[i].setPersistent(false);
                    this.fields[i].setToSet(false);
                    newFieldList[k] = this.fields[i];
                    ++i;
                    ++k;
                }
            } else if (j < exportedFields.length) {
                while (j < exportedFields.length) {
                    ((ObjectStreamField)exportedFields[j]).setPersistent(true);
                    ((ObjectStreamField)exportedFields[j]).setToSet(false);
                    newFieldList[k] = exportedFields[j];
                    ++j;
                    ++k;
                }
            }
            this.fields = new ObjectStreamField[k];
            System.arraycopy(newFieldList, 0, this.fields, 0, k);
        }
        catch (NoSuchFieldException ignore) {
            return;
        }
        catch (IllegalAccessException ignore) {
            return;
        }
    }

    void setSuperclass(ObjectStreamClass osc) {
        this.superClass = osc;
    }

    void calculateOffsets() {
        this.primFieldSize = 0;
        int fcount = this.fields.length;
        int i = 0;
        while (i < fcount) {
            ObjectStreamField field = this.fields[i];
            if (!field.isPrimitive()) break;
            field.setOffset(this.primFieldSize);
            switch (field.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                    break;
                }
            }
            ++i;
        }
        this.objectFieldCount = 0;
        while (i < fcount) {
            this.fields[i].setOffset(this.objectFieldCount++);
            ++i;
        }
    }

    private final Method findMethod(Method[] methods, String name, Class[] params, Class returnType, boolean mustBePrivate) {
        int i = 0;
        while (i < methods.length) {
            block4: {
                Class[] mp;
                Method m = methods[i];
                int mods = m.getModifiers();
                if (!Modifier.isStatic(mods) && (!mustBePrivate || Modifier.isPrivate(mods)) && m.getName().equals(name) && m.getReturnType() == returnType && (mp = m.getParameterTypes()).length == params.length) {
                    int j = 0;
                    while (j < mp.length) {
                        if (mp[j] == params[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    AccessController.doPrivileged(new SetAccessibleAction(m));
                    return m;
                }
            }
            ++i;
        }
        return null;
    }

    private static final boolean inSamePackage(Class c1, Class c2) {
        String name1 = c1.getName();
        String name2 = c2.getName();
        int id1 = name1.lastIndexOf(46);
        int id2 = name2.lastIndexOf(46);
        if (id1 == -1 || id2 == -1) {
            boolean bl = false;
            if (id1 == id2) {
                bl = true;
            }
            return bl;
        }
        String package1 = name1.substring(0, id1);
        String package2 = name2.substring(0, id2);
        return package1.equals(package2);
    }

    private static final Method findAccessibleMethod(String name, Class from) {
        Class c = from;
        while (c != null) {
            try {
                Method res = c.getDeclaredMethod(name, noArgs);
                int mods = res.getModifiers();
                if (c == from || Modifier.isProtected(mods) || Modifier.isPublic(mods) || !Modifier.isPrivate(mods) && ObjectStreamClass.inSamePackage(c, from)) {
                    AccessController.doPrivileged(new SetAccessibleAction(res));
                    return res;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private final void cacheMethods() {
        Method[] methods = this.forClass().getDeclaredMethods();
        Class[] classArray = new Class[1];
        Class clazz = class$java$io$ObjectInputStream;
        if (clazz == null) {
            clazz = class$java$io$ObjectInputStream = ObjectStreamClass.class("[Ljava.io.ObjectInputStream;", false);
        }
        classArray[0] = clazz;
        this.readObjectMethod = this.findMethod(methods, "readObject", classArray, Void.TYPE, true);
        Class[] classArray2 = new Class[1];
        Class clazz2 = class$java$io$ObjectOutputStream;
        if (clazz2 == null) {
            clazz2 = class$java$io$ObjectOutputStream = ObjectStreamClass.class("[Ljava.io.ObjectOutputStream;", false);
        }
        classArray2[0] = clazz2;
        this.writeObjectMethod = this.findMethod(methods, "writeObject", classArray2, Void.TYPE, true);
        this.readResolveMethod = ObjectStreamClass.findAccessibleMethod("readResolve", this.forClass());
        this.writeReplaceMethod = ObjectStreamClass.findAccessibleMethod("writeReplace", this.forClass());
    }

    private final void setFlags(Class cl) {
        Class clazz = class$java$io$Externalizable;
        if (clazz == null) {
            clazz = class$java$io$Externalizable = ObjectStreamClass.class("[Ljava.io.Externalizable;", false);
        }
        if (clazz.isAssignableFrom(cl)) {
            this.flags = (byte)(this.flags | 4);
        } else {
            Class clazz2 = class$java$io$Serializable;
            if (clazz2 == null) {
                clazz2 = class$java$io$Serializable = ObjectStreamClass.class("[Ljava.io.Serializable;", false);
            }
            if (clazz2.isAssignableFrom(cl)) {
                this.flags = (byte)(this.flags | 2);
            }
        }
        if (this.writeObjectMethod != null) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    private final void setFields(Class cl) {
        SetAccessibleAction setAccessible;
        block14: {
            setAccessible = new SetAccessibleAction();
            if (!this.isSerializable() || this.isExternalizable()) {
                this.fields = NO_FIELDS;
                return;
            }
            try {
                Field f = cl.getDeclaredField("serialPersistentFields");
                setAccessible.setMember(f);
                AccessController.doPrivileged(setAccessible);
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isPrivate(modifiers)) break block14;
                this.fields = this.getSerialPersistentFields(cl);
                if (this.fields == null) break block14;
                Arrays.sort(this.fields);
                int i = 0;
                while (i < this.fields.length) {
                    try {
                        this.fields[i].lookupField(cl);
                    }
                    catch (NoSuchFieldException _) {
                        this.fields[i].setToSet(false);
                    }
                    ++i;
                }
                this.calculateOffsets();
                return;
            }
            catch (NoSuchFieldException ignore) {
            }
            catch (IllegalAccessException num_good_fields) {
                // empty catch block
            }
        }
        int num_good_fields = 0;
        Field[] all_fields = cl.getDeclaredFields();
        int i = 0;
        while (i < all_fields.length) {
            int modifiers = all_fields[i].getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) {
                all_fields[i] = null;
            } else {
                ++num_good_fields;
            }
            ++i;
        }
        this.fields = new ObjectStreamField[num_good_fields];
        int from = 0;
        int to = 0;
        while (from < all_fields.length) {
            if (all_fields[from] != null) {
                Field f = all_fields[from];
                setAccessible.setMember(f);
                AccessController.doPrivileged(setAccessible);
                this.fields[to] = new ObjectStreamField(all_fields[from]);
                ++to;
            }
            ++from;
        }
        Arrays.sort(this.fields);
        i = 1;
        while (i < this.fields.length) {
            if (this.fields[i - 1].getName().equals(this.fields[i].getName())) {
                throw new InternalError("Duplicate field " + this.fields[i].getName() + " in class " + cl.getName());
            }
            ++i;
        }
        this.calculateOffsets();
    }

    private final long getClassUID(Class cl) {
        try {
            Field suid = cl.getDeclaredField("serialVersionUID");
            SetAccessibleAction setAccessible = new SetAccessibleAction(suid);
            AccessController.doPrivileged(setAccessible);
            int modifiers = suid.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && suid.getType() == Long.TYPE) {
                return suid.getLong(null);
            }
        }
        catch (NoSuchFieldException ignore) {
        }
        catch (IllegalAccessException md) {
            // empty catch block
        }
        try {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                Gnu gnuProvider = new Gnu();
                Security.addProvider(gnuProvider);
                md = MessageDigest.getInstance("SHA");
            }
            DigestOutputStream digest_out = new DigestOutputStream(nullOutputStream, md);
            DataOutputStream data_out = new DataOutputStream(digest_out);
            data_out.writeUTF(cl.getName());
            int modifiers = cl.getModifiers();
            data_out.writeInt(modifiers &= 0x611);
            if (!cl.isArray()) {
                Object[] interfaces = cl.getInterfaces();
                Arrays.sort(interfaces, interfaceComparator);
                int i = 0;
                while (i < interfaces.length) {
                    data_out.writeUTF(((Class)interfaces[i]).getName());
                    ++i;
                }
            }
            Object[] fields = cl.getDeclaredFields();
            Arrays.sort(fields, memberComparator);
            int i = 0;
            while (i < fields.length) {
                Object field = fields[i];
                modifiers = ((Field)field).getModifiers();
                if (!Modifier.isPrivate(modifiers) || !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers)) {
                    data_out.writeUTF(((Field)field).getName());
                    data_out.writeInt(modifiers);
                    data_out.writeUTF(TypeSignature.getEncodingOfClass(((Field)field).getType()));
                }
                ++i;
            }
            if (VMObjectStreamClass.hasClassInitializer(cl)) {
                data_out.writeUTF("<clinit>");
                data_out.writeInt(8);
                data_out.writeUTF("()V");
            }
            Object[] constructors = cl.getDeclaredConstructors();
            Arrays.sort(constructors, memberComparator);
            int i2 = 0;
            while (i2 < constructors.length) {
                Object constructor = constructors[i2];
                modifiers = ((Constructor)constructor).getModifiers();
                if (!Modifier.isPrivate(modifiers)) {
                    data_out.writeUTF("<init>");
                    data_out.writeInt(modifiers);
                    data_out.writeUTF(TypeSignature.getEncodingOfConstructor((Constructor)constructor).replace('/', '.'));
                }
                ++i2;
            }
            Object[] methods = cl.getDeclaredMethods();
            Arrays.sort(methods, memberComparator);
            int i3 = 0;
            while (i3 < methods.length) {
                Object method = methods[i3];
                modifiers = ((Method)method).getModifiers();
                if (!Modifier.isPrivate(modifiers)) {
                    data_out.writeUTF(((Method)method).getName());
                    data_out.writeInt(modifiers);
                    data_out.writeUTF(TypeSignature.getEncodingOfMethod((Method)method).replace('/', '.'));
                }
                ++i3;
            }
            data_out.close();
            byte[] sha = md.digest();
            long result = 0L;
            int len = sha.length < 8 ? sha.length : 8;
            int i4 = 0;
            while (i4 < len) {
                result += (long)(sha[i4] & 0xFF) << 8 * i4;
                ++i4;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + cl.getName(), e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private final ObjectStreamField[] getSerialPersistentFields(Class clazz) throws NoSuchFieldException, IllegalAccessException {
        ObjectStreamField[] fieldsArray = null;
        Field f = clazz.getDeclaredField("serialPersistentFields");
        f.setAccessible(true);
        int modifiers = f.getModifiers();
        if (!(Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPrivate(modifiers))) {
            return null;
        }
        ObjectStreamField[] o = (ObjectStreamField[])f.get(null);
        if (o == null) {
            return null;
        }
        fieldsArray = new ObjectStreamField[o.length];
        System.arraycopy(o, 0, fieldsArray, 0, o.length);
        return fieldsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Externalizable newInstance() throws InvalidClassException {
        block7: {
            ObjectStreamClass objectStreamClass = this;
            synchronized (objectStreamClass) {
                if (this.constructor != null) break block7;
                try {
                    final Constructor c = this.clazz.getConstructor(new Class[0]);
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public final Object run() {
                            c.setAccessible(true);
                            return null;
                        }
                    });
                    this.constructor = c;
                }
                catch (NoSuchMethodException x) {
                    throw new InvalidClassException(this.clazz.getName(), "No public zero-argument constructor");
                }
            }
        }
        try {
            return (Externalizable)this.constructor.newInstance(null);
        }
        catch (Exception x) {
            throw (InvalidClassException)new InvalidClassException(this.clazz.getName(), "Unable to instantiate").initCause(x);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.primFieldSize = -1;
        this.isProxyClass = false;
    }

    ObjectStreamClass(String name, long uid, byte flags, ObjectStreamField[] fields) {
        this.this();
        this.name = name;
        this.uid = uid;
        this.flags = flags;
        this.fields = fields;
    }

    private ObjectStreamClass(Class cl) {
        this.this();
        this.uid = 0L;
        this.flags = 0;
        this.isProxyClass = Proxy.isProxyClass(cl);
        this.clazz = cl;
        this.cacheMethods();
        this.name = cl.getName();
        this.setFlags(cl);
        this.setFields(cl);
        Class clazz = class$java$io$Serializable;
        if (clazz == null) {
            clazz = class$java$io$Serializable = ObjectStreamClass.class("[Ljava.io.Serializable;", false);
        }
        if (clazz.isAssignableFrom(cl) && !this.isProxyClass) {
            this.uid = this.getClassUID(cl);
        }
        this.superClass = ObjectStreamClass.lookup(cl.getSuperclass());
    }

    static {
        Class[] classArray = new Class[1];
        Class clazz = class$java$io$ObjectOutputStream;
        if (clazz == null) {
            clazz = class$java$io$ObjectOutputStream = ObjectStreamClass.class("[Ljava.io.ObjectOutputStream;", false);
        }
        classArray[0] = clazz;
        writeMethodArgTypes = classArray;
    }

    private static final class InterfaceComparator
    implements Comparator {
        public final int compare(Object o1, Object o2) {
            return ((Class)o1).getName().compareTo(((Class)o2).getName());
        }

        private InterfaceComparator() {
        }
    }

    private static final class MemberComparator
    implements Comparator {
        public final int compare(Object o1, Object o2) {
            Member m1 = (Member)o1;
            Member m2 = (Member)o2;
            int comp = m1.getName().compareTo(m2.getName());
            if (comp == 0) {
                return TypeSignature.getEncodingOfMember(m1).compareTo(TypeSignature.getEncodingOfMember(m2));
            }
            return comp;
        }

        private MemberComparator() {
        }
    }
}

