/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicDirectoryModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicFileChooserUI
extends FileChooserUI {
    static final int ICON_SIZE = 24;
    protected int cancelButtonMnemonic;
    protected String cancelButtonText;
    protected String cancelButtonToolTipText;
    protected Icon computerIcon;
    protected Icon detailsViewIcon;
    protected Icon directoryIcon;
    protected int directoryOpenButtonMnemonic;
    protected String directoryOpenButtonText;
    protected String directoryOpenButtonToolTipText;
    protected Icon fileIcon;
    protected Icon floppyDriveIcon;
    protected Icon hardDriveIcon;
    protected int helpButtonMnemonic;
    protected String helpButtonText;
    protected String helpButtonToolTipText;
    protected Icon homeFolderIcon;
    protected Icon listViewIcon;
    protected Icon newFolderIcon;
    protected int openButtonMnemonic;
    protected String openButtonText;
    protected String openButtonToolTipText;
    protected int saveButtonMnemonic;
    protected String saveButtonText;
    protected String saveButtonToolTipText;
    protected int updateButtonMnemonic;
    protected String updateButtonText;
    protected String updateButtonToolTipText;
    protected Icon upFolderIcon;
    JFileChooser filechooser;
    JList filelist;
    JComboBox filters;
    BasicDirectoryModel model;
    FileFilter acceptAll;
    FileView fv;
    JComboBox parents;
    String filename;
    JButton accept;
    JButton cancel;
    JButton upFolderButton;
    JButton newFolderButton;
    JButton homeFolderButton;
    JPanel accessoryPanel;
    PropertyChangeListener propertyChangeListener;
    String acceptAllFileFilterText;
    String dirDescText;
    String fileDescText;
    boolean dirSelected;
    File currDir;
    JPanel bottomPanel;
    JPanel closePanel;
    JTextField entry;
    String parentPath;

    void closeDialog() {
        Window owner = SwingUtilities.windowForComponent(this.filechooser);
        if (owner instanceof JDialog) {
            ((JDialog)owner).dispose();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicFileChooserUI((JFileChooser)c);
    }

    public void installUI(JComponent c) {
        if (c instanceof JFileChooser) {
            JFileChooser fc = (JFileChooser)c;
            fc.resetChoosableFileFilters();
            this.createModel();
            this.clearIconCache();
            this.installDefaults(fc);
            this.installComponents(fc);
            this.installListeners(fc);
            File path = this.filechooser.getCurrentDirectory();
            if (path != null) {
                this.parentPath = ((Object)path).toString().substring(((Object)path).toString().lastIndexOf("/"));
            }
        }
    }

    public void uninstallUI(JComponent c) {
        this.model = null;
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        this.filechooser = null;
    }

    void boxEntries() {
        ArrayList parentFiles = new ArrayList();
        File parent = this.filechooser.getCurrentDirectory();
        if (parent == null) {
            parent = this.filechooser.getFileSystemView().getDefaultDirectory();
        }
        while (parent != null) {
            String name = parent.getName();
            if (name.equals("")) {
                name = parent.getAbsolutePath();
            }
            parentFiles.add(parentFiles.size(), name);
            parent = parent.getParentFile();
        }
        if (parentFiles.size() == 0) {
            return;
        }
        if (this.parents.getItemCount() > 0) {
            this.parents.removeAllItems();
        }
        int i = parentFiles.size() - 1;
        while (i >= 0) {
            this.parents.addItem(parentFiles.get(i));
            --i;
        }
        this.parents.setSelectedIndex(parentFiles.size() - 1);
        this.parents.revalidate();
        this.parents.repaint();
    }

    private final ItemListener createBoxListener() {
        return new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                if (BasicFileChooserUI.this.parents.getItemCount() - 1 == BasicFileChooserUI.this.parents.getSelectedIndex()) {
                    return;
                }
                StringBuffer dir = new StringBuffer();
                int i = 0;
                while (i <= BasicFileChooserUI.this.parents.getSelectedIndex()) {
                    dir.append(BasicFileChooserUI.this.parents.getItemAt(i));
                    dir.append(File.separatorChar);
                    ++i;
                }
                BasicFileChooserUI.this.filechooser.setCurrentDirectory(BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(dir.toString()));
            }
        };
    }

    private final ItemListener createFilterListener() {
        return new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                int index = BasicFileChooserUI.this.filters.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                BasicFileChooserUI.this.filechooser.setFileFilter(BasicFileChooserUI.this.filechooser.getChoosableFileFilters()[index]);
            }
        };
    }

    void filterEntries() {
        FileFilter[] list2 = this.filechooser.getChoosableFileFilters();
        if (this.filters.getItemCount() > 0) {
            this.filters.removeAllItems();
        }
        int index = -1;
        String selected = this.filechooser.getFileFilter().getDescription();
        int i = 0;
        while (i < list2.length) {
            if (selected.equals(list2[i].getDescription())) {
                index = i;
            }
            this.filters.addItem(list2[i].getDescription());
            ++i;
        }
        this.filters.setSelectedIndex(index);
        this.filters.revalidate();
        this.filters.repaint();
    }

    public void installComponents(JFileChooser fc) {
        JLabel look = new JLabel("Look In:");
        this.parents = new JComboBox();
        this.parents.setRenderer(new BasicComboBoxRenderer());
        this.boxEntries();
        look.setLabelFor(this.parents);
        JPanel parentsPanel = new JPanel();
        parentsPanel.add(look);
        parentsPanel.add(this.parents);
        JPanel buttonPanel = new JPanel();
        this.upFolderButton = new JButton();
        this.upFolderButton.setIcon(this.upFolderIcon);
        buttonPanel.add(this.upFolderButton);
        this.homeFolderButton = new JButton();
        this.homeFolderButton = new JButton(this.homeFolderIcon);
        buttonPanel.add(this.homeFolderButton);
        this.newFolderButton = new JButton();
        this.newFolderButton.setIcon(this.newFolderIcon);
        buttonPanel.add(this.newFolderButton);
        ButtonGroup toggles = new ButtonGroup();
        JToggleButton listViewButton = new JToggleButton();
        listViewButton.setIcon(this.listViewIcon);
        toggles.add(listViewButton);
        buttonPanel.add(listViewButton);
        JToggleButton detailsViewButton = new JToggleButton();
        detailsViewButton.setIcon(this.detailsViewIcon);
        toggles.add(detailsViewButton);
        buttonPanel.add(detailsViewButton);
        JPanel topPanel = new JPanel();
        parentsPanel.add(buttonPanel);
        topPanel.setLayout(new FlowLayout(0, 0, 0));
        topPanel.add(parentsPanel);
        this.accessoryPanel = new JPanel();
        if (this.filechooser.getAccessory() != null) {
            this.accessoryPanel.add((Component)this.filechooser.getAccessory(), "Center");
        }
        this.filelist = new JList(this.model);
        this.filelist.setVisibleRowCount(6);
        JScrollPane scrollp = new JScrollPane(this.filelist);
        scrollp.setPreferredSize(new Dimension(400, 175));
        this.filelist.setBackground(Color.WHITE);
        this.filelist.setLayoutOrientation(1);
        this.filelist.setCellRenderer(new ListLabelRenderer());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel centrePanel = new JPanel();
        centrePanel.setLayout(new GridBagLayout());
        centrePanel.add((Component)scrollp, c);
        c.gridx = 1;
        centrePanel.add((Component)this.accessoryPanel, c);
        JLabel fileNameLabel = new JLabel("File Name:");
        JLabel fileTypesLabel = new JLabel("Files of Type:");
        this.entry = new JTextField();
        this.filters = new JComboBox();
        this.filterEntries();
        fileNameLabel.setLabelFor(this.entry);
        fileNameLabel.setHorizontalTextPosition(2);
        fileTypesLabel.setLabelFor(this.filters);
        fileTypesLabel.setHorizontalTextPosition(2);
        this.closePanel = new JPanel();
        this.accept = this.getApproveButton(this.filechooser);
        this.cancel = new JButton(this.cancelButtonText);
        this.cancel.setMnemonic(this.cancelButtonMnemonic);
        this.cancel.setToolTipText(this.cancelButtonToolTipText);
        this.closePanel.add(this.accept);
        this.closePanel.add(this.cancel);
        c.anchor = 17;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.add((Component)fileNameLabel, c);
        c.gridy = 1;
        this.bottomPanel.add((Component)fileTypesLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.bottomPanel.add((Component)this.entry, c);
        c.gridy = 1;
        this.bottomPanel.add((Component)this.filters, c);
        c.fill = 0;
        c.gridy = 2;
        c.anchor = 13;
        this.bottomPanel.add((Component)this.closePanel, c);
        this.filechooser.setLayout(new BorderLayout());
        this.filechooser.add((Component)topPanel, "North");
        this.filechooser.add((Component)centrePanel, "Center");
        this.filechooser.add((Component)this.bottomPanel, "South");
    }

    public void uninstallComponents(JFileChooser fc) {
        this.parents = null;
        this.accept = null;
        this.cancel = null;
        this.upFolderButton = null;
        this.homeFolderButton = null;
        this.newFolderButton = null;
        this.filelist = null;
    }

    protected void installListeners(JFileChooser fc) {
        this.propertyChangeListener = this.createPropertyChangeListener(this.filechooser);
        this.filechooser.addPropertyChangeListener(this.propertyChangeListener);
        this.accept.addActionListener(this.getApproveSelectionAction());
        this.cancel.addActionListener(this.getCancelSelectionAction());
        this.upFolderButton.addActionListener(this.getChangeToParentDirectoryAction());
        this.homeFolderButton.addActionListener(this.getGoHomeAction());
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.filters.addItemListener(this.createFilterListener());
        this.filelist.addMouseListener(this.createDoubleClickListener(this.filechooser, this.filelist));
        this.filelist.addListSelectionListener(this.createListSelectionListener(this.filechooser));
    }

    protected void uninstallListeners(JFileChooser fc) {
        this.filechooser.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults(JFileChooser fc) {
        this.installIcons(fc);
        this.installStrings(fc);
    }

    protected void uninstallDefaults(JFileChooser fc) {
        this.uninstallStrings(fc);
        this.uninstallIcons(fc);
    }

    protected void installIcons(JFileChooser fc) {
    }

    protected void uninstallIcons(JFileChooser fc) {
    }

    protected void installStrings(JFileChooser fc) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.acceptAllFileFilterText = defaults.getString("FileChooser.acceptAllFileFilterText");
        this.cancelButtonMnemonic = defaults.getInt("FileChooser.cancelButtonMnemonic");
        this.cancelButtonText = defaults.getString("FileChooser.cancelButtonText");
        this.cancelButtonToolTipText = defaults.getString("FileChooser.cancelButtonToolTipText");
        this.dirDescText = defaults.getString("FileChooser.directoryDescriptionText");
        this.fileDescText = defaults.getString("FileChooser.fileDescriptionText");
        this.helpButtonMnemonic = defaults.getInt("FileChooser.helpButtonMnemonic");
        this.helpButtonText = defaults.getString("FileChooser.helpButtonText");
        this.helpButtonToolTipText = defaults.getString("FileChooser.helpButtonToolTipText");
        this.openButtonMnemonic = defaults.getInt("FileChooser.openButtonMnemonic");
        this.openButtonText = defaults.getString("FileChooser.openButtonText");
        this.openButtonToolTipText = defaults.getString("FileChooser.openButtonToolTipText");
        this.saveButtonMnemonic = defaults.getInt("FileChooser.saveButtonMnemonic");
        this.saveButtonText = defaults.getString("FileChooser.saveButtonText");
        this.saveButtonToolTipText = defaults.getString("FileChooser.saveButtonToolTipText");
    }

    protected void uninstallStrings(JFileChooser fc) {
        this.acceptAllFileFilterText = null;
        this.cancelButtonMnemonic = 0;
        this.cancelButtonText = null;
        this.cancelButtonToolTipText = null;
        this.dirDescText = null;
        this.fileDescText = null;
        this.helpButtonMnemonic = 0;
        this.helpButtonText = null;
        this.helpButtonToolTipText = null;
        this.openButtonMnemonic = 0;
        this.openButtonText = null;
        this.openButtonToolTipText = null;
        this.saveButtonMnemonic = 0;
        this.saveButtonText = null;
        this.saveButtonToolTipText = null;
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.filechooser);
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                    if (BasicFileChooserUI.this.filechooser.getSelectedFile() == null) {
                        BasicFileChooserUI.this.setFileName(null);
                    } else {
                        BasicFileChooserUI.this.setFileName(BasicFileChooserUI.this.filechooser.getSelectedFile().toString());
                    }
                    int index = -1;
                    File file = BasicFileChooserUI.this.filechooser.getSelectedFile();
                    index = 0;
                    while (index < BasicFileChooserUI.this.model.getSize()) {
                        if (((File)BasicFileChooserUI.this.model.getElementAt(index)).equals(file)) break;
                        ++index;
                    }
                    if (index == -1) {
                        return;
                    }
                    BasicFileChooserUI.this.filelist.setSelectedIndex(index);
                    BasicFileChooserUI.this.filelist.ensureIndexIsVisible(index);
                    BasicFileChooserUI.this.filelist.revalidate();
                    BasicFileChooserUI.this.filelist.repaint();
                } else if (e.getPropertyName().equals("directoryChanged")) {
                    BasicFileChooserUI.this.filelist.clearSelection();
                    BasicFileChooserUI.this.filelist.revalidate();
                    BasicFileChooserUI.this.filelist.repaint();
                    BasicFileChooserUI.this.setDirectorySelected(false);
                    BasicFileChooserUI.this.setDirectory(BasicFileChooserUI.this.filechooser.getCurrentDirectory());
                    BasicFileChooserUI.this.boxEntries();
                } else if (e.getPropertyName().equals("ChoosableFileFilterChangedProperty") || e.getPropertyName().equals("fileFilterChanged")) {
                    BasicFileChooserUI.this.filterEntries();
                } else if (e.getPropertyName().equals("DialogTypeChangedProperty") || e.getPropertyName().equals("DialogTitleChangedProperty")) {
                    Window owner = SwingUtilities.windowForComponent(BasicFileChooserUI.this.filechooser);
                    if (owner instanceof JDialog) {
                        ((JDialog)owner).setTitle(BasicFileChooserUI.this.getDialogTitle(BasicFileChooserUI.this.filechooser));
                    }
                    BasicFileChooserUI.this.accept.setText(BasicFileChooserUI.this.getApproveButtonText(BasicFileChooserUI.this.filechooser));
                    BasicFileChooserUI.this.accept.setToolTipText(BasicFileChooserUI.this.getApproveButtonToolTipText(BasicFileChooserUI.this.filechooser));
                    BasicFileChooserUI.this.accept.setMnemonic(BasicFileChooserUI.this.getApproveButtonMnemonic(BasicFileChooserUI.this.filechooser));
                } else if (e.getPropertyName().equals("ApproveButtonTextChangedProperty")) {
                    BasicFileChooserUI.this.accept.setText(BasicFileChooserUI.this.getApproveButtonText(BasicFileChooserUI.this.filechooser));
                } else if (e.getPropertyName().equals("ApproveButtonToolTipTextChangedProperty")) {
                    BasicFileChooserUI.this.accept.setToolTipText(BasicFileChooserUI.this.getApproveButtonToolTipText(BasicFileChooserUI.this.filechooser));
                } else if (e.getPropertyName().equals("ApproveButtonMnemonicChangedProperty")) {
                    BasicFileChooserUI.this.accept.setMnemonic(BasicFileChooserUI.this.getApproveButtonMnemonic(BasicFileChooserUI.this.filechooser));
                } else if (e.getPropertyName().equals("ControlButtonsAreShownChangedProperty")) {
                    if (BasicFileChooserUI.this.filechooser.getControlButtonsAreShown()) {
                        GridBagConstraints c = new GridBagConstraints();
                        c.gridy = 1;
                        BasicFileChooserUI.this.bottomPanel.add((Component)BasicFileChooserUI.this.filters, c);
                        c.fill = 1;
                        c.gridy = 2;
                        c.anchor = 13;
                        BasicFileChooserUI.this.bottomPanel.add((Component)BasicFileChooserUI.this.closePanel, c);
                        BasicFileChooserUI.this.bottomPanel.revalidate();
                        BasicFileChooserUI.this.bottomPanel.repaint();
                        BasicFileChooserUI.this.bottomPanel.doLayout();
                    } else {
                        BasicFileChooserUI.this.bottomPanel.remove(BasicFileChooserUI.this.closePanel);
                    }
                } else if (e.getPropertyName().equals("acceptAllFileFilterUsedChanged")) {
                    if (BasicFileChooserUI.this.filechooser.isAcceptAllFileFilterUsed()) {
                        BasicFileChooserUI.this.filechooser.addChoosableFileFilter(BasicFileChooserUI.this.getAcceptAllFileFilter(BasicFileChooserUI.this.filechooser));
                    } else {
                        BasicFileChooserUI.this.filechooser.removeChoosableFileFilter(BasicFileChooserUI.this.getAcceptAllFileFilter(BasicFileChooserUI.this.filechooser));
                    }
                } else if (e.getPropertyName().equals("AccessoryChangedProperty")) {
                    JComponent newval;
                    JComponent old = (JComponent)e.getOldValue();
                    if (old != null) {
                        BasicFileChooserUI.this.getAccessoryPanel().remove(old);
                    }
                    if ((newval = (JComponent)e.getNewValue()) != null) {
                        BasicFileChooserUI.this.getAccessoryPanel().add(newval);
                    }
                }
                if (e.getPropertyName().equals("directoryChanged") || e.getPropertyName().equals("fileFilterChanged") || e.getPropertyName().equals("FileHidingChanged")) {
                    BasicFileChooserUI.this.rescanCurrentDirectory(BasicFileChooserUI.this.filechooser);
                }
                BasicFileChooserUI.this.filechooser.revalidate();
                BasicFileChooserUI.this.filechooser.repaint();
            }
        };
    }

    public String getFileName() {
        return this.filename;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public void setDirectoryName(String dirname) {
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
        this.filelist.revalidate();
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    public JButton getApproveButton(JFileChooser fc) {
        this.accept = new JButton(this.getApproveButtonText(fc));
        this.accept.setMnemonic(this.getApproveButtonMnemonic(fc));
        this.accept.setToolTipText(this.getApproveButtonToolTipText(fc));
        return this.accept;
    }

    public String getApproveButtonToolTipText(JFileChooser fc) {
        if (fc.getApproveButtonToolTipText() != null) {
            return fc.getApproveButtonToolTipText();
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return this.openButtonToolTipText;
    }

    public void clearIconCache() {
        if (this.fv instanceof BasicFileView) {
            ((BasicFileView)this.fv).clearIconCache();
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc, JList list2) {
        return new DoubleClickListener(list2);
    }

    protected boolean isDirectorySelected() {
        return this.dirSelected;
    }

    protected void setDirectorySelected(boolean selected) {
        this.dirSelected = selected;
    }

    protected File getDirectory() {
        return this.currDir;
    }

    protected void setDirectory(File f) {
        this.currDir = f;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return this.acceptAll;
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fv;
    }

    public String getDialogTitle(JFileChooser fc) {
        String ret = fc.getDialogTitle();
        if (ret != null) {
            return ret;
        }
        switch (fc.getDialogType()) {
            case 0: {
                ret = this.openButtonText;
                break;
            }
            case 1: {
                ret = this.saveButtonText;
                break;
            }
            default: {
                ret = fc.getApproveButtonText();
                break;
            }
        }
        if (ret == null) {
            ret = this.openButtonText;
        }
        return ret;
    }

    public int getApproveButtonMnemonic(JFileChooser fc) {
        if (fc.getApproveButtonMnemonic() != 0) {
            return fc.getApproveButtonMnemonic();
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return this.openButtonMnemonic;
    }

    public String getApproveButtonText(JFileChooser fc) {
        if (fc.getApproveButtonText() != null) {
            return fc.getApproveButtonText();
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return this.openButtonText;
    }

    public Action getNewFolderAction() {
        return new NewFolderAction();
    }

    public Action getGoHomeAction() {
        return new GoHomeAction();
    }

    public Action getChangeToParentDirectoryAction() {
        return new ChangeToParentDirectoryAction();
    }

    public Action getApproveSelectionAction() {
        return new ApproveSelectionAction();
    }

    public Action getCancelSelectionAction() {
        return new CancelSelectionAction();
    }

    public Action getUpdateAction() {
        return new UpdateAction();
    }

    private final /* synthetic */ void this() {
        this.computerIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        this.detailsViewIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                g.setColor(Color.GRAY);
                g.drawRect(1, 1, 15, 20);
                g.drawLine(17, 6, 23, 6);
                g.drawLine(17, 12, 23, 12);
                g.drawLine(17, 18, 23, 18);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        this.directoryIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                Point ap = new Point(3, 7);
                Point bp = new Point(3, 21);
                Point cp = new Point(21, 21);
                Point dp = new Point(21, 12);
                Point ep = new Point(16, 12);
                Point fp = new Point(13, 7);
                Polygon dir = new Polygon(new int[]{ap.x, bp.x, cp.x, dp.x, ep.x, fp.x}, new int[]{ap.y, bp.y, cp.y, dp.y, ep.y, fp.y}, 6);
                g.setColor(new Color(153, 204, 255));
                g.fillPolygon(dir);
                g.setColor(Color.BLACK);
                g.drawPolygon(dir);
                g.translate(-x, -y);
                g.setColor(saved);
            }
        };
        this.fileIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                Point a = new Point(5, 4);
                Point b = new Point(5, 20);
                Point d = new Point(19, 20);
                Point e = new Point(19, 7);
                Point f = new Point(16, 4);
                Polygon p = new Polygon(new int[]{a.x, b.x, d.x, e.x, f.x}, new int[]{a.y, b.y, d.y, e.y, f.y}, 5);
                g.setColor(Color.WHITE);
                g.fillPolygon(p);
                g.setColor(Color.BLACK);
                g.drawPolygon(p);
                g.drawLine(16, 4, 14, 6);
                g.drawLine(14, 6, 19, 7);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        this.floppyDriveIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        this.hardDriveIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        this.homeFolderIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                Point a = new Point(12, 3);
                Point b = new Point(4, 10);
                Point d = new Point(20, 10);
                Polygon p = new Polygon(new int[]{a.x, b.x, d.x}, new int[]{a.y, b.y, d.y}, 3);
                g.setColor(new Color(104, 51, 0));
                g.fillPolygon(p);
                g.setColor(Color.BLACK);
                g.drawPolygon(p);
                g.setColor(Color.WHITE);
                g.fillRect(8, 10, 8, 10);
                g.setColor(Color.BLACK);
                g.drawRect(8, 10, 8, 10);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        this.listViewIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            private final void paintPartial(Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                g.setColor(Color.GRAY);
                g.drawRect(1, 1, 7, 10);
                g.drawLine(8, 6, 11, 6);
                g.setColor(saved);
                g.translate(-x, -y);
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                this.paintPartial(g, 0, 0);
                this.paintPartial(g, 12, 0);
                this.paintPartial(g, 0, 12);
                this.paintPartial(g, 12, 12);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        this.newFolderIcon = this.directoryIcon;
        this.upFolderIcon = new Icon(){

            public final int getIconHeight() {
                return 24;
            }

            public final int getIconWidth() {
                return 24;
            }

            public final void paintIcon(Component comp, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.translate(x, y);
                Point a = new Point(3, 7);
                Point b = new Point(3, 21);
                Point c = new Point(21, 21);
                Point d = new Point(21, 12);
                Point e = new Point(16, 12);
                Point f = new Point(13, 7);
                Polygon dir = new Polygon(new int[]{a.x, b.x, c.x, d.x, e.x, f.x}, new int[]{a.y, b.y, c.y, d.y, e.y, f.y}, 6);
                g.setColor(new Color(153, 204, 255));
                g.fillPolygon(dir);
                g.setColor(Color.BLACK);
                g.drawPolygon(dir);
                a = new Point(12, 15);
                b = new Point(9, 18);
                c = new Point(15, 18);
                Polygon arrow = new Polygon(new int[]{a.x, b.x, c.x}, new int[]{a.y, b.y, c.y}, 3);
                g.fillPolygon(arrow);
                g.drawLine(12, 15, 12, 22);
                g.translate(-x, -y);
                g.setColor(saved);
            }
        };
        this.acceptAll = new AcceptAllFileFilter();
        this.fv = new BasicFileView();
        this.dirSelected = false;
        this.currDir = null;
    }

    public BasicFileChooserUI(JFileChooser b) {
        this.this();
        this.filechooser = b;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ListLabelRenderer
    extends JLabel
    implements ListCellRenderer {
        final Color selected;

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setHorizontalAlignment(2);
            File file = (File)value;
            this.setText(BasicFileChooserUI.this.filechooser.getName(file));
            this.setIcon(BasicFileChooserUI.this.filechooser.getIcon(file));
            this.setBackground(isSelected ? this.selected : Color.WHITE);
            this.setForeground(Color.BLACK);
            return this;
        }

        private final /* synthetic */ void this() {
            this.selected = new Color(153, 204, 255);
        }

        public ListLabelRenderer() {
            this.this();
            this.setOpaque(true);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache;

        public void cacheIcon(File f, Icon i) {
            this.iconCache.put(f, i);
        }

        public void clearIconCache() {
            this.iconCache.clear();
        }

        public Icon getCachedIcon(File f) {
            return (Icon)this.iconCache.get(f);
        }

        public String getDescription(File f) {
            return this.getName(f);
        }

        public Icon getIcon(File f) {
            Icon val = this.getCachedIcon(f);
            if (val != null) {
                return val;
            }
            val = BasicFileChooserUI.this.filechooser.isTraversable(f) ? BasicFileChooserUI.this.directoryIcon : BasicFileChooserUI.this.fileIcon;
            this.cacheIcon(f, val);
            return val;
        }

        public String getName(File f) {
            return f.getName();
        }

        public String getTypeDescription(File f) {
            if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                return BasicFileChooserUI.this.dirDescText;
            }
            return BasicFileChooserUI.this.fileDescText;
        }

        public Boolean isHidden(File f) {
            return BasicFileChooserUI.this.filechooser.getFileSystemView().isHiddenFile(f);
        }

        private final /* synthetic */ void this() {
            this.iconCache = new Hashtable();
        }

        public BasicFileView() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            Object f = BasicFileChooserUI.this.filelist.getSelectedValue();
            if (f == null) {
                return;
            }
            File file = BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(f.toString());
            if (!BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                BasicFileChooserUI.this.filechooser.setSelectedFile(file);
            } else {
                BasicFileChooserUI.this.filechooser.setSelectedFile(null);
            }
        }

        protected SelectionListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DoubleClickListener
    extends MouseAdapter {
        private Timer timer;
        private Object lastSelected;
        private JList list;

        public void mouseClicked(MouseEvent e) {
            if (this.list.getSelectedValue() == null) {
                return;
            }
            FileSystemView fsv = BasicFileChooserUI.this.filechooser.getFileSystemView();
            if (this.timer.isRunning() && this.list.getSelectedValue().toString().equals(this.lastSelected.toString())) {
                File f = fsv.createFileObject(this.lastSelected.toString());
                this.timer.stop();
                if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(f);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.setSelectedFile(f);
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            } else {
                String path = this.list.getSelectedValue().toString();
                File f = fsv.createFileObject(path);
                if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                    BasicFileChooserUI.this.setDirectorySelected(true);
                    BasicFileChooserUI.this.setDirectory(f);
                } else {
                    BasicFileChooserUI.this.setDirectorySelected(false);
                    BasicFileChooserUI.this.setDirectory(null);
                }
                this.lastSelected = path;
                BasicFileChooserUI.this.parentPath = path.substring(0, path.lastIndexOf("/") + 1);
                BasicFileChooserUI.this.entry.setText(path.substring(path.lastIndexOf("/") + 1));
                this.timer.restart();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        private final /* synthetic */ void this() {
            this.timer = null;
            this.lastSelected = null;
            this.list = null;
        }

        public DoubleClickListener(JList list2) {
            this.this();
            this.list = list2;
            this.timer = new Timer(1000, null);
            this.timer.setRepeats(false);
            this.lastSelected = list2.getSelectedValue();
            BasicFileChooserUI.this.setDirectorySelected(false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class NewFolderAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            try {
                BasicFileChooserUI.this.filechooser.getFileSystemView().createNewFolder(BasicFileChooserUI.this.filechooser.getCurrentDirectory());
            }
            catch (IOException ioe) {
                return;
            }
            BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
            BasicFileChooserUI.this.filechooser.repaint();
        }

        protected NewFolderAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class GoHomeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.filechooser.setCurrentDirectory(BasicFileChooserUI.this.filechooser.getFileSystemView().getHomeDirectory());
            BasicFileChooserUI.this.filechooser.revalidate();
            BasicFileChooserUI.this.filechooser.repaint();
        }

        protected GoHomeAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.filechooser.changeToParentDirectory();
            BasicFileChooserUI.this.filechooser.revalidate();
            BasicFileChooserUI.this.filechooser.repaint();
        }

        protected ChangeToParentDirectoryAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ApproveSelectionAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            String obj = new String(BasicFileChooserUI.this.parentPath + BasicFileChooserUI.this.entry.getText());
            if (obj != null) {
                File f = BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(obj.toString());
                if (BasicFileChooserUI.this.filechooser.isTraversable(f) && BasicFileChooserUI.this.filechooser.isDirectorySelectionEnabled()) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(f);
                } else {
                    BasicFileChooserUI.this.filechooser.setSelectedFile(f);
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            }
        }

        protected ApproveSelectionAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class CancelSelectionAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.filechooser.cancelSelection();
            BasicFileChooserUI.this.closeDialog();
        }

        protected CancelSelectionAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class UpdateAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        protected UpdateAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return BasicFileChooserUI.this.acceptAllFileFilterText;
        }
    }
}

