/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes = new String[]{"full", "long", "medium", "short"};
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] zoneStrings;
    transient String[] dateFormats;
    transient String[] timeFormats;

    private static final String[] getStringArray(ResourceBundle res, String name) {
        return res.getString(name).split("\u00ae");
    }

    private final String[][] getZoneStrings(ResourceBundle res) {
        try {
            boolean index = false;
            String data = res.getString("zoneStrings");
            String[] zones = data.split("\u00a9");
            String[][] array = new String[zones.length][];
            int a = 0;
            while (a < zones.length) {
                array[a] = zones[a].split("\u00ae");
                ++a;
            }
            return array;
        }
        catch (MissingResourceException e) {
            return new String[0][];
        }
    }

    private final String[] formatsForKey(ResourceBundle res, String key) {
        String[] values = new String[formatPrefixes.length];
        int i = 0;
        while (i < formatPrefixes.length) {
            values[i] = res.getString(formatPrefixes[i] + key);
            ++i;
        }
        return values;
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] value) {
        this.ampms = value;
    }

    public void setEras(String[] labels) {
        this.eras = labels;
    }

    public void setLocalPatternChars(String chars) {
        this.localPatternChars = chars;
    }

    public void setMonths(String[] labels) {
        this.months = labels;
    }

    public void setShortMonths(String[] labels) {
        this.shortMonths = labels;
    }

    public void setShortWeekdays(String[] labels) {
        this.shortWeekdays = labels;
    }

    public void setWeekdays(String[] labels) {
        this.weekdays = labels;
    }

    public void setZoneStrings(String[][] zones) {
        this.zoneStrings = zones;
    }

    private static final boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (!(x instanceof Object[]) || !(y instanceof Object[])) {
            return x.equals(y);
        }
        Object[] xa = (Object[])x;
        Object[] ya = (Object[])y;
        if (xa.length != ya.length) {
            return false;
        }
        int i = xa.length;
        while (--i >= 0) {
            if (DateFormatSymbols.equals(xa[i], ya[i])) continue;
            return false;
        }
        return true;
    }

    private static final int hashCode(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Object[])) {
            return x.hashCode();
        }
        Object[] xa = (Object[])x;
        int hash = 0;
        int i = 0;
        while (i < xa.length) {
            hash = 37 * DateFormatSymbols.hashCode(xa[i]);
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols other = (DateFormatSymbols)obj;
        boolean bl = false;
        if (DateFormatSymbols.equals(this.ampms, other.ampms) && DateFormatSymbols.equals(this.eras, other.eras) && DateFormatSymbols.equals(this.localPatternChars, other.localPatternChars) && DateFormatSymbols.equals(this.months, other.months) && DateFormatSymbols.equals(this.shortMonths, other.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, other.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, other.weekdays) && DateFormatSymbols.equals(this.zoneStrings, other.zoneStrings)) {
            bl = true;
        }
        return bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }

    public DateFormatSymbols(Locale locale) throws MissingResourceException {
        ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
        this.ampms = DateFormatSymbols.getStringArray(res, "ampms");
        this.eras = DateFormatSymbols.getStringArray(res, "eras");
        this.localPatternChars = res.getString("localPatternChars");
        this.months = DateFormatSymbols.getStringArray(res, "months");
        this.shortMonths = DateFormatSymbols.getStringArray(res, "shortMonths");
        this.shortWeekdays = DateFormatSymbols.getStringArray(res, "shortWeekdays");
        this.weekdays = DateFormatSymbols.getStringArray(res, "weekdays");
        this.zoneStrings = this.getZoneStrings(res);
        this.dateFormats = this.formatsForKey(res, "DateFormat");
        this.timeFormats = this.formatsForKey(res, "TimeFormat");
    }

    public DateFormatSymbols() throws MissingResourceException {
        this(Locale.getDefault());
    }
}

