/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.CompoundType;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5CompoundReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5CompoundWriter;
import ch.systemsx.cisd.hdf5.IHDF5EnumWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.List;
import java.util.Map;

class HDF5CompoundWriter
extends HDF5CompoundReader
implements IHDF5CompoundWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5CompoundWriter(HDF5BaseWriter baseWriter, IHDF5EnumWriter enumWriter) {
        super((HDF5BaseReader)baseWriter, enumWriter);
        this.baseWriter = baseWriter;
    }

    private <T> HDF5CompoundType<T> getType(final String nameOrNull, boolean anonymousType, Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        this.baseWriter.checkOpen();
        HDF5ValueObjectByteifyer<T> objectByteifyer = this.baseWriter.createCompoundByteifyers(pojoClass, members, null);
        String dataTypeName = anonymousType ? null : (nameOrNull != null ? nameOrNull : this.deriveCompoundNameFromClass(pojoClass));
        final int storageDataTypeId = this.getOrCreateCompoundDataType(dataTypeName, objectByteifyer, this.baseWriter.keepDataSetIfExists);
        int nativeDataTypeId = this.baseWriter.createNativeCompoundDataType(objectByteifyer);
        return new HDF5CompoundType<T>(this.baseWriter.fileId, storageDataTypeId, nativeDataTypeId, dataTypeName, pojoClass, objectByteifyer, new HDF5CompoundType.IHDF5InternalCompoundMemberInformationRetriever(){

            @Override
            public HDF5CompoundMemberInformation[] getCompoundMemberInformation(HDF5DataTypeInformation.DataTypeInfoOptions dataTypeOptions) {
                return HDF5CompoundWriter.this.getCompoundMemberInformation(storageDataTypeId, nameOrNull, dataTypeOptions);
            }
        }, this.baseReader);
    }

    @Override
    public <T> HDF5CompoundType<T> getType(String name, Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.getType(name, false, pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getAnonType(Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.getType(null, true, pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredAnonType(Class<T> pojoClass, HDF5CompoundMappingHints hints) {
        return this.getType(null, true, pojoClass, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(pojoClass), hints)));
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredAnonType(Class<T> pojoClass) {
        return this.getInferredAnonType((T)pojoClass, null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredAnonType(T template) {
        return this.getInferredAnonType(template, null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredAnonType(T pojo, HDF5CompoundMappingHints hints) {
        if (Map.class.isInstance(pojo)) {
            return this.getType(null, true, Map.class, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping((Map)pojo), hints)));
        }
        Class<?> pojoClass = pojo.getClass();
        return this.getType(null, true, pojoClass, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(pojo, HDF5CompoundMemberMapping.inferEnumerationTypeMap(pojo, this.enumTypeRetriever)), hints)));
    }

    private <T> HDF5CompoundType<T> getType(String name, boolean anonymousType, HDF5CompoundType<T> templateType) {
        this.baseWriter.checkOpen();
        templateType.checkOpen();
        HDF5ValueObjectByteifyer<T> objectByteifyer = templateType.getObjectByteifyer();
        String dataTypeName = anonymousType ? null : (name == null ? templateType.getName() : name);
        int storageDataTypeId = this.getOrCreateCompoundDataType(dataTypeName, objectByteifyer, this.baseWriter.keepDataSetIfExists);
        return this.getType(dataTypeName, storageDataTypeId, templateType.getCompoundType(), objectByteifyer);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredAnonType(T[] template) {
        return this.getInferredAnonType(template, (HDF5CompoundMappingHints)null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredAnonType(T[] template, HDF5CompoundMappingHints hints) {
        Class<?> componentType = template.getClass().getComponentType();
        if (template.length == 0) {
            return this.getInferredAnonType((T)componentType, hints);
        }
        if (Map.class.isAssignableFrom(componentType)) {
            return this.getType(null, true, Map.class, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping((Map)template[0]), hints)));
        }
        return this.getType(null, true, componentType, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(template, HDF5CompoundMemberMapping.inferEnumerationTypeMap(template, this.enumTypeRetriever)), hints)));
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredAnonType(List<String> memberNames, List<?> template, HDF5CompoundMappingHints hints) {
        HDF5CompoundType<List<?>> type = this.getType(null, true, List.class, HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(memberNames, template), hints));
        return type;
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredAnonType(List<String> memberNames, List<?> template) {
        return this.getInferredAnonType(memberNames, template, null);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredAnonType(String[] memberNames, Object[] template) {
        return this.getInferredAnonType(memberNames, template, null);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredAnonType(String[] memberNames, Object[] template, HDF5CompoundMappingHints hints) {
        HDF5CompoundType<List> type = this.getType(null, true, List.class, HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(memberNames, template), hints));
        return type;
    }

    @Override
    public <T> HDF5CompoundType<T> getClonedType(HDF5CompoundType<T> templateType) {
        return this.getType(null, false, templateType);
    }

    private <T> String deriveCompoundNameFromClass(Class<T> pojoClass) {
        CompoundType ct = pojoClass.getAnnotation(CompoundType.class);
        String name = ct != null ? ct.name() : "";
        return name.length() == 0 ? pojoClass.getSimpleName() : name;
    }

    private <T> int getOrCreateCompoundDataType(String dataTypeName, HDF5ValueObjectByteifyer<T> objectByteifyer, boolean committedDataTypeHasPreference) {
        boolean commitType;
        boolean dataTypeNameGiven = dataTypeName != null && !"UNKNOWN".equals(dataTypeName);
        String dataTypePath = dataTypeNameGiven ? HDF5Utils.createDataTypePath("Compound_", this.baseWriter.houseKeepingNameSuffix, dataTypeName) : null;
        int committedStorageDataTypeId = dataTypeNameGiven ? this.baseWriter.getDataTypeId(dataTypePath) : -1;
        boolean typeExists = committedStorageDataTypeId >= 0;
        int storageDataTypeId = committedStorageDataTypeId;
        if (!typeExists || !committedDataTypeHasPreference) {
            storageDataTypeId = this.baseWriter.createStorageCompoundDataType(objectByteifyer);
            boolean typesAreEqual = typeExists && this.baseWriter.h5.dataTypesAreEqual(committedStorageDataTypeId, storageDataTypeId);
            boolean bl = commitType = dataTypeNameGiven && (!typeExists || !typesAreEqual);
            if (typeExists && commitType) {
                String replacementDataTypePath = this.baseWriter.moveLinkOutOfTheWay(dataTypePath);
                this.baseReader.renameNamedDataType(dataTypePath, replacementDataTypePath);
            }
            if (typesAreEqual) {
                storageDataTypeId = committedStorageDataTypeId;
            }
        } else {
            commitType = false;
        }
        if (commitType) {
            this.baseWriter.commitDataType(dataTypePath, storageDataTypeId);
            HDF5EnumerationValueArray typeVariants = this.tryCreateDataTypeVariantArray(objectByteifyer);
            if (typeVariants != null) {
                this.baseWriter.setEnumArrayAttribute(dataTypePath, HDF5Utils.getTypeVariantMembersAttributeName(this.baseWriter.houseKeepingNameSuffix), typeVariants);
            }
        }
        return storageDataTypeId;
    }

    private <T> HDF5EnumerationValueArray tryCreateDataTypeVariantArray(HDF5ValueObjectByteifyer<T> objectByteifyer) {
        byte[] typeVariantOrdinals = new byte[objectByteifyer.getByteifyers().length];
        boolean hasTypeVariants = false;
        int i = 0;
        while (i < typeVariantOrdinals.length) {
            typeVariantOrdinals[i] = (byte)objectByteifyer.getByteifyers()[i].getTypeVariant().ordinal();
            hasTypeVariants |= HDF5DataTypeVariant.isTypeVariant(typeVariantOrdinals[i]);
            ++i;
        }
        return hasTypeVariants ? new HDF5EnumerationValueArray(this.baseWriter.typeVariantDataType, typeVariantOrdinals) : null;
    }

    @Override
    public <T> void setAttr(String objectPath, String attributeName, HDF5CompoundType<T> type, T data) {
        this.primSetCompoundAttribute(objectPath, attributeName, type, data, null);
    }

    @Override
    public <T> void setAttr(String objectPath, String attributeName, T data) {
        HDF5CompoundType<T> inferredCompoundType = this.getInferredType(data);
        inferredCompoundType.checkMappingComplete();
        this.primSetCompoundAttribute(objectPath, attributeName, inferredCompoundType, data, null);
    }

    @Override
    public <T> void setArrayAttr(String objectPath, String attributeName, HDF5CompoundType<T> type, T[] value) {
        this.baseWriter.setCompoundArrayAttribute(objectPath, attributeName, type, value, null);
    }

    @Override
    public <T> void setArrayAttr(String objectPath, String attributeName, T[] value) {
        HDF5CompoundType<Class<?>> inferredCompoundType = this.getInferredType(value.getClass().getComponentType());
        inferredCompoundType.checkMappingComplete();
        this.baseWriter.setCompoundArrayAttribute(objectPath, attributeName, inferredCompoundType, value, null);
    }

    @Override
    public <T> void setMDArrayAttr(String objectPath, String attributeName, HDF5CompoundType<T> type, MDArray<T> value) {
        this.baseWriter.setCompoundMDArrayAttribute(objectPath, attributeName, type, value, null);
    }

    @Override
    public <T> void setMDArrayAttr(String objectPath, String attributeName, MDArray<T> value) {
        HDF5CompoundType<Class<?>> inferredCompoundType = this.getInferredType(value.getAsFlatArray().getClass().getComponentType());
        inferredCompoundType.checkMappingComplete();
        this.baseWriter.setCompoundMDArrayAttribute(objectPath, attributeName, inferredCompoundType, value, null);
    }

    private <T> void primSetCompoundAttribute(String objectPath, String attributeName, HDF5CompoundType<?> type, T data, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
        if (inspectorOrNull != null) {
            inspectorOrNull.inspect(byteArray);
        }
        this.baseWriter.setAttribute(objectPath, attributeName, type.getStorageTypeId(), type.getNativeTypeId(), byteArray);
    }

    @Override
    public <T> void write(String objectPath, HDF5CompoundType<T> type, T data) {
        this.primWriteCompound(objectPath, type, data, null);
    }

    @Override
    public <T> void write(String objectPath, HDF5CompoundType<T> type, T data, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.primWriteCompound(objectPath, type, data, inspectorOrNull);
    }

    private <T> void primWriteCompound(String objectPath, HDF5CompoundType<?> type, T data, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
        if (inspectorOrNull != null) {
            inspectorOrNull.inspect(byteArray);
        }
        this.baseWriter.writeScalar(objectPath, type.getStorageTypeId(), type.getNativeTypeId(), byteArray);
    }

    @Override
    public <T> void write(String objectPath, T data) {
        HDF5CompoundType<T> inferredCompoundType = this.getInferredType(data);
        inferredCompoundType.checkMappingComplete();
        this.primWriteCompound(objectPath, inferredCompoundType, data, null);
    }

    @Override
    public <T> void writeArray(String objectPath, HDF5CompoundType<T> type, T[] data) {
        this.primWriteCompoundArray(objectPath, type, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, null);
    }

    @Override
    public <T> void writeArray(String objectPath, HDF5CompoundType<T> type, T[] data, HDF5GenericStorageFeatures features) {
        this.primWriteCompoundArray(objectPath, type, data, features, null);
    }

    @Override
    public <T> void writeArray(String objectPath, HDF5CompoundType<T> type, T[] data, HDF5GenericStorageFeatures features, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        this.primWriteCompoundArray(objectPath, type, data, features, inspectorOrNull);
    }

    private <T> void primWriteCompoundArray(final String objectPath, final HDF5CompoundType<?> type, final T[] data, final HDF5GenericStorageFeatures features, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (type != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5CompoundWriter.this.baseWriter.getOrCreateDataSetId(objectPath, type.getStorageTypeId(), new long[]{data.length}, type.getObjectByteifyer().getRecordSize(), features, registry);
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                H5D.H5Dwrite(dataSetId, type.getNativeTypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byteArray);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void writeArray(String objectPath, T[] data) {
        this.writeArray(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void writeArray(String objectPath, T[] data, HDF5GenericStorageFeatures features) {
        assert (data != null && data.length > 0);
        HDF5CompoundType<T[]> inferredCompoundType = this.getInferredType(data);
        inferredCompoundType.checkMappingComplete();
        this.primWriteCompoundArray(objectPath, inferredCompoundType, data, features, null);
    }

    @Override
    public <T> void writeArrayBlock(String objectPath, HDF5CompoundType<T> type, T[] data, long blockNumber) {
        this.writeArrayBlock(objectPath, type, data, blockNumber, null);
    }

    @Override
    public <T> void writeArrayBlock(final String objectPath, final HDF5CompoundType<T> type, final T[] data, final long blockNumber, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (type != null);
        assert (data != null);
        assert (blockNumber >= 0L);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long size = data.length;
                long[] dimensions = new long[]{size};
                long[] offset = new long[]{size * blockNumber};
                int dataSetId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileId, objectPath, ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileFormat, new long[]{(long)data.length * (blockNumber + 1L)}, -1, registry);
                int dataSpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                H5D.H5Dwrite(dataSetId, type.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, byteArray);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void writeArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, T[] data, long offset) {
        this.writeArrayBlockWithOffset(objectPath, type, data, offset, null);
    }

    @Override
    public <T> void writeArrayBlockWithOffset(final String objectPath, final HDF5CompoundType<T> type, final T[] data, final long offset, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (type != null);
        assert (data != null);
        assert (offset >= 0L);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        long size = data.length;
        final long[] dimensions = new long[]{size};
        final long[] offsetArray = new long[]{offset};
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileId, objectPath, ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileFormat, new long[]{offset + (long)data.length}, -1, registry);
                int dataSpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offsetArray, dimensions);
                int memorySpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                H5D.H5Dwrite(dataSetId, type.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, byteArray);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void createArray(String objectPath, HDF5CompoundType<T> type, int size) {
        this.createArray(objectPath, type, (long)size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void createArray(String objectPath, HDF5CompoundType<T> type, long size, int blockSize) {
        this.createArray(objectPath, type, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void createArray(final String objectPath, final HDF5CompoundType<T> type, final long size, final int blockSize, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (type != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5CompoundWriter.this.baseWriter.createDataSet(objectPath, type.getStorageTypeId(), features, new long[]{size}, new long[]{blockSize}, type.getObjectByteifyer().getRecordSize(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void createArray(final String objectPath, final HDF5CompoundType<T> type, final long size, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (type != null);
        assert (size >= 0L);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5CompoundWriter.this.baseWriter.createDataSet(objectPath, type.getStorageTypeId(), features, new long[1], new long[]{size}, type.getObjectByteifyer().getRecordSize(), registry);
                } else {
                    HDF5CompoundWriter.this.baseWriter.createDataSet(objectPath, type.getStorageTypeId(), features, new long[]{size}, null, type.getObjectByteifyer().getRecordSize(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void writeMDArray(String objectPath, HDF5CompoundType<T> type, MDArray<T> data) {
        this.writeMDArray(objectPath, type, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void writeMDArray(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, HDF5GenericStorageFeatures features) {
        this.writeMDArray(objectPath, type, data, features, null);
    }

    @Override
    public <T> void writeMDArray(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, HDF5GenericStorageFeatures features, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (type != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        this.primWriteCompoundMDArray(objectPath, type, data, features, inspectorOrNull);
    }

    private <T> void primWriteCompoundMDArray(final String objectPath, final HDF5CompoundType<T> type, final MDArray<T> data, final HDF5GenericStorageFeatures features, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5CompoundWriter.this.baseWriter.getOrCreateDataSetId(objectPath, type.getStorageTypeId(), MDAbstractArray.toLong(data.dimensions()), type.getObjectByteifyer().getRecordSize(), features, registry);
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data.getAsFlatArray());
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                H5D.H5Dwrite(dataSetId, type.getNativeTypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byteArray);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void writeMDArrayBlock(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] blockNumber) {
        this.writeMDArrayBlock(objectPath, type, data, blockNumber, null);
    }

    @Override
    public <T> void writeMDArrayBlock(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        long[] dataSetDimensions = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            dataSetDimensions[i] = offset[i] + dimensions[i];
            ++i;
        }
        this.writeCompoundMDArrayBlockWithOffset(objectPath, type, data.getAsFlatArray(), dimensions, offset, dataSetDimensions, inspectorOrNull);
    }

    @Override
    public <T> void writeMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] offset) {
        this.writeMDArrayBlockWithOffset(objectPath, type, data, offset, null);
    }

    @Override
    public <T> void writeMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, long[] offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        long[] dimensions = data.longDimensions();
        long[] dataSetDimensions = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            dataSetDimensions[i] = offset[i] + dimensions[i];
            ++i;
        }
        this.writeCompoundMDArrayBlockWithOffset(objectPath, type, data.getAsFlatArray(), dimensions, offset, dataSetDimensions, inspectorOrNull);
    }

    private <T> void writeCompoundMDArrayBlockWithOffset(final String objectPath, final HDF5CompoundType<T> type, final T[] data, final long[] dimensions, final long[] offset, final long[] dataSetDimensions, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (type != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileId, objectPath, ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                H5D.H5Dwrite(dataSetId, type.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, byteArray);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void writeMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, MDArray<T> data, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        this.writeMDArrayBlockWithOffset(objectPath, type, data, blockDimensions, offset, memoryOffset, null);
    }

    @Override
    public <T> void writeMDArrayBlockWithOffset(final String objectPath, final HDF5CompoundType<T> type, final MDArray<T> data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (type != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                long[] longBlockDimensions = MDAbstractArray.toLong(blockDimensions);
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileId, objectPath, ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5CompoundWriter)HDF5CompoundWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDAbstractArray.toLong(memoryOffset), longBlockDimensions);
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data.getAsFlatArray());
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                H5D.H5Dwrite(dataSetId, type.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, byteArray);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void createMDArray(String objectPath, HDF5CompoundType<T> type, int[] dimensions) {
        this.createMDArray(objectPath, type, dimensions, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void createMDArray(String objectPath, HDF5CompoundType<T> type, long[] dimensions, int[] blockDimensions) {
        this.createMDArray(objectPath, type, dimensions, blockDimensions, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void createMDArray(final String objectPath, final HDF5CompoundType<T> type, final long[] dimensions, final int[] blockDimensions, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (type != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5CompoundWriter.this.baseWriter.createDataSet(objectPath, type.getStorageTypeId(), features, dimensions, MDAbstractArray.toLong(blockDimensions), type.getObjectByteifyer().getRecordSize(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void createMDArray(final String objectPath, final HDF5CompoundType<T> type, final int[] dimensions, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (type != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        type.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5CompoundWriter.this.baseWriter.createDataSet(objectPath, type.getStorageTypeId(), features, nullDimensions, MDAbstractArray.toLong(dimensions), type.getObjectByteifyer().getRecordSize(), registry);
                } else {
                    HDF5CompoundWriter.this.baseWriter.createDataSet(objectPath, type.getStorageTypeId(), features, MDAbstractArray.toLong(dimensions), null, type.getObjectByteifyer().getRecordSize(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public <T> void writeMDArray(String objectPath, MDArray<T> data) {
        this.writeMDArray(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public <T> void writeMDArray(String objectPath, MDArray<T> data, HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null && data.size() > 0);
        this.baseWriter.checkOpen();
        HDF5CompoundType<T[]> inferredCompoundType = this.getInferredType(data.getAsFlatArray());
        inferredCompoundType.checkMappingComplete();
        this.primWriteCompoundMDArray(objectPath, inferredCompoundType, data, features, null);
    }
}

