/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.id.ObjectId;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class Location {
    private ClassReferenceTypeId crti;
    private int index;
    private byte tag;
    private ObjectId mid;

    public void write(DataOutputStream os) throws IOException {
        os.writeByte(this.tag);
        this.crti.write(os);
        this.mid.write(os);
        os.writeInt(this.index);
    }

    public Location(byte tag, Class clazz, Method meth, int index) throws JdwpException {
        this.tag = tag;
        this.crti = (ClassReferenceTypeId)VMIdManager.getDefault().getReferenceTypeId(clazz);
        this.mid = VMIdManager.getDefault().getObjectId(meth);
        this.index = index;
    }

    public Location(ByteBuffer bb) throws IOException, JdwpException {
        this.tag = bb.get();
        this.crti = (ClassReferenceTypeId)VMIdManager.getDefault().readReferenceTypeId(bb);
        this.mid = VMIdManager.getDefault().readObjectId(bb);
        this.index = bb.getInt();
    }
}

