/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GdkGraphics
extends Graphics {
    static final int GDK_COPY = 0;
    static final int GDK_XOR = 2;
    private final int native_state;
    Color color;
    Color xorColor;
    GtkComponentPeer component;
    Font font;
    Rectangle clip;
    GtkImage image;
    int xOffset;
    int yOffset;

    static native void initStaticState();

    native void initState(GtkComponentPeer var1);

    native void initStateUnlocked(GtkComponentPeer var1);

    native void initState(int var1, int var2);

    native void initFromImage(GtkImage var1);

    native void copyState(GdkGraphics var1);

    void initComponentGraphics() {
        this.initState(this.component);
        this.color = this.component.awtComponent.getForeground();
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        Dimension d = this.component.awtComponent.getSize();
        this.clip = new Rectangle(0, 0, d.width, d.height);
    }

    void initComponentGraphicsUnlocked() {
        this.initStateUnlocked(this.component);
        this.color = this.component.awtComponent.getForeground();
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        Dimension d = this.component.awtComponent.getSize();
        this.clip = new Rectangle(0, 0, d.width, d.height);
    }

    native void connectSignals(GtkComponentPeer var1);

    public native void clearRect(int var1, int var2, int var3, int var4);

    public void clipRect(int x, int y, int width, int height) {
        if (this.component != null && !this.component.isRealized()) {
            return;
        }
        this.clip = this.clip.intersection(new Rectangle(x, y, width, height));
        this.setClipRectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public Graphics create() {
        return new GdkGraphics(this);
    }

    public native void dispose();

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(null), img.getHeight(null), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkImage) {
            return ((GtkImage)img).drawImage(this, x, y, width, height, bgcolor, observer);
        }
        return new GtkImage(img.getSource()).drawImage(this, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkImage) {
            return ((GtkImage)img).drawImage(this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }
        return new GtkImage(img.getSource()).drawImage(this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawPolyline(int[] var1, int[] var2, int var3);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    GdkFontPeer getFontPeer() {
        return (GdkFontPeer)this.getFont().getPeer();
    }

    native void drawString(GdkFontPeer var1, String var2, int var3, int var4);

    public void drawString(String str, int x, int y) {
        this.drawString(this.getFontPeer(), str, x, y);
    }

    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        throw new Error("not implemented");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
        this.drawArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.drawArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.drawArc(x, yy, arcWidth, arcHeight, 180, 90);
        int y1 = y + arcHeight / 2;
        int y2 = y + height - arcHeight / 2;
        this.drawLine(x, y1, x, y2);
        this.drawLine(x + width, y1, x + width, y2);
        int x1 = x + arcWidth / 2;
        int x2 = x + width - arcWidth / 2;
        this.drawLine(x1, y, x2, y);
        this.drawLine(x1, y + height, x2, y + height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.fillArc(x, y, arcWidth, arcHeight, 90, 90);
        this.fillArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.fillArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.fillArc(x, yy, arcWidth, arcHeight, 180, 90);
        this.fillRect(x, y + arcHeight / 2, width, height - arcHeight + 1);
        this.fillRect(x + arcWidth / 2, y, width - arcWidth + 1, height);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return new GdkFontMetrics(font);
    }

    native void setClipRectangle(int var1, int var2, int var3, int var4);

    public void setClip(int x, int y, int width, int height) {
        if (this.component != null && !this.component.isRealized() || this.clip == null) {
            return;
        }
        this.clip.x = x;
        this.clip.y = y;
        this.clip.width = width;
        this.clip.height = height;
        this.setClipRectangle(x, y, width, height);
    }

    public void setClip(Rectangle clip) {
        this.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public void setClip(Shape clip) {
        if (clip == null) {
            Dimension d = this.component.awtComponent.getSize();
            this.setClip(new Rectangle(0, 0, d.width, d.height));
        } else {
            this.setClip(clip.getBounds());
        }
    }

    private final native void setFGColor(int var1, int var2, int var3);

    public void setColor(Color c) {
        this.color = c == null ? Color.BLACK : c;
        if (this.xorColor == null) {
            this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        } else {
            this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    native void setFunction(int var1);

    public void setPaintMode() {
        this.xorColor = null;
        this.setFunction(0);
        this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void setXORMode(Color c) {
        this.xorColor = c;
        this.setFunction(2);
        this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
    }

    public native void translateNative(int var1, int var2);

    public void translate(int x, int y) {
        if (this.component != null && !this.component.isRealized()) {
            return;
        }
        this.clip.x -= x;
        this.clip.y -= y;
        this.translateNative(x, y);
    }

    private final /* synthetic */ void this() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.font = new Font("Dialog", 0, 12);
        this.xOffset = 0;
        this.yOffset = 0;
    }

    GdkGraphics(GdkGraphics g) {
        this.this();
        this.color = g.color;
        this.xorColor = g.xorColor;
        this.font = g.font;
        if (this.font == null) {
            this.font = new Font("Dialog", 0, 12);
        }
        this.clip = new Rectangle(g.clip);
        this.component = g.component;
        this.copyState(g);
    }

    GdkGraphics(int width, int height) {
        this.this();
        this.initState(width, height);
        this.color = Color.black;
        this.clip = new Rectangle(0, 0, width, height);
        this.font = new Font("Dialog", 0, 12);
    }

    GdkGraphics(GtkImage image) {
        this.this();
        this.image = image;
        this.initFromImage(image);
        this.color = Color.black;
        this.clip = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        this.font = new Font("Dialog", 0, 12);
    }

    GdkGraphics(GtkComponentPeer component) {
        this.this();
        this.component = component;
        this.color = Color.black;
        if (component.isRealized()) {
            this.initComponentGraphics();
        } else {
            this.connectSignals(component);
        }
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkGraphics.initStaticState();
    }
}

