/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.VMDirectByteBuffer;

final class ShortViewBufferImpl
extends ShortBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    public final short get() {
        int p = this.position();
        short result = ByteBufferHelper.getShort(this.bb, (p << 1) + this.offset, this.endian);
        this.position(p + 1);
        return result;
    }

    public final short get(int index) {
        return ByteBufferHelper.getShort(this.bb, (index << 1) + this.offset, this.endian);
    }

    public final ShortBuffer put(short value) {
        int p = this.position();
        ByteBufferHelper.putShort(this.bb, (p << 1) + this.offset, value, this.endian);
        this.position(p + 1);
        return this;
    }

    public final ShortBuffer put(int index, short value) {
        ByteBufferHelper.putShort(this.bb, (index << 1) + this.offset, value, this.endian);
        return this;
    }

    public final ShortBuffer compact() {
        if (this.position() > 0) {
            int count = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 2 * this.position(), 2 * count);
            this.position(count);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public final ShortBuffer slice() {
        return new ShortViewBufferImpl(this.bb, (this.position() >> 1) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    final ShortBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        return new ShortViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), pos, mark, readOnly, this.endian);
    }

    public final ShortBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public final ShortBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isDirect() {
        return this.bb.isDirect();
    }

    public final ByteOrder order() {
        return this.endian;
    }

    ShortViewBufferImpl(ByteBuffer bb, int capacity) {
        super(capacity, capacity, 0, -1);
        this.bb = bb;
        this.offset = bb.position();
        this.readOnly = bb.isReadOnly();
        this.endian = bb.order();
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, this.offset);
        }
    }

    public ShortViewBufferImpl(ByteBuffer bb, int offset, int capacity, int limit, int position, int mark, boolean readOnly, ByteOrder endian) {
        super(capacity, limit, position, mark);
        this.bb = bb;
        this.offset = offset;
        this.readOnly = readOnly;
        this.endian = endian;
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, offset);
        }
    }
}

