/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLEventWriterImpl
implements XMLEventWriter {
    protected final XMLStreamWriter writer;

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 1: {
                StartElement startElement = event.asStartElement();
                QName name = startElement.getName();
                String uri = name.getNamespaceURI();
                if (uri != null && !"".equals(uri)) {
                    this.writer.writeStartElement(name.getPrefix(), name.getLocalPart(), uri);
                    break;
                }
                this.writer.writeStartElement(name.getLocalPart());
                break;
            }
            case 2: {
                this.writer.writeEndElement();
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)event;
                QName name = attribute.getName();
                String uri = name.getNamespaceURI();
                if (uri != null && !"".equals(uri)) {
                    this.writer.writeAttribute(name.getPrefix(), uri, name.getLocalPart(), attribute.getValue());
                    break;
                }
                this.writer.writeAttribute(name.getLocalPart(), attribute.getValue());
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)event;
                String uri = namespace.getNamespaceURI();
                this.writer.writeNamespace(namespace.getPrefix(), uri);
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)event;
                String data = pi.getData();
                if (data == null) {
                    this.writer.writeProcessingInstruction(pi.getTarget());
                    break;
                }
                this.writer.writeProcessingInstruction(pi.getTarget(), data);
                break;
            }
            case 5: {
                Comment comment = (Comment)event;
                this.writer.writeComment(comment.getText());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)event;
                this.writer.writeStartDocument(startDocument.getVersion());
                break;
            }
            case 8: {
                this.writer.writeEndDocument();
                break;
            }
            case 11: {
                DTD dtd = (DTD)event;
                this.writer.writeDTD(dtd.getDocumentTypeDeclaration());
                break;
            }
            case 4: 
            case 6: {
                Characters characters = event.asCharacters();
                this.writer.writeCharacters(characters.getData());
                break;
            }
            case 12: {
                Characters cdata = event.asCharacters();
                this.writer.writeCData(cdata.getData());
                break;
            }
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.next());
        }
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    protected XMLEventWriterImpl(XMLStreamWriter writer) {
        this.writer = writer;
    }
}

