/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import gnu.java.rmi.RMIMarshalledObjectInputStream;
import gnu.java.rmi.RMIMarshalledObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class MarshalledObject
implements Serializable {
    private static final long serialVersionUID = 8988374069173025854L;
    byte[] objBytes;
    byte[] locBytes;
    int hash;

    public final boolean equals(Object obj) {
        if (!(obj instanceof MarshalledObject)) {
            return false;
        }
        if (obj.hashCode() != this.hash) {
            return false;
        }
        MarshalledObject aobj = (MarshalledObject)obj;
        if (this.objBytes == null || aobj.objBytes == null) {
            boolean bl = false;
            if (this.objBytes == aobj.objBytes) {
                bl = true;
            }
            return bl;
        }
        if (this.objBytes.length != aobj.objBytes.length) {
            return false;
        }
        int i = 0;
        while (i < this.objBytes.length) {
            if (this.objBytes[i] != aobj.objBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        RMIMarshalledObjectInputStream stream = new RMIMarshalledObjectInputStream(this.objBytes, this.locBytes);
        return stream.readObject();
    }

    public final int hashCode() {
        return this.hash;
    }

    public MarshalledObject(Object obj) throws IOException {
        ByteArrayOutputStream objStream = new ByteArrayOutputStream();
        RMIMarshalledObjectOutputStream stream = new RMIMarshalledObjectOutputStream(objStream);
        stream.writeObject(obj);
        stream.flush();
        this.objBytes = objStream.toByteArray();
        this.locBytes = stream.getLocBytes();
        this.hash = 0;
        int i = 0;
        while (i < this.objBytes.length) {
            this.hash = this.hash * 31 + this.objBytes[i];
            ++i;
        }
        if (this.locBytes != null) {
            i = 0;
            while (i < this.locBytes.length) {
                this.hash = this.hash * 31 + this.locBytes[i];
                ++i;
            }
        }
    }
}

