/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private Vector contents;
    private int directories;
    private int listingMode;
    private JFileChooser filechooser;
    private Comparator comparator;

    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public Vector getDirectories() {
        Vector tmp = new Vector();
        int i = 0;
        while (i < this.directories) {
            tmp.add(this.contents.get(i));
            ++i;
        }
        return tmp;
    }

    public Object getElementAt(int index) {
        if (index > this.getSize() - 1) {
            return null;
        }
        if (this.listingMode == 0) {
            return this.contents.get(this.directories + index);
        }
        return this.contents.elementAt(index);
    }

    public Vector getFiles() {
        Vector tmp = new Vector();
        int i = this.directories;
        while (i < this.getSize()) {
            tmp.add(this.contents.get(i));
            ++i;
        }
        return tmp;
    }

    public int getSize() {
        if (this.listingMode == 1) {
            return this.directories;
        }
        if (this.listingMode == 0) {
            return this.contents.size() - this.directories;
        }
        return this.contents.size();
    }

    public int indexOf(Object o) {
        if (this.listingMode == 0) {
            return this.contents.indexOf(o) - this.directories;
        }
        return this.contents.indexOf(o);
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void invalidateFileCache() {
    }

    protected boolean lt(File a, File b) {
        boolean bTrav;
        boolean aTrav = this.filechooser.isTraversable(a);
        if (aTrav == (bTrav = this.filechooser.isTraversable(b))) {
            String aname = a.getName().toLowerCase();
            String bname = b.getName().toLowerCase();
            boolean bl = false;
            if (aname.compareTo(bname) < 0) {
                bl = true;
            }
            return bl;
        }
        return aTrav;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("fileSelectionChanged")) {
            this.listingMode = this.filechooser.getFileSelectionMode();
        }
    }

    public boolean renameFile(File oldFile, File newFile) {
        return false;
    }

    protected void sort(Vector v) {
        Collections.sort(v, this.comparator);
        Enumeration e = Collections.enumeration(v);
        Vector tmp = new Vector();
        while (e.hasMoreElements()) {
            tmp.add(e.nextElement());
        }
        this.contents = tmp;
    }

    public void validateFileCache() {
        this.contents.clear();
        this.directories = 0;
        FileSystemView fsv = this.filechooser.getFileSystemView();
        File[] list2 = fsv.getFiles(this.filechooser.getCurrentDirectory(), this.filechooser.isFileHidingEnabled());
        if (list2 == null) {
            return;
        }
        int i = 0;
        while (i < list2.length) {
            if (list2[i] != null && this.filechooser.accept(list2[i])) {
                this.contents.add(list2[i]);
                if (this.filechooser.isTraversable(list2[i])) {
                    ++this.directories;
                }
            }
            ++i;
        }
        this.sort(this.contents);
        this.filechooser.revalidate();
        this.filechooser.repaint();
    }

    private final /* synthetic */ void this() {
        this.comparator = new Comparator(){

            public final int compare(Object o1, Object o2) {
                if (BasicDirectoryModel.this.lt((File)o1, (File)o2)) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public BasicDirectoryModel(JFileChooser filechooser) {
        this.this();
        this.filechooser = filechooser;
        filechooser.addPropertyChangeListener(this);
        this.listingMode = filechooser.getFileSelectionMode();
        this.contents = new Vector();
    }
}

