/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.util.AbstractIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.bcf2.BCFVersion;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

public class VCFIteratorBuilder {
    public VCFIterator open(InputStream in) throws IOException {
        BCFVersion bcfVersion;
        if (in == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        BufferedInputStream bufferedinput = new BufferedInputStream(in, Math.max(BCF2Codec.SIZEOF_BCF_HEADER, 8000));
        if (IOUtil.isGZIPInputStream(bufferedinput)) {
            bufferedinput = new BufferedInputStream(new GZIPInputStream(bufferedinput), BCF2Codec.SIZEOF_BCF_HEADER);
        }
        if ((bcfVersion = BCF2Codec.tryReadBCFVersion(bufferedinput)) != null) {
            return new BCFInputStreamIterator(bufferedinput);
        }
        return new VCFReaderIterator(bufferedinput);
    }

    public VCFIterator open(String path) throws IOException {
        return this.open(path, null);
    }

    public VCFIterator open(Path path) throws IOException {
        return this.open(path, null);
    }

    public VCFIterator open(Path path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) throws IOException {
        return this.open(new SeekablePathStream(path, wrapper));
    }

    public VCFIterator open(String path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) throws IOException {
        return this.open(ParsingUtils.openInputStream(path, wrapper));
    }

    public VCFIterator open(File file) throws IOException {
        return this.open(file.toPath());
    }

    private static class BCFInputStreamIterator
    extends AbstractIterator<VariantContext>
    implements VCFIterator {
        private final PositionalBufferedStream inputStream;
        private final BCF2Codec codec = new BCF2Codec();
        private final VCFHeader vcfHeader;

        BCFInputStreamIterator(InputStream inputStream) {
            this.inputStream = this.codec.makeSourceFromStream(inputStream);
            this.vcfHeader = (VCFHeader)this.codec.readHeader(this.inputStream).getHeaderValue();
        }

        @Override
        public VCFHeader getHeader() {
            return this.vcfHeader;
        }

        @Override
        protected VariantContext advance() {
            return this.codec.isDone(this.inputStream) ? null : this.codec.decode(this.inputStream);
        }

        @Override
        public void close() {
            this.inputStream.close();
        }
    }

    private static class VCFReaderIterator
    extends AbstractIterator<VariantContext>
    implements VCFIterator {
        private final InputStream inputStream;
        private final VCFCodec codec = new VCFCodec();
        private final VCFHeader vcfHeader;
        private final LineIterator lineIterator;

        VCFReaderIterator(InputStream inputStream) {
            this.inputStream = inputStream;
            this.lineIterator = this.codec.makeSourceFromStream(this.inputStream);
            this.vcfHeader = (VCFHeader)this.codec.readActualHeader(this.lineIterator);
        }

        @Override
        public VCFHeader getHeader() {
            return this.vcfHeader;
        }

        @Override
        protected VariantContext advance() {
            return this.lineIterator.hasNext() ? this.codec.decode((String)this.lineIterator.next()) : null;
        }

        @Override
        public void close() {
            CloserUtil.close(this.lineIterator);
            CloserUtil.close(this.inputStream);
        }
    }
}

