/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;

    public boolean implies(Permission perm) {
        if (!this.getClass().isInstance(perm)) {
            return false;
        }
        String otherName = perm.getName();
        String name = this.getName();
        if (name.equals(otherName)) {
            return true;
        }
        int last = name.length() - 1;
        boolean bl = false;
        if (name.charAt(last) == '*' && otherName.startsWith(name.substring(0, last))) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object obj) {
        boolean bl = false;
        if (this.getClass().isInstance(obj) && this.getName().equals(((BasicPermission)obj).getName())) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection(this.getClass());
    }

    public BasicPermission(String name) {
        super(name);
        if ("".equals(name)) {
            throw new IllegalArgumentException("Empty name");
        }
    }

    public BasicPermission(String name, String actions) {
        this(name);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class BasicPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 739301742472979399L;
        private final Hashtable permissions;
        private boolean all_allowed;
        private final Class permClass;

        public final void add(Permission perm) {
            if (this.isReadOnly()) {
                throw new SecurityException("readonly");
            }
            if (!this.permClass.isInstance(perm)) {
                throw new IllegalArgumentException("Expecting instance of " + this.permClass);
            }
            BasicPermission bp = (BasicPermission)perm;
            String name = bp.getName();
            if (name.equals("*")) {
                this.all_allowed = true;
            }
            this.permissions.put(name, bp);
        }

        public final boolean implies(Permission permission) {
            if (!this.permClass.isInstance(permission)) {
                return false;
            }
            if (this.all_allowed) {
                return true;
            }
            BasicPermission toImply = (BasicPermission)permission;
            String name = toImply.getName();
            if (name.equals("*")) {
                return false;
            }
            int prefixLength = name.length();
            if (name.endsWith("*")) {
                prefixLength -= 2;
            }
            while (this.permissions.get(name) == null) {
                if ((prefixLength = name.lastIndexOf(46, prefixLength)) < 0) {
                    return false;
                }
                name = name.substring(0, prefixLength + 1) + '*';
            }
            return true;
        }

        public final Enumeration elements() {
            return this.permissions.elements();
        }

        private final /* synthetic */ void this() {
            this.permissions = new Hashtable();
        }

        BasicPermissionCollection(Class c) {
            this.this();
            this.permClass = c;
        }
    }
}

