/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import gnu.java.awt.image.ImageDecoder;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class XBMDecoder
extends ImageDecoder {
    static final ColorModel cm = ColorModel.getRGBdefault();
    static final int black = -16777216;
    static final int transparent = 0;
    static final int[] masktable = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    BufferedReader reader;

    public void produce(Vector v, InputStream is) throws IOException {
        ImageConsumer ic;
        this.reader = new BufferedReader(new InputStreamReader(is));
        int width = -1;
        int height = -1;
        int i = 0;
        while (i < 2) {
            String line = this.reader.readLine();
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            st.nextToken();
            if (i == 0) {
                width = Integer.parseInt(st.nextToken(), 10);
            } else {
                height = Integer.parseInt(st.nextToken(), 10);
            }
            ++i;
        }
        i = 0;
        while (i < v.size()) {
            ic = (ImageConsumer)v.elementAt(i);
            ic.setDimensions(width, height);
            ic.setColorModel(cm);
            ic.setHints(30);
            ++i;
        }
        while (this.reader.read() != 123) {
        }
        int line = 0;
        while (line < height) {
            int[] scanline = XBMDecoder.getScanline(this.reader, width);
            int i2 = 0;
            while (i2 < v.size()) {
                ImageConsumer ic2 = (ImageConsumer)v.elementAt(i2);
                ic2.setPixels(0, line, width, 1, cm, scanline, 0, width);
                ++i2;
            }
            ++line;
        }
        i = 0;
        while (i < v.size()) {
            ic = (ImageConsumer)v.elementAt(i);
            ic.imageComplete(3);
            ++i;
        }
    }

    public static int[] getScanline(Reader in, int len) throws IOException {
        char[] byteStr = new char[2];
        int[] scanline = new int[len];
        int x = 0;
        while (x < len) {
            int ch = in.read();
            if (ch != 48) continue;
            in.read();
            byteStr[0] = (char)in.read();
            byteStr[1] = (char)in.read();
            int byteVal = Integer.parseInt(new String(byteStr), 16);
            int i = 0;
            while (i < 8) {
                if (x == len) {
                    return scanline;
                }
                scanline[x] = (byteVal & masktable[i]) != 0 ? -16777216 : 0;
                ++i;
                ++x;
            }
        }
        return scanline;
    }

    public XBMDecoder(String filename) {
        super(filename);
    }

    public XBMDecoder(URL url) {
        super(url);
    }
}

