require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_FOOTBRIDGE_INTR_H_)) {
    eval 'sub _FOOTBRIDGE_INTR_H_ () {1;}' unless defined(&_FOOTBRIDGE_INTR_H_);
    unless(defined(&_LOCORE)) {
	require 'arm/mutex.ph';
    }
    require 'sys/param.ph';
    require 'arm/cpu.ph';
    require 'arm/armreg.ph';
    eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTBIO () {2;}' unless defined(&IPL_SOFTBIO);
    eval 'sub IPL_SOFTNET () {3;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_SOFTSERIAL () {4;}' unless defined(&IPL_SOFTSERIAL);
    eval 'sub IPL_VM () {5;}' unless defined(&IPL_VM);
    eval 'sub IPL_SCHED () {6;}' unless defined(&IPL_SCHED);
    eval 'sub IPL_HIGH () {7;}' unless defined(&IPL_HIGH);
    eval 'sub NIPL () {8;}' unless defined(&NIPL);
    eval 'sub IST_UNUSABLE () {-1;}' unless defined(&IST_UNUSABLE);
    eval 'sub IST_NONE () {0;}' unless defined(&IST_NONE);
    eval 'sub IST_PULSE () {1;}' unless defined(&IST_PULSE);
    eval 'sub IST_EDGE () {2;}' unless defined(&IST_EDGE);
    eval 'sub IST_LEVEL () {3;}' unless defined(&IST_LEVEL);
    eval 'sub ARM_IRQ_HANDLER () { &_C_LABEL( &footbridge_intr_dispatch);}' unless defined(&ARM_IRQ_HANDLER);
    unless(defined(&_LOCORE)) {
	require 'arm/cpufunc.ph';
	require 'arm/footbridge/dc21285mem.ph';
	require 'arm/footbridge/dc21285reg.ph';
	eval 'sub INT_SWMASK () {((1 <<  &IRQ_SOFTINT) | (1 <<  &IRQ_RESERVED0) | (1 <<  &IRQ_RESERVED1) | (1 <<  &IRQ_RESERVED2));}' unless defined(&INT_SWMASK);
	eval 'sub ICU_INT_HWMASK () {(0xffffffff & ~( &INT_SWMASK | (1 <<  &IRQ_RESERVED3)));}' unless defined(&ICU_INT_HWMASK);
	if(defined(&__HAVE_FAST_SOFTINTS)) {
	}
	eval 'sub __attribute__ () {
	    eval q((( &__unused__))  &footbridge_splraise(\'int\'  &ipl) { \'int\'  &old;  &old =  &curcpl();  &set_curcpl( &ipl);  &__insn_barrier(); ( &old); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__unused__))  &footbridge_spllower(\'int\'  &ipl) { \'int\'  &old =  &curcpl();  &footbridge_splx( &ipl); ( &old); });
	}' unless defined(&__attribute__);
	if(!defined(&ARM_SPL_NOINLINE)) {
	    eval 'sub splx {
	        my($newspl) = @_;
    		eval q( &footbridge_splx($newspl));
	    }' unless defined(&splx);
	    eval 'sub _spllower {
	        my($ipl) = @_;
    		eval q( &footbridge_spllower($ipl));
	    }' unless defined(&_spllower);
	    eval 'sub _splraise {
	        my($ipl) = @_;
    		eval q( &footbridge_splraise($ipl));
	    }' unless defined(&_splraise);
	} else {
	}
	require 'sys/evcnt.ph';
	require 'sys/queue.ph';
	require 'machine/irqhandler.ph';
	eval 'sub splsoft () {
	    eval q( &_splraise( &IPL_SOFT));
	}' unless defined(&splsoft);
	eval 'sub spl0 () {
	    eval q(( &void) &_spllower( &IPL_NONE));
	}' unless defined(&spl0);
	eval 'sub spllowersoftclock () {
	    eval q(( &void) &_spllower( &IPL_SOFTCLOCK));
	}' unless defined(&spllowersoftclock);
	eval 'sub makeiplcookie {
	    my($ipl) = @_;
    	    eval q({ ( &ipl_cookie_t){. &_ipl = $ipl}; });
	}' unless defined(&makeiplcookie);
	eval 'sub splraiseipl {
	    my($icookie) = @_;
    	    eval q({  &_splraise( ($icookie->{_ipl})); });
	}' unless defined(&splraiseipl);
	require 'sys/spl.ph';
	eval 'sub NIRQ () {32;}' unless defined(&NIRQ);
	eval 'sub IRQNAMESIZE () {$sizeof{"footbridge irq 31"};}' unless defined(&IRQNAMESIZE);
    }
}
1;
