/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DiffieHellmanImpl
extends KeyAgreementSpi {
    private DHPrivateKey key = null;
    private BigInteger result = null;
    private boolean last_phase_done = false;

    protected final Key engineDoPhase(Key incoming, boolean lastPhase) throws InvalidKeyException {
        if (this.key == null) {
            throw new IllegalStateException("not initialized");
        }
        if (this.last_phase_done) {
            throw new IllegalStateException("last phase already done");
        }
        if (!(incoming instanceof DHPublicKey)) {
            throw new InvalidKeyException("expecting javax.crypto.interfaces.DHPublicKey");
        }
        DHPublicKey pub = (DHPublicKey)incoming;
        DHParameterSpec s1 = this.key.getParams();
        DHParameterSpec s2 = pub.getParams();
        if (!s1.getG().equals(s2.getG()) || !s1.getP().equals(s2.getP()) || s1.getL() != s2.getL()) {
            throw new InvalidKeyException("supplied key is not compatible");
        }
        this.result = pub.getY().modPow(this.key.getX(), s1.getP());
        if (lastPhase) {
            this.last_phase_done = true;
            return null;
        }
        throw new IllegalArgumentException("only supports two-party Diffie Hellman");
    }

    protected final byte[] engineGenerateSecret() {
        if (this.result == null || !this.last_phase_done) {
            throw new IllegalStateException("not finished");
        }
        byte[] buf = this.result.toByteArray();
        if (buf[0] == 0) {
            byte[] buf2 = new byte[buf.length - 1];
            System.arraycopy(buf, 1, buf2, 0, buf2.length);
            buf = buf2;
        }
        return buf;
    }

    protected final int engineGenerateSecret(byte[] secret, int offset) {
        byte[] s = this.engineGenerateSecret();
        System.arraycopy(s, 0, secret, offset, s.length);
        return s.length;
    }

    protected final SecretKey engineGenerateSecret(String algorithm) throws InvalidKeyException {
        byte[] s = this.engineGenerateSecret();
        return new SecretKeySpec(s, algorithm);
    }

    protected final void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("not a javax.crypto.interfaces.DHPrivateKey");
        }
        this.key = (DHPrivateKey)key;
        this.result = null;
        this.last_phase_done = false;
    }

    protected final void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(key, random);
    }
}

