/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;

public class Reference
implements Cloneable,
Serializable {
    protected Vector addrs;
    protected String classFactory;
    protected String classFactoryLocation;
    protected String className;

    public void add(int posn, RefAddr addr) {
        this.addrs.add(posn, addr);
    }

    public void add(RefAddr addr) {
        this.addrs.add(addr);
    }

    public void clear() {
        this.addrs.clear();
    }

    public Object clone() {
        Reference r = new Reference(this.className, this.classFactory, this.classFactoryLocation);
        r.addrs = (Vector)this.addrs.clone();
        return r;
    }

    private final boolean equals(String a, String b) {
        boolean bl;
        if (a == null) {
            bl = false;
            if (b == null) {
                bl = true;
            }
        } else {
            bl = a.equals(b);
        }
        return bl;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference r = (Reference)obj;
        boolean bl = false;
        if (this.equals(this.classFactory, r.classFactory) && this.equals(this.classFactoryLocation, r.classFactoryLocation) && this.equals(this.className, r.className) && this.addrs.equals(r.addrs)) {
            bl = true;
        }
        return bl;
    }

    public RefAddr get(int posn) {
        return (RefAddr)this.addrs.get(posn);
    }

    public RefAddr get(String addrType) {
        int i = 0;
        while (i < this.addrs.size()) {
            RefAddr r = (RefAddr)this.addrs.get(i);
            if (addrType.equals(r.getType())) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public Enumeration getAll() {
        return this.addrs.elements();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.addrs.size()) {
            h += this.addrs.get(i).hashCode();
            ++i;
        }
        return h;
    }

    public Object remove(int posn) {
        return this.addrs.remove(posn);
    }

    public int size() {
        return this.addrs.size();
    }

    public String toString() {
        String x = this.getClass().toString() + '[';
        int i = 0;
        while (i < this.addrs.size()) {
            if (i > 0) {
                x = x + ',';
            }
            x = x + this.addrs.get(i).toString();
            ++i;
        }
        return x + ']';
    }

    public Reference(String className) {
        this.className = className;
        this.addrs = new Vector();
    }

    public Reference(String className, RefAddr addr) {
        this.className = className;
        this.addrs = new Vector();
        this.addrs.add(addr);
    }

    public Reference(String className, String factory, String factoryLocation) {
        this.className = className;
        this.classFactory = factory;
        this.classFactoryLocation = factoryLocation;
        this.addrs = new Vector();
    }

    public Reference(String className, RefAddr addr, String factory, String factoryLocation) {
        this.className = className;
        this.classFactory = factory;
        this.classFactoryLocation = factoryLocation;
        this.addrs = new Vector();
        this.addrs.add(addr);
    }
}

