/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import java.util.Properties;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;
import org.campagnelab.goby.baseinfo.StatAccumulator;

public class StatAccumulatorReadMappingQuality
extends StatAccumulator {
    public static final String STATS_READMAPPINGQUALITY_FORWARD = "stats.readMappingQuality.forward";
    public static final String STATS_READMAPPINGQUALITY_REVERSE = "stats.readMappingQuality.reverse";
    protected float minimumValueForward = Float.POSITIVE_INFINITY;
    protected float maximumValueForward = Float.NEGATIVE_INFINITY;
    protected float minimumValueReverse = Float.POSITIVE_INFINITY;
    protected float maximumValueReverse = Float.NEGATIVE_INFINITY;
    private String propertyName;

    public StatAccumulatorReadMappingQuality() {
        super(null, null);
    }

    @Override
    void setProperties(Properties properties) {
        this.propertyName = STATS_READMAPPINGQUALITY_FORWARD;
        if (this.isDefined(this.minimumValueForward)) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValueForward));
        }
        if (this.isDefined(this.maximumValueForward)) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValueForward));
        }
        this.propertyName = STATS_READMAPPINGQUALITY_REVERSE;
        if (this.isDefined(this.minimumValueReverse)) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValueReverse));
        }
        if (this.isDefined(this.maximumValueReverse)) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValueReverse));
        }
    }

    @Override
    void observe(BaseInformationRecords.BaseInformation record) {
        for (BaseInformationRecords.SampleInfo sample : record.getSamplesList()) {
            for (BaseInformationRecords.CountInfo count : sample.getCountsList()) {
                for (BaseInformationRecords.NumberWithFrequency freqvalue : count.getReadMappingQualityForwardStrandList()) {
                    this.minimumValueForward = Math.min(this.minimumValueForward, (float)freqvalue.getNumber());
                    this.maximumValueForward = Math.max(this.maximumValueForward, (float)freqvalue.getNumber());
                }
                for (BaseInformationRecords.NumberWithFrequency freqvalue : count.getReadMappingQualityReverseStrandList()) {
                    this.minimumValueReverse = Math.min(this.minimumValueReverse, (float)freqvalue.getNumber());
                    this.maximumValueReverse = Math.max(this.maximumValueReverse, (float)freqvalue.getNumber());
                }
            }
        }
    }

    @Override
    void mergeWith(Properties properties) {
        if (properties.containsKey("stats.readMappingQuality.forward.min")) {
            this.minimumValueForward = Math.min(this.minimumValueForward, Float.parseFloat(properties.get("stats.readMappingQuality.forward.min").toString()));
        }
        if (properties.containsKey("stats.readMappingQuality.reverse.min")) {
            this.minimumValueReverse = Math.min(this.minimumValueReverse, Float.parseFloat(properties.get("stats.readMappingQuality.reverse.min").toString()));
        }
        if (properties.containsKey("stats.readMappingQuality.forward.max")) {
            this.maximumValueForward = Math.max(this.maximumValueForward, Float.parseFloat(properties.get("stats.readMappingQuality.forward.max").toString()));
        }
        if (properties.containsKey("stats.readMappingQuality.reverse.max")) {
            this.maximumValueReverse = Math.max(this.maximumValueReverse, Float.parseFloat(properties.get("stats.readMappingQuality.reverse.max").toString()));
        }
    }
}

