require Bastille::API;
use Bastille::API;

if (&GetDistro =~ /^HP/) {
    return;
}
$GLOBAL_TEST{'Apache'}{'apacheoff'} =
    sub {
	return (&B_is_service_off('apache') and &B_is_service_off('apache2')  and 
		&B_is_service_off('httpd') );
    };

$GLOBAL_TEST{'Apache'}{'bindapachelocal'} =
    sub {
	# Only ask the question if an Apache binary is present.
	if (&apache_present) {

	    # SuSE uses a listen.conf file for Listen statements.
	    my $listen_file;
	    if (&GetDistro =~ /^SE9\.?/ or &GetDistro =~ /^SESLES/ ) {
		$listen_file = &getGlobal('FILE','listen.conf');
	    }
	    else {
		$listen_file = &getGlobal('FILE','httpd.conf');
	    }
	    unless (&B_match_line($listen_file,'^\s*Listen\s+127\.')) {
		return $ASKQ;
	    }
	    # If there wasn't a file without a Listen line, we're good.
	    return $SKIPQ;
	}
	else {
	    # Return SKIP if Apache isn't present.
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'Apache'}{'bindapachenic'} =
    sub {
	# Only ask the question if an Apache binary is present.
	if (&apache_present) {

	    # SuSE uses a listen.conf file for Listen statements.
	    my $listen_file;
	    if (&GetDistro =~ /^SE9\.?/ or &GetDistro =~ /^SESLES/ ) {
		$listen_file = &getGlobal('FILE','listen.conf');
	    }
	    else {
		$listen_file = &getGlobal('FILE','httpd.conf');
	    }
	    # Check the file for a Listen line that indicates an IP address
	    if (&B_match_line($listen_file,'^\s*Listen\s+\d+\.\d+\.\d+\.\d+')) {
		return $SKIPQ;
	    }
	    else {
		return $ASKQ;
	    }
	}
	else {
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'Apache'}{'generalweb'} =
    sub {
	if (&apache_present) {
	    return $ASKQ;
	}
    };


$GLOBAL_TEST{'Apache'}{'symlink'} =
    sub {
	# Only ask the question if an Apache binary is present.
	if (&apache_present) {

	    # SUSE breaks httpd.conf into many files.
	    if (&GetDistro =~ /^SE9\.?/ or &GetDistro =~ /^SESLES/ ) {
		@files = (&getGlobal('FILE','httpd.conf'),&getGlobal('FILE','listen.conf'),&getGlobal('FILE','suse-default-server.conf'));
	    }
	    else {
		@files = (&getGlobal('FILE','httpd.conf'));
	    }
	    # Check all Options lines to see if they have FollowSymLinks present
	    foreach $file (@files) {
		if (&B_match_line($file,'^\s*Options.*\bFollowSymLinks\b')) {
		    return $ASKQ;
		}
	    }
	    # Otherwise return SKIPQ.
	    return $SKIPQ;
	}
	else {
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'Apache'}{'ssi'} =
    sub {
	# Only ask the question if an Apache binary is present.
	if (&apache_present) {

	    # SUSE breaks httpd.conf into many files.
	    if (&GetDistro =~ /^SE9\.?/ or &GetDistro =~ /^SESLES/ ) {
		@files = (&getGlobal('FILE','httpd.conf'),&getGlobal('FILE','listen.conf'),&getGlobal('FILE','suse-default-server.conf'));
	    }
	    else {
		@files = (&getGlobal('FILE','httpd.conf'));
	    }
	    foreach $file (@files) {
		# Check all Options lines to see if they have Includes present.
		# We allow IncludesNoExec, but might need to change that.
		if (&B_match_line($file,'^\s*Options.*\bIncludes\b')) {
		    return $ASKQ;
		}
	    }
	    return $SKIPQ;
	}
	else {
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'Apache'}{'cgi'} =
    sub {
	# Only ask the question if an Apache binary is present.
	if (&apache_present) {
	    # SUSE breaks httpd.conf into many files.
	    if (&GetDistro =~ /^SE9\.?/ or &GetDistro =~ /^SESLES/ ) {
		@files = (&getGlobal('FILE','httpd.conf'),&getGlobal('FILE','listen.conf'),&getGlobal('FILE','suse-default-server.conf'));
	    }
	    else {
		@files = (&getGlobal('FILE','httpd.conf'));
	    }
	    foreach $file (@files) {
		# Check all Options lines to see if they have ExecCGI present.
		# We should consider allowing CGI execution in a single directory, but 
		# do this in a separate question.  Many servers don't need CGI.
		if (&B_match_line($file,'^\s*Options.*\bExecCGI\b')) {
		    return $ASKQ;
		}
	    }
	    return $SKIPQ;
	}
	else {
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'Apache'}{'apacheindex'} =
    sub {
	# Only ask the question if an Apache binary is present.
	if (&apache_present) {
	    # SUSE breaks httpd.conf into many files.
	    if (&GetDistro =~ /^SE9\.?/ or &GetDistro =~ /^SESLES/ ) {
		@files = (&getGlobal('FILE','httpd.conf'),&getGlobal('FILE','listen.conf'),&getGlobal('FILE','suse-default-server.conf'));
	    }
	    else {
		@files = (&getGlobal('FILE','httpd.conf'));
	    }
	    foreach $file (@files) {
		# Check all Options lines to see if they have Index present.
		if (&B_match_line($file,'^\s*Options.*\bIndex\b')) {
		    return $ASKQ;
		}
	    }
	    return $SKIPQ;
	}
	else {
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'Apache'}{'chrootapache'} =
    sub {

	# TODO: Need to check if Apache is chrooted and skip if it is.
	#       Jay just wrote this stub to remove the REQUIRE_FILE_EXISTS from this item.

        # HP-UX - only question
	unless (&GetDistro =~ /^HP/) {
	    return $SKIPQ;
	}
	if ( -e &getGlobal('FILE','gethpws_chroot_os_cp.sh') ) {
	    return $ASKQ;
	}
	else {
	    return $SKIPQ;
	}
    };


###################################################################################
# &apache_present is a local routine to test_Apache which tells us whether Apache #
# is present on the system.  This is slightly non-trivial since different distros #
# use different versions of Apache.                                               #
###################################################################################

sub apache_present {

    if ( -e &getGlobal(FILE,'httpd') or -e &getGlobal(FILE,'httpd2') ) {
	return 1;
    }
}

1;
