# Copyright (C) 1999 - 2005 Jay Beale
# Copyright (C) 2001, 2002 Hewlett Packard Company
# Copyright (C) 2005, Charlie Long Delphi Research
# Licensed under the GNU General Public License


#######################################################################
##                      File Permissions Audit                       ##
#######################################################################

require Bastille::API;
import Bastille::API;

##Tests for SUID and GUID

$GLOBAL_TEST{'FilePermissions'}{'suidmount'} =
    sub {
	my $mount = &getGlobal('BIN','mount');
	my $umount = &getGlobal('BIN','umount');
	my $smbmount = &getGlobal('BIN','smbmnt');
	
	# Return $ASKQ if either mount or umount is SUID
	if (&B_is_suid($mount) or &B_is_suid($umount) or &B_is_suid($smbmount)) {
	    return $ASKQ;
	    }
	
	return $SKIPQ;
    };


$GLOBAL_TEST{'FilePermissions'}{'suidping'} =
    sub {
	my $ping = &getGlobal('BIN','ping');
	my $ping6 = &getGlobal('BIN','ping6');

	# Return $ASKQ if ping is SUID
	if (&B_is_suid($ping) or &B_is_suid($ping6)  ) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };

$GLOBAL_TEST{'FilePermissions'}{'suiddump'} =
    sub {
	my $dump = &getGlobal('BIN','dump');
	my $restore = &getGlobal('BIN','restore');
	
	# Return $ASKQ if either dump or restore SUID
	if (&B_is_suid($dump) or &B_is_suid($restore)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };
		

$GLOBAL_TEST{'FilePermissions'}{'suidcard'} =
    sub {
	my $cardctl = &getGlobal('BIN','cardctl');
	
	# Return $ASKQ if cardctl is SUID
	if (&B_is_suid($cardctl)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };


# Xwrapper is a soft link to /usr/X11R6/bin/XFree86 in SUSE
#

$GLOBAL_TEST{'FilePermissions'}{'suidXwrapper'} =
    sub {
	my $Xwrapper = &getGlobal('BIN','Xwrapper');
	
	# Return $ASKQ if Xwrapper is SUID
	if (&B_is_suid($Xwrapper)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };

$GLOBAL_TEST{'FilePermissions'}{'suidXFree86'} =
    sub {
	my $Xwrapper = &getGlobal('BIN','XFree86');
	
	# Return $ASKQ if XFree86 is SUID
	if (&B_is_suid($Xwrapper)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };

$GLOBAL_TEST{'FilePermissions'}{'suidat'} =
    sub {
	my $at = &getGlobal('BIN','at');
	
	# Return $ASKQ if at is SUID
	if (&B_is_suid($at)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };


$GLOBAL_TEST{'FilePermissions'}{'suiddos'} =
    sub {
	my $dos = &getGlobal('BIN','dos');
	
	# Return $ASKQ if dos is SUID
	if (&B_is_suid($dos)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };


$GLOBAL_TEST{'FilePermissions'}{'suidnews'} =
    sub {
	my $inndstart = &getGlobal('BIN','inndstart');
	my $startinnfeed = &getGlobal('BIN','startinnfeed');
	
	
	# Return $ASKQ if news is SUID
	if (&B_is_suid($inndstart) or &B_is_suid($startinnfeed)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };


$GLOBAL_TEST{'FilePermissions'}{'suidprint'} =
    sub {
	my $lpr = &getGlobal('BIN','lpr');
	my $slack = &getGlobal('BIN','lpq');	# slackdaddy wuz here
	my $lprm = &getGlobal('BIN','lprm');
	
	# Return $ASKQ if either lpr, slack or lprm is SUID
	if (&B_is_suid($lpr) or &B_is_suid($slack) or &B_is_suid($lprm)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };

$GLOBAL_TEST{'FilePermissions'}{'suidrtool'} =
    sub {
	my $rcp = &getGlobal('BIN','rcp');
	my $rlogin = &getGlobal('BIN','rlogin');
	my $rsh = &getGlobal('BIN','rsh');
	my $rdist = &getGlobal('BIN','rdist');
	my $rexec = &getGlobal('BIN','rexec');
	
	# Return $ASKQ if either rcp, rlogin, rsh, rdist or rexec SUID
	if (&B_is_suid($rcp) or &B_is_suid($rlogin) or &B_is_suid($rsh) or &B_is_suid($rdist) or &B_is_suid($rexec) ) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };

$GLOBAL_TEST{'FilePermissions'}{'suidusernetctl'} =
    sub {
	my $usernetctl = &getGlobal('BIN','usernetctl');
	
	# Return $ASKQ if usernetctl is SUID
	if (&B_is_suid($usernetctl) ) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };

$GLOBAL_TEST{'FilePermissions'}{'suidtrace'} =
    sub {
	my $traceroute = &getGlobal('BIN','traceroute');
	my $traceroute6 = &getGlobal('BIN','traceroute6');
	
	# Return $ASKQ if either traceroute or traceroute6 is SUID
	if (&B_is_suid($traceroute) or &B_is_suid($traceroute6)) {
	    return $ASKQ;
	}
	
	return $SKIPQ;
    };


###############################################################################################
# These tests are for the generalperms item, which is a very, very long fixing item that 
# mostly removes user access to admin-only utilities.  We don't recommend a non-zero weight
# for this item, soley because there are just so many permissions changes requires and the
# failure of a single one would fail the item.
#
# TODO: Consider whether we should give partial credit.
#
# This item was mostly generated by Jay running a custom perl script over the fixer item to
# automatically generate it.
#
# TODO: Consider rewriting script to use an array and far less code.
###############################################################################################

$GLOBAL_TEST{'FilePermissions'}{'generalperms_1_1'} =
    sub {
	my $distro=&GetDistro;

	unless ($distro =~ /^RH/ or $distro =~ /^MN/ or $distro =~ /^DB/ or $distro =~ /^SE/ or $distro =~ /^TB/) {
	    return $SKIPQ;
	}
	else {
	   unless ( &B_check_permissions("/bin/linuxconf",0700) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/bin/mt",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/bin/setserial",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/badblocks",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ctrlaltdel",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/chkconfig",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/debugfs",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/depmod",0750) ) {
	        return $ASKQ;
	   }
	   if ( $distro =~ /^DB/ ) {
		   unless ( &B_check_permissions("/usr/bin/dpkg",0750) ) {
		        return $ASKQ;
		   }
		   unless ( &B_check_permissions("/usr/bin/apt-get",0750) ) {
		        return $ASKQ;
		   }
	   }
	   unless ( &B_check_permissions("/sbin/dump",0770) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/dumpe2fs",0750) ) {
	        return $ASKQ;
	   }
	   ####### Are there other dump___ programs to worry about?
	   unless ( &B_check_permissions("/sbin/fdisk",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/fsck",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/fsck.ext2",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/fsck.minix",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ftl_check",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ftl_format",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/halt",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/hdparm",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/hwclock",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ifconfig",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ifdown",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ifport",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ifup",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/ifuser",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/init",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/insmod",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/isapnp",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/kerneld",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/killall5",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/lilo",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mingetty",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkbootdisk",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mke2fs",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkfs",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkfs.ext2",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkfs.minix",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkfs.msdos",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkinitrd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkpv",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkraid",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/mkswap",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/modinfo",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/modprobe",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/netreport",02750) ) {
	        return $ASKQ;
	   }

	   unless ( &B_check_permissions("/sbin/pnpdump",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/portmap",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/quotaon",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/restore",0770) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/runlevel",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/stinit",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/swapon",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/tune2fs",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/uugetty",0750) ) {
	        return $ASKQ;
	   }
	   
	   # Comanche was removed from RH6.1 -- don't try to chmod if it doesn't exist
	   if ( $distro ne "RH6.0" and $distro ne "MN6.0" and $distro ne "SE7.2" and $distro ne "TB7.0") {
	       unless ( &B_check_permissions("/usr/bin/comanche",0750) ) {
	            return $ASKQ;
	       }
	   }
	   unless ( &B_check_permissions("/usr/bin/control-panel",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/eject",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/gpasswd",07770) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/kernelcfg",0750) ) {
	        return $ASKQ;
	   }
	   
	   # Deviate from SAN/Trinity script.  Unless we create special 
	   # gnome/xwindows group, removing user access to gnome utilities 
	   # breaks things...
	   
	   # Don't modify any gnome stuff...

	   # Deviate from the SANS/Trinity script here: ordinary users should
	   # not be able to start the news server.  ( Chris Owen )
	   unless ( &B_check_permissions("/usr/bin/inndstart",0500) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/startinnfeed",0500) ) {
	        return $ASKQ;
	   }
	   
	   unless ( &B_check_permissions("/usr/bin/lpq",0755) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/lpqall.faces",0755) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/lprm",0755) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/lptest",0755) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/lpunlock",0755) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/lpr",0775) ) {
	        return $ASKQ;
	   }
           unless ( &B_check_permissions("/usr/bin/lpr",0757) ) {
                return $ASKQ;
           }

	   unless ( &B_check_permissions("/usr/bin/minicom",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/bin/netcfg",0750) ) {
	        return $ASKQ;
	   }
	   
	   unless ( &B_check_permissions("/usr/sbin/atd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/atrun",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/crond",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/dhcpd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/dhcrelay",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/edquota",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/exportfs",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/groupadd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/groupdel",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/groupmod",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/grpck",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/grpconv",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/grpunconv",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/imapd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.comsat",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.fingerd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.identd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.ntalkd",0750) ) {
	        return $ASKQ;
	   }
	   
	   # deviate from the SANS script for the in.r__d daemons -- these are 
	   # bad news!
	   unless ( &B_check_permissions("/usr/sbin/in.rexecd",0000) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.rlogind",0000) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.rshd",0000) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.telnetd",0750) ) {
	        return $ASKQ;
	   }
	   
	   # deviate from the SANS script -- tftpd has had serious vulnerabilities.
	   unless ( &B_check_permissions("/usr/sbin/in.tftpd",0000) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/in.timed",0750) ) {
	        return $ASKQ;
	   }
           unless ( &B_check_permissions("/usr/sbin/inetd",0750) ) {
                return $ASKQ;
           }
	   unless ( &B_check_permissions("/usr/sbin/ipop2d",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/ipop3d",0750) ) {
	        return $ASKQ;
	   }
	   
	   # klogd was moved to /sbin in RH6.1, so modify the right file
	   unless ( &B_check_permissions("/usr/sbin/klogd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/klogd",0750) ) {
	        return $ASKQ;
	   }
	   
	   unless ( &B_check_permissions("/usr/sbin/logrotate",0750) ) {
	        return $ASKQ;
	   }
	   #&B_chmod_if_exists(02750,"/usr/sbin/lpc");
	   unless ( &B_check_permissions("/usr/sbin/lpc",07770) ) {
	        return $ASKQ;
	   }
           unless ( &B_check_permissions("/usr/sbin/lpc",07757) ) {
                return $ASKQ;
           }
	   unless ( &B_check_permissions("/usr/sbin/lpd",0740) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/lpf",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/lsof",0755) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/makemap",0550) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/mouseconfig",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/named",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/named-xfer",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/newusers",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/nmbd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/ntpdate",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/ntpq",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/ntptime",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/ntptrace",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/ntsysv",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/pppd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/pwck",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/pwconv",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/pwunconv",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/quotastats",0550) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rdev",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/repquota",0550) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rotatelogs",0750) ) {
	        return $ASKQ;
	   }
	   
	   unless ( &B_check_permissions("/usr/sbin/rpc.bootparamd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.mountd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.nfsd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.rquotad",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.rstatd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.rusersd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.rwalld",0750) ) {
	        return $ASKQ;
	   }
	   
	   # rpc.statd was moved to /sbin in RH6.1, so modify the right file 
	   
	   unless ( &B_check_permissions("/usr/sbin/rpc.statd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/rpc.statd",0750) ) {
	        return $ASKQ;
	   }
	   
	   unless ( &B_check_permissions("/usr/sbin/rpc.yppasswdd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpc.ypxfrd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/rpcinfo",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/samba",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/setup",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/showmount",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/smbd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/squid",0750) ) {
	        return $ASKQ;
	   }
	   
	   # syslogd was moved to /sbin in RH6.1, so modify the right file
	   
	   unless ( &B_check_permissions("/usr/sbin/syslogd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/sbin/syslogd",0750) ) {
	        return $ASKQ;
	   }
	   
	   unless ( &B_check_permissions("/usr/sbin/taper",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/tcpd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/tcpdchk",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/tcpdmatch",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/tcpdump",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/timeconfig",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/timed",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/tmpwatch",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/tunelp",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/useradd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/userdel",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/userhelper",07770) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/usermod",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/usernetctl",07770) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/usernetctl",07757) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/vipw",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/xntpd",0750) ) {
	        return $ASKQ;
	   }
	   unless ( &B_check_permissions("/usr/sbin/xntpdc",0750) ) {
	        return $ASKQ;
	   }
       }

	return $SKIPQ;
    };

1;
