/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.openxml;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.openxml.OpenXMLOptions;
import org.omegat.filters4.xml.AbstractXmlFilter;
import org.omegat.util.OStrings;

class OpenXmlFilter
extends AbstractXmlFilter {
    private boolean removeComments;
    private boolean doCompactTags = false;
    private QName OOXML_MAIN_PARA_ELEMENT = null;
    private LinkedList<List<XMLEvent>> currentPara = null;
    private List<XMLEvent> currentBuffer = null;
    protected Map<Character, Integer> tagsCount = new TreeMap<Character, Integer>();
    private List<XMLEvent> defaultsForParagraph = new LinkedList<XMLEvent>();
    private QName TEXT_ELEMENT;
    private static final Pattern PTN_EMPTY_AND_START = Pattern.compile("((?:<[a-zA-Z]+[0-9]+/>)*)<([a-zA-Z]+[0-9]+)>((?:<[a-zA-Z]+[0-9]+/>)*)");
    private static final Pattern PTN_EMPTY_AND_END = Pattern.compile("((?:<[a-zA-Z]+[0-9]+/>)*)<(/[a-zA-Z]+[0-9]+)>((?:<[a-zA-Z]+[0-9]+/>)*)");

    OpenXmlFilter(boolean withComments) {
        this.removeComments = !withComments;
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("OPENXML4_FILTER_NAME");
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml")};
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        this.doCompactTags = new OpenXMLOptions(config).getAggregateTags();
        return inFile.getName().toLowerCase().endsWith(".xml");
    }

    @Override
    protected boolean checkCurrentCursorPosition(XMLStreamReader reader, boolean doWrite) {
        this.isEventMode = true;
        return true;
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLStreamWriter writer) throws XMLStreamException {
        if (this.OOXML_MAIN_PARA_ELEMENT == null) {
            this.OOXML_MAIN_PARA_ELEMENT = startElement.getName();
        }
        if (this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI().contains("presentation")) {
            this.OOXML_MAIN_PARA_ELEMENT = new QName(startElement.getNamespaceContext().getNamespaceURI("a"), this.OOXML_MAIN_PARA_ELEMENT.getLocalPart(), "a");
        }
        QName name = startElement.getName();
        if (this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI().equals(name.getNamespaceURI())) {
            if ("p".equals(name.getLocalPart()) || "si".equals(name.getLocalPart()) || "comment".equals(name.getLocalPart())) {
                this.currentBuffer = new LinkedList<XMLEvent>();
                this.currentPara = new LinkedList();
                this.currentPara.add(this.currentBuffer);
                this.currentBuffer.add(startElement);
                return false;
            }
            if ("r".equals(name.getLocalPart())) {
                if (this.currentBuffer == null || !this.currentBuffer.isEmpty()) {
                    this.currentBuffer = new LinkedList<XMLEvent>();
                    this.currentPara.add(this.currentBuffer);
                }
                this.currentBuffer.add(startElement);
                return false;
            }
            if (writer != null && ("lang".equals(name.getLocalPart()) || "themeFontLang".equals(name.getLocalPart()))) {
                this.fromEventToWriterOrBuffer(this.eFactory.createStartElement(startElement.getName(), null, startElement.getNamespaces()), writer);
                Iterator<Attribute> iter = startElement.getAttributes();
                while (iter.hasNext()) {
                    String pval;
                    Attribute attr = iter.next();
                    ProjectProperties prop = Core.getProject().getProjectProperties();
                    String aval = attr.getValue();
                    if (aval.equalsIgnoreCase(pval = prop.getSourceLanguage().toString())) {
                        this.fromEventToWriterOrBuffer(this.eFactory.createAttribute(attr.getName(), prop.getTargetLanguage().toString()), writer);
                        continue;
                    }
                    if (aval.length() > 2 && aval.charAt(2) == '-') {
                        aval = aval.substring(0, 2);
                    }
                    if (pval.length() > 2 && pval.charAt(2) == '-') {
                        pval = pval.substring(0, 2);
                    }
                    if (aval.equalsIgnoreCase(pval)) {
                        this.fromEventToWriterOrBuffer(this.eFactory.createAttribute(attr.getName(), prop.getTargetLanguage().toString()), writer);
                        continue;
                    }
                    this.fromEventToWriterOrBuffer(attr, writer);
                }
                return false;
            }
            if (this.removeComments) {
                if ("commentRangeStart".equals(name.getLocalPart())) {
                    return false;
                }
                if ("commentRangeEnd".equals(name.getLocalPart())) {
                    return false;
                }
                if ("commentReference".equals(name.getLocalPart())) {
                    return false;
                }
            }
            if ("ins".equals(name.getLocalPart())) {
                return false;
            }
            if ("del".equals(name.getLocalPart())) {
                this.currentBuffer = new LinkedList<XMLEvent>();
                return false;
            }
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.add(startElement);
            return false;
        }
        return true;
    }

    protected void fromEventToWriterOrBuffer(XMLEvent ev, XMLStreamWriter writer) throws XMLStreamException {
        if (this.currentBuffer != null) {
            this.currentBuffer.add(ev);
        } else if (writer != null) {
            this.fromEventToWriter(ev, writer);
        }
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLStreamWriter writer) throws XMLStreamException {
        QName name = endElement.getName();
        if (this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI().equals(name.getNamespaceURI())) {
            if ("p".equals(name.getLocalPart()) || "si".equals(name.getLocalPart()) || "comment".equals(name.getLocalPart())) {
                this.flushTranslation(writer);
                this.currentBuffer = null;
                return true;
            }
            if ("r".equals(name.getLocalPart())) {
                if (this.currentBuffer != null) {
                    this.currentBuffer.add(endElement);
                    this.currentBuffer = new LinkedList<XMLEvent>();
                    this.currentPara.add(this.currentBuffer);
                }
                return false;
            }
            if (this.removeComments) {
                if ("commentRangeStart".equals(name.getLocalPart())) {
                    return false;
                }
                if ("commentRangeEnd".equals(name.getLocalPart())) {
                    return false;
                }
                if ("commentReference".equals(name.getLocalPart())) {
                    return false;
                }
            }
            if ("ins".equals(name.getLocalPart())) {
                return false;
            }
            if ("del".equals(name.getLocalPart())) {
                this.currentBuffer = this.currentPara.getLast();
                return false;
            }
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.add(endElement);
            return false;
        }
        return true;
    }

    @Override
    protected boolean processCharacters(Characters event, XMLStreamWriter writer) {
        if (this.currentBuffer != null) {
            this.currentBuffer.add(event);
        }
        return this.currentBuffer == null;
    }

    private void flushTranslation(XMLStreamWriter writer) throws XMLStreamException {
        String src = this.buildTags();
        if (writer != null) {
            for (XMLEvent ev : this.currentPara.getFirst()) {
                this.fromEventToWriter(ev, writer);
            }
            if (this.currentPara.size() == 1) {
                return;
            }
            String tra = this.entryTranslateCallback.getTranslation(null, src, null);
            if (tra == null) {
                tra = src;
            }
            for (XMLEvent ev : this.restoreTags(tra)) {
                this.fromEventToWriter(ev, writer);
            }
            for (XMLEvent ev : this.currentPara.getLast()) {
                this.fromEventToWriter(ev, writer);
            }
        }
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(null, src, null, false, null, null, this, this.buildProtectedParts(src));
        }
    }

    protected String buildTags() {
        if (this.TEXT_ELEMENT == null) {
            this.TEXT_ELEMENT = new QName(this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI(), "t");
        }
        this.tagsMap.clear();
        for (Character c : this.tagsCount.keySet()) {
            this.tagsCount.put(c, 0);
        }
        StringBuffer res = new StringBuffer();
        this.defaultsForParagraph = null;
        block1: for (int i = 0; i < this.currentPara.size(); ++i) {
            List<XMLEvent> run = this.currentPara.get(i);
            if (run.isEmpty()) continue;
            if (run.get(0).isStartElement() && ((StartElement)run.get(0)).asStartElement().getName().getLocalPart().equals("r")) {
                ListIterator<XMLEvent> runIter = run.listIterator();
                char prefix = this.findPrefix(runIter);
                Integer tc = this.tagsCount.get(Character.valueOf(prefix));
                if (tc == null) {
                    tc = 0;
                }
                if (prefix == 'n' || prefix == 'd' || prefix == 'e') {
                    res.append("<" + prefix + tc + "/>");
                    this.tagsMap.put("" + prefix + tc, run);
                    this.tagsCount.put(Character.valueOf(prefix), tc + 1);
                    continue;
                }
                if (prefix != '\u0000') {
                    res.append("<" + prefix + tc + ">");
                    this.tagsMap.put("" + prefix + tc, run.subList(0, runIter.nextIndex()));
                }
                this.browseRunContents(run, runIter, res);
                if (prefix == '\u0000') continue;
                res.append("</" + prefix + tc + ">");
                this.tagsMap.put("/" + prefix + tc, run.subList(runIter.previousIndex(), run.size()));
                this.tagsCount.put(Character.valueOf(prefix), tc + 1);
                continue;
            }
            if (i == 0) {
                if (run.size() <= 1 || !run.get(1).isStartElement() || !run.get(1).asStartElement().getName().getLocalPart().equals("pPr")) continue;
                this.defaultsForParagraph = run;
                for (int j = 1; j < this.currentPara.size(); ++j) {
                    ListIterator<XMLEvent> ir = this.currentPara.get(j).listIterator();
                    if (!ir.hasNext()) {
                        this.currentPara.remove(j);
                        continue;
                    }
                    XMLEvent ev = ir.next();
                    if (!ev.isStartElement() || !ev.asStartElement().getName().getLocalPart().equals("r")) continue;
                    ev = ir.next();
                    if (!ev.isStartElement() || !ev.asStartElement().getName().getLocalPart().equals("rPr")) {
                        this.defaultsForParagraph = null;
                        continue block1;
                    }
                    while (!(!ir.hasNext() || (ev = ir.next()).isEndElement() && ev.asEndElement().getName().getLocalPart().equals("rPr"))) {
                        if (ev.isEndElement()) continue;
                        if (!ev.isStartElement()) {
                            this.defaultsForParagraph = null;
                            continue block1;
                        }
                        if (this.isInDefaults(ev.asStartElement()) != 1) continue;
                        LinkedList<Attribute> la = new LinkedList<Attribute>();
                        XMLEvent ev2 = ir.next();
                        while (ev2.isAttribute()) {
                            la.add((Attribute)ev2);
                            ev2 = ir.next();
                        }
                        while (ev2 != ev) {
                            ir.remove();
                            ev2 = ir.previous();
                        }
                        ir.remove();
                        ev = this.eFactory.createStartElement(ev.asStartElement().getName(), la.iterator(), ev.asStartElement().getNamespaces());
                        ir.add(ev);
                        if (this.isInDefaults(ev.asStartElement()) != 1) continue;
                        this.defaultsForParagraph = null;
                        continue block1;
                    }
                }
                continue;
            }
            if (i == this.currentPara.size() - 1) break;
            if (run.size() == 1 && run.get(0).isCharacters() && 0 == run.get(0).asCharacters().getData().trim().length()) continue;
            Integer tc = this.tagsCount.get(Character.valueOf('x'));
            if (tc == null) {
                tc = 0;
            }
            res.append("<x" + tc + "/>");
            this.tagsMap.put("x" + tc, run);
            this.tagsCount.put(Character.valueOf('x'), tc + 1);
        }
        if (!this.doCompactTags) {
            return res.toString();
        }
        this.compactBuiltTags(res, PTN_EMPTY_AND_START);
        this.compactBuiltTags(res, PTN_EMPTY_AND_END);
        for (Map.Entry<Character, Integer> me : this.tagsCount.entrySet()) {
            char key = me.getKey().charValue();
            int count = me.getValue();
            for (int i = count - 2; i >= 0; --i) {
                if (res.toString().contains("<" + key + i)) continue;
                for (int j = i + 1; j < count; ++j) {
                    this.tagsMap.put("" + key + (j - 1), (List)this.tagsMap.get("" + key + j));
                    this.tagsMap.put("/" + key + (j - 1), (List)this.tagsMap.get("/" + key + j));
                    this.tagsMap.put("" + key + (j - 1), (List)this.tagsMap.get("" + key + j));
                    Pattern PTN_THIS_TAG = Pattern.compile("(</?)" + key + j + "(/?>)");
                    Matcher mThisTag = PTN_THIS_TAG.matcher(res);
                    while (mThisTag.find()) {
                        res.replace(mThisTag.start(), mThisTag.end(), mThisTag.group(1) + key + (j - 1) + mThisTag.group(2));
                        mThisTag.reset(res);
                    }
                }
            }
        }
        return res.toString();
    }

    private void browseRunContents(List<XMLEvent> run, ListIterator<XMLEvent> runIter, StringBuffer res) {
        block13: while (runIter.hasNext()) {
            XMLEvent next = runIter.next();
            if (next.isEndElement()) {
                if (!next.asEndElement().getName().getLocalPart().equals("r")) continue;
                runIter.previous();
                break;
            }
            if (next.isStartElement()) {
                String name;
                char prefixInt = '\u0000';
                int idx = runIter.previousIndex();
                switch (name = next.asStartElement().getName().getLocalPart()) {
                    case "footnoteRef": {
                        prefixInt = 'n';
                        break;
                    }
                    case "tab": 
                    case "br": {
                        prefixInt = 'd';
                        break;
                    }
                    case "drawing": {
                        prefixInt = 'g';
                        break;
                    }
                    case "t": {
                        continue block13;
                    }
                    default: {
                        prefixInt = 'e';
                    }
                }
                while (!next.isEndElement() || !next.asEndElement().getName().getLocalPart().equals(name)) {
                    next = runIter.next();
                }
                Integer tcInt = this.tagsCount.get(Character.valueOf(prefixInt));
                if (tcInt == null) {
                    tcInt = 0;
                }
                LinkedList<XMLEvent> nList = new LinkedList<XMLEvent>();
                nList.addAll(run.subList(idx, runIter.nextIndex()));
                QName qR = new QName(this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI(), "r", this.OOXML_MAIN_PARA_ELEMENT.getPrefix());
                nList.add(0, this.eFactory.createStartElement(qR, null, null));
                nList.add(this.eFactory.createEndElement(qR, null));
                res.append("<" + prefixInt + tcInt + "/>");
                this.tagsMap.put("" + prefixInt + tcInt, nList);
                continue;
            }
            if (!next.isCharacters()) continue;
            res.append(next.asCharacters().getData());
        }
    }

    private void compactBuiltTags(StringBuffer res, Pattern PTN) {
        Matcher mFull = PTN.matcher(res);
        while (mFull.find()) {
            if (!mFull.group().contains("/>")) continue;
            LinkedList<XMLEvent> lGlobal = (LinkedList<XMLEvent>)this.tagsMap.get(mFull.group(2));
            if (!(lGlobal instanceof LinkedList)) {
                lGlobal = new LinkedList<XMLEvent>();
                lGlobal.addAll((Collection)this.tagsMap.get(mFull.group(2)));
                this.tagsMap.put(mFull.group(2), lGlobal);
            }
            Matcher mUniq = OMEGAT_TAG.matcher(mFull.group(3));
            while (mUniq.find()) {
                lGlobal.addAll((Collection)this.tagsMap.get(mUniq.group(2)));
            }
            LinkedList lToAdd = new LinkedList();
            mUniq = OMEGAT_TAG.matcher(mFull.group(1));
            while (mUniq.find()) {
                lToAdd.addAll((Collection)this.tagsMap.get(mUniq.group(2)));
            }
            Iterator iAdd = lToAdd.descendingIterator();
            while (iAdd.hasNext()) {
                lGlobal.add(0, (XMLEvent)iAdd.next());
            }
            res.replace(mFull.start(), mFull.end(), "<" + mFull.group(2) + ">");
            mFull.reset(res);
        }
    }

    protected char findPrefix(ListIterator<XMLEvent> wr) {
        XMLEvent next = wr.next();
        next = wr.next();
        if (next.isStartElement() && next.asStartElement().getName().getLocalPart().equals("t")) {
            return '\u0000';
        }
        if (next.isStartElement() && next.asStartElement().getName().getLocalPart().equals("rPr")) {
            Object name;
            LinkedList<Object> attrs = new LinkedList<Object>();
            while (!(!wr.hasNext() || (next = wr.next()).isEndElement() && next.asEndElement().getName().getLocalPart().equals("rPr"))) {
                if (!next.isStartElement() || this.defaultsForParagraph != null && this.isInDefaults(next.asStartElement()) > 1 || "lang".equals(name = next.asStartElement().getName().getLocalPart())) continue;
                attrs.add(name);
            }
            while (wr.hasNext()) {
                next = wr.next();
                if (!next.isStartElement()) continue;
                name = next.asStartElement().getName();
                if (((QName)name).equals(this.TEXT_ELEMENT)) break;
                if (((QName)name).getLocalPart().startsWith("footnoteRef")) {
                    return 'n';
                }
                if (((QName)name).getLocalPart().equals("tab")) {
                    return 'd';
                }
                if (((QName)name).getLocalPart().equals("br")) {
                    return 'd';
                }
                if (((QName)name).getLocalPart().equals("fldChar")) {
                    return 'e';
                }
                if (!((QName)name).getLocalPart().equals("instrText")) continue;
                return 'e';
            }
            if (next.isEndElement() && next.asEndElement().getName().getLocalPart().equals("r")) {
                return 'e';
            }
            if (attrs.size() < 1) {
                return '\u0000';
            }
            if (attrs.size() > 1) {
                return 'p';
            }
            switch ((String)attrs.get(0)) {
                case "rStyle": {
                    return 's';
                }
                case "rFonts": 
                case "sz": {
                    return 'f';
                }
                case "b": 
                case "bCs": {
                    return 'b';
                }
                case "i": 
                case "iCs": {
                    return 'i';
                }
                case "u": 
                case "uCs": {
                    return 'u';
                }
                case "caps": 
                case "smallCaps": {
                    return 'C';
                }
                case "color": {
                    return 'c';
                }
                case "strike": 
                case "dStrike": {
                    return 'l';
                }
                case "vertAlign": {
                    return 'v';
                }
                case "lang": {
                    return '\u0000';
                }
            }
        }
        while (wr.hasNext()) {
            next = wr.next();
            if (next.isStartElement()) {
                QName name = next.asStartElement().getName();
                if (name.equals(this.TEXT_ELEMENT)) break;
                if (name.getLocalPart().startsWith("footnoteRef")) {
                    return 'n';
                }
                if (name.getLocalPart().equals("tab")) {
                    return 'd';
                }
                if (name.getLocalPart().equals("br")) {
                    return 'd';
                }
                if (name.getLocalPart().equals("fldChar")) {
                    return 'e';
                }
                if (!name.getLocalPart().equals("instrText")) continue;
                return 'e';
            }
            if (!next.isCharacters()) continue;
            wr.previous();
            return 'o';
        }
        return 'e';
    }

    private int isInDefaults(StartElement stEl) {
        for (XMLEvent dev : this.defaultsForParagraph) {
            Attribute attr0;
            if (!dev.isStartElement() || !dev.asStartElement().getName().equals(stEl.getName())) continue;
            HashMap<QName, String> mapNext = new HashMap<QName, String>();
            HashMap<QName, String> mapDev = new HashMap<QName, String>();
            Iterator<Attribute> iter = dev.asStartElement().getAttributes();
            while (iter.hasNext()) {
                attr0 = iter.next();
                mapDev.put(attr0.getName(), attr0.getValue());
            }
            iter = stEl.getAttributes();
            while (iter.hasNext()) {
                attr0 = iter.next();
                mapNext.put(attr0.getName(), attr0.getValue());
            }
            return mapNext.equals(mapDev) ? 2 : 1;
        }
        return 0;
    }

    @Override
    protected List<XMLEvent> restoreTags(String tra) {
        LinkedList<XMLEvent> res = new LinkedList<XMLEvent>();
        while (tra.length() > 0) {
            Matcher m = OMEGAT_TAG.matcher(tra);
            if (m.find()) {
                List saved;
                if (m.start() > 0) {
                    this.addSimpleRun(res, tra.substring(0, m.start()));
                }
                if ((saved = (List)this.tagsMap.get(m.group(1) + m.group(2))) != null) {
                    res.addAll(saved);
                }
                boolean isAlone = m.group().endsWith("/>");
                tra = tra.substring(m.end());
                m.reset(tra);
                if (isAlone) continue;
                if (!m.find()) {
                    this.addCharacters(res, tra);
                    return res;
                }
                this.addCharacters(res, tra.substring(0, m.start()));
                saved = (List)this.tagsMap.get(m.group(1) + m.group(2));
                if (saved != null) {
                    res.addAll(saved);
                }
                tra = tra.substring(m.end());
                continue;
            }
            this.addSimpleRun(res, tra);
            return res;
        }
        return res;
    }

    private void addSimpleRun(LinkedList<XMLEvent> res, String text) {
        QName qR = new QName(this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI(), "r", this.OOXML_MAIN_PARA_ELEMENT.getPrefix());
        QName qT = new QName(this.OOXML_MAIN_PARA_ELEMENT.getNamespaceURI(), "t", this.OOXML_MAIN_PARA_ELEMENT.getPrefix());
        res.add(this.eFactory.createStartElement(qR, null, null));
        if (this.defaultsForParagraph != null) {
            boolean inRpr = false;
            for (XMLEvent ev : this.defaultsForParagraph) {
                if (ev.isStartElement() && ev.asStartElement().getName().getLocalPart().equals("rPr")) {
                    inRpr = true;
                }
                if (inRpr) {
                    res.add(ev);
                }
                if (!ev.isEndElement() || !ev.asEndElement().getName().getLocalPart().equals("rPr")) continue;
                break;
            }
        }
        res.add(this.eFactory.createStartElement(qT, null, null));
        this.addCharacters(res, text);
        res.add(this.eFactory.createEndElement(qT, null));
        res.add(this.eFactory.createEndElement(qR, null));
    }

    private void addCharacters(LinkedList<XMLEvent> res, String text) {
        if (text.trim().equals(text)) {
            res.add(this.eFactory.createCharacters(text));
            return;
        }
        XMLEvent lastEv = res.getLast();
        if (lastEv.isStartElement() && lastEv.asStartElement().getName().getLocalPart().equals("t")) {
            Attribute attr;
            boolean hasPreserve = false;
            Iterator<Attribute> I = lastEv.asStartElement().getAttributes();
            while (I.hasNext() && !(hasPreserve = "space".equals((attr = I.next()).getName().getLocalPart()))) {
            }
            if (!hasPreserve) {
                res.add(this.eFactory.createAttribute("xml", "http://www.w3.org/XML/1998/namespace", "space", "preserve"));
            }
        }
        res.add(this.eFactory.createCharacters(text));
    }
}

