/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.omegat.util.Log;
import org.omegat.util.gui.StaticUIUtils;

public final class UIThreadsUtil {
    private UIThreadsUtil() {
    }

    public static void executeInSwingThread(Runnable code) {
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public static <T> T returnResultFromSwingThread(Supplier<T> s) {
        if (SwingUtilities.isEventDispatchThread()) {
            return s.get();
        }
        AtomicReference reference = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(() -> reference.set(s.get()));
        }
        catch (InterruptedException | InvocationTargetException e) {
            Logger.getLogger(StaticUIUtils.class.getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return (T)reference.get();
    }

    public static void mustBeSwingThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Log.logErrorRB("LOG_ERROR_MUST_BE_SWING_THREAD", new Object[0]);
            Log.log(new Exception());
        }
    }

    public static void mustNotBeSwingThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            Log.logErrorRB("LOG_ERROR_MUSTNOT_BE_SWING_THREAD", new Object[0]);
            Log.log(new Exception());
        }
    }
}

