/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.Serializable;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.sort.Ordered;
import org.htmlparser.util.sort.Sort;
import org.htmlparser.util.sort.Sortable;

public class PageIndex
implements Serializable,
Sortable {
    protected static final int mStartIncrement = 100;
    protected int mIncrement;
    protected int mCount;
    protected int[] mIndices;
    protected Page mPage;

    public PageIndex(Page page) {
        this.mPage = page;
        this.mIndices = new int[this.mIncrement];
        this.mCount = 0;
        this.mIncrement = 200;
    }

    public PageIndex(Page page, int cursor) {
        this(page);
        this.mIndices[0] = cursor;
        this.mCount = 1;
    }

    public PageIndex(Page page, int[] cursors) {
        this.mPage = page;
        this.mIndices = cursors;
        this.mCount = cursors.length;
    }

    public Page getPage() {
        return this.mPage;
    }

    public int size() {
        return this.mCount;
    }

    public int capacity() {
        return this.mIndices.length;
    }

    public int add(Cursor cursor) {
        int ret;
        int position = cursor.getPosition();
        if (0 == this.mCount) {
            ret = 0;
            this.insertElementAt(position, ret);
        } else {
            int last = this.mIndices[this.mCount - 1];
            if (position == last) {
                ret = this.mCount - 1;
            } else if (position > last) {
                ret = this.mCount;
                this.insertElementAt(position, ret);
            } else {
                ret = Sort.bsearch(this, (Ordered)cursor);
                if (ret >= this.size() || position != this.mIndices[ret]) {
                    this.insertElementAt(position, ret);
                }
            }
        }
        return ret;
    }

    public int add(int cursor) {
        return this.add(new Cursor(this.getPage(), cursor));
    }

    public void remove(Cursor cursor) {
        int i = Sort.bsearch(this, (Ordered)cursor);
        if (i < this.size() && cursor.getPosition() == this.mIndices[i]) {
            this.removeElementAt(i);
        }
    }

    public void remove(int cursor) {
        this.remove(new Cursor(this.getPage(), cursor));
    }

    public int elementAt(int index) {
        if (index >= this.mCount) {
            throw new IndexOutOfBoundsException("index " + index + " beyond current limit");
        }
        return this.mIndices[index];
    }

    public int row(Cursor cursor) {
        int ret = Sort.bsearch(this, (Ordered)cursor);
        if (ret < this.mCount && cursor.getPosition() == this.mIndices[ret]) {
            ++ret;
        }
        return ret;
    }

    public int row(int cursor) {
        return this.row(new Cursor(this.getPage(), cursor));
    }

    public int column(Cursor cursor) {
        int row = this.row(cursor);
        int previous = 0 != row ? this.elementAt(row - 1) : 0;
        return cursor.getPosition() - previous;
    }

    public int column(int cursor) {
        return this.column(new Cursor(this.getPage(), cursor));
    }

    public int[] get() {
        int[] ret = new int[this.size()];
        System.arraycopy(this.mIndices, 0, ret, 0, this.size());
        return ret;
    }

    protected int bsearch(int cursor) {
        return Sort.bsearch(this, (Ordered)new Cursor(this.getPage(), cursor));
    }

    protected int bsearch(int cursor, int first, int last) {
        return Sort.bsearch(this, (Ordered)new Cursor(this.getPage(), cursor), first, last);
    }

    protected void insertElementAt(int cursor, int index) {
        if (index >= this.capacity() || this.size() == this.capacity()) {
            int[] new_values = new int[Math.max(this.capacity() + this.mIncrement, index + 1)];
            this.mIncrement *= 2;
            if (index < this.capacity()) {
                System.arraycopy(this.mIndices, 0, new_values, 0, index);
                System.arraycopy(this.mIndices, index, new_values, index + 1, this.capacity() - index);
            } else {
                System.arraycopy(this.mIndices, 0, new_values, 0, this.capacity());
            }
            this.mIndices = new_values;
        } else if (index < this.size()) {
            System.arraycopy(this.mIndices, index, this.mIndices, index + 1, this.capacity() - (index + 1));
        }
        this.mIndices[index] = cursor;
        ++this.mCount;
    }

    protected void removeElementAt(int index) {
        System.arraycopy(this.mIndices, index + 1, this.mIndices, index, this.capacity() - (index + 1));
        this.mIndices[this.capacity() - 1] = 0;
        --this.mCount;
    }

    @Override
    public int first() {
        return 0;
    }

    @Override
    public int last() {
        return this.mCount - 1;
    }

    @Override
    public Ordered fetch(int index, Ordered reuse) {
        Cursor ret;
        if (null != reuse) {
            ret = (Cursor)reuse;
            ret.mPosition = this.mIndices[index];
            ret.mPage = this.getPage();
        } else {
            ret = new Cursor(this.getPage(), this.mIndices[index]);
        }
        return ret;
    }

    @Override
    public void swap(int i, int j) {
        int temp = this.mIndices[i];
        this.mIndices[i] = this.mIndices[j];
        this.mIndices[j] = temp;
    }
}

