package org.cdavies.itunes;

import java.io.*;
import org.cdavies.itunes.hash.*;
import org.cdavies.itunes.request.*;

public class Itunes45Track implements Track {
	
	private int _trackId;
	private String _trackName;
	private String _albumName;
	private String _artistName;
	private int _trackNum;
	private String _genre;
	private int _rating;
	private String _format;
	private int _length;
	private int _dbId;
	
	public ItunesConnection _conn;
	private ItunesHash _hash;
	
	public Itunes45Track() {
		
		_trackId = -1;
		_trackName = null;
		_albumName = null;
		_artistName = null;
		_trackNum = -1;
		_genre = null;
		_rating = -1;
		_format = null;
		_length = -1;
		
	}
	
	public int getTrackId() {
		
		return _trackId;
	
	}
	
	public void setTrackId(int trackId) {
		
		_trackId = trackId;
		
	}
	
	public String getTrackName() {
		
		return _trackName;
		
	}
	
	public void setTrackName(String name) {
		
		_trackName = name;
		
	}
	
	public String getAlbumName() {
		
		return _albumName;
		
	}
	
	public void setAlbumName(String name) {
		
		_albumName = name;
		
	}
	
	public String getArtistName() {
		
		return _artistName;
		
	}
	
	public void setArtistName(String name) {
		
		_artistName = name;
		
	}
	
	public int getTrackNumber() {
		
		return _trackNum;
		
	}
	
	public void setTrackNumber(int num) {
		
		_trackNum = num;
		
	}
	
	public String getGenre() {
		
		return _genre;
		
	}
	
	public void setGenre(String genre) {
		
		_genre = genre;
		
	}
	
	public int getRating() {
		
		return _rating;
		
	}
	
	public void setRating(int rating) {
		
		_rating = rating;
		
	}
	
	public String getFormat() {
		
		return _format;
		
	}
	
	public void setFormat(String format) {
		
		_format = format;
		
	}
	
	public int getLength() {
		
		return _length;
		
	}
	
	public void setLength(int len) {
		
		_length = len;
		
	}
	
	public void setDatabaseId(int dbId) {
		
		_dbId = dbId;
		
	}
	
	public int getDatabaseId() {
		
		return _dbId;
		
	}
	
	public void setItunesConnection(ItunesConnection conn) {
		
		_conn = conn;
		
	}
	
	public void setItunesHash(ItunesHash hash) {
		
		_hash = hash;
		
	}
	
	public InputStream getInputStream() throws NoServerPermissionException {
		
		((Itunes45Connection)_conn).refreshConnection();
		
		TrackRequest _req = new Itunes45TrackRequest(_conn.getServerName(), _conn.getPort(), _conn.getSessionId(), getDatabaseId(), getTrackId(), getFormat(), _conn.getRequestNumber());
		_req.setHash(_hash);
		_req.constructQuery();
		_req.runQuery();
		_req.process();
		
		return _req.getInputStream();
		
	}
	
	public boolean equals(Track t) {
		
		return (getTrackId() == t.getTrackId()) && (getTrackName().equals(t.getTrackName()))
			&& (getAlbumName().equals(t.getAlbumName())) && (getArtistName().equals(t.getAlbumName()))
			&& (getTrackNumber() == t.getTrackNumber()) && (getGenre().equals(t.getGenre()))
			&& (getRating() == t.getRating()) && (getFormat().equals(t.getFormat()))
			&& (getLength() == t.getLength());
		
	}
	
	public String toString() {
		
		return getTrackName() + " - " + getArtistName();
		
	}
	
}
