/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.stream.IntStream;
import vcf.GT;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfRecBuilder;

public final class VcfWriter {
    private static final String FILE_FORMAT = "##fileformat=VCFv4.2";
    private static final String AF_INFO = "##INFO=<ID=AF,Number=A,Type=Float,Description=\"Estimated ALT Allele Frequencies\">";
    private static final String DR2_INFO = "##INFO=<ID=DR2,Number=A,Type=Float,Description=\"Dosage R-Squared: estimated squared correlation between estimated REF dose [P(RA) + 2*P(RR)] and true REF dose\">";
    private static final String IMP_INFO = "##INFO=<ID=IMP,Number=0,Type=Flag,Description=\"Imputed marker\">";
    private static final String GT_FORMAT = "##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
    private static final String DS_FORMAT = "##FORMAT=<ID=DS,Number=A,Type=Float,Description=\"estimated ALT dose [P(RA) + 2*P(AA)]\">";
    private static final String AP1_FORMAT = "##FORMAT=<ID=AP1,Number=A,Type=Float,Description=\"estimated ALT dose on first haplotype\">";
    private static final String AP2_FORMAT = "##FORMAT=<ID=AP2,Number=A,Type=Float,Description=\"estimated ALT dose on second haplotype\">";
    private static final String GL_FORMAT = "##FORMAT=<ID=GL,Number=G,Type=Float,Description=\"Log10-scaled Genotype Likelihood\">";
    private static final String GP_FORMAT = "##FORMAT=<ID=GP,Number=G,Type=Float,Description=\"Estimated Genotype Probability\">";
    private static final String SHORT_CHROM_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO";
    private static final String LONG_CHROM_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";

    private VcfWriter() {
    }

    public static void writeMetaLinesGT(String[] stringArray, String string, PrintWriter printWriter) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        VcfWriter.writeMetaLines(stringArray, string, bl, bl2, bl3, bl4, printWriter);
    }

    public static void writeMetaLines(String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, PrintWriter printWriter) {
        printWriter.print(FILE_FORMAT);
        printWriter.print(Const.nl);
        printWriter.print("##filedate=");
        printWriter.print(VcfWriter.now());
        printWriter.print(Const.nl);
        if (string != null) {
            printWriter.print("##source=\"");
            printWriter.print(string);
            printWriter.println("\"");
        }
        if (bl) {
            printWriter.println(AF_INFO);
            printWriter.println(DR2_INFO);
            printWriter.println(IMP_INFO);
        }
        printWriter.println(GT_FORMAT);
        if (bl) {
            printWriter.println(DS_FORMAT);
        }
        if (bl2) {
            printWriter.println(AP1_FORMAT);
            printWriter.println(AP2_FORMAT);
        }
        if (bl3) {
            printWriter.println(GP_FORMAT);
        }
        if (bl4) {
            printWriter.println(GL_FORMAT);
        }
        printWriter.print(LONG_CHROM_PREFIX);
        for (String string2 : stringArray) {
            if (string2 == null) {
                throw new NullPointerException("id==null");
            }
            printWriter.print('\t');
            printWriter.print(string2);
        }
        printWriter.println();
    }

    private static String now() {
        String string = "yyyyMMdd";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static void appendRecords(GT gT, int n, int n2, PrintWriter printWriter) {
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        if (!gT.isPhased()) {
            throw new IllegalArgumentException("unphased genotypes");
        }
        Samples samples = gT.samples();
        VcfRecBuilder[] vcfRecBuilderArray = VcfWriter.recBuilders(gT, n, n2);
        int n3 = gT.nSamples();
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            if (samples.isDiploid(i)) {
                n5 = i << 1;
                n4 = n5 | 1;
                for (int j = n; j < n2; ++j) {
                    int n6 = gT.allele(j, n5);
                    int n7 = gT.allele(j, n4);
                    vcfRecBuilderArray[j - n].addSampleData(n6, n7);
                }
                continue;
            }
            for (n5 = n; n5 < n2; ++n5) {
                n4 = gT.allele(n5, i << 1);
                vcfRecBuilderArray[n5 - n].addSampleData(n4);
            }
        }
        for (VcfRecBuilder vcfRecBuilder : vcfRecBuilderArray) {
            vcfRecBuilder.writeRec(printWriter);
        }
    }

    private static VcfRecBuilder[] recBuilders(GT gT, int n, int n3) {
        int n4 = gT.nSamples();
        return (VcfRecBuilder[])IntStream.range(n, n3).mapToObj(n2 -> new VcfRecBuilder(gT.marker(n2), n4)).toArray(VcfRecBuilder[]::new);
    }

    public static void printFixedFieldsGT(Marker marker, PrintWriter printWriter) {
        printWriter.print(marker);
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("PASS");
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("GT");
    }
}

