/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.SimulcastMode;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceRidGroupPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.impl.JidCreate;

public class ColibriConferenceIqProvider
extends IqProvider<ColibriConferenceIQ> {
    private static final Logger logger = new LoggerImpl(ColibriConferenceIqProvider.class.getName());

    public ColibriConferenceIqProvider() {
        ProviderManager.addExtensionProvider("payload-type", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        ProviderManager.addExtensionProvider("rtcp-fb", "urn:xmpp:jingle:apps:rtp:rtcp-fb:0", new DefaultPacketExtensionProvider<RtcpFbPacketExtension>(RtcpFbPacketExtension.class));
        ProviderManager.addExtensionProvider("rtp-hdrext", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        ProviderManager.addExtensionProvider("source", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourcePacketExtension>(SourcePacketExtension.class));
        ProviderManager.addExtensionProvider("ssrc-group", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceGroupPacketExtension>(SourceGroupPacketExtension.class));
        ProviderManager.addExtensionProvider("rid-group", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceRidGroupPacketExtension>(SourceRidGroupPacketExtension.class));
        DefaultPacketExtensionProvider<ParameterPacketExtension> parameterProvider = new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class);
        ProviderManager.addExtensionProvider("parameter", "http://jitsi.org/protocol/colibri", parameterProvider);
        ProviderManager.addExtensionProvider("parameter", "urn:xmpp:jingle:apps:rtp:ssma:0", parameterProvider);
        ProviderManager.addExtensionProvider("ssrc-info", "http://jitsi.org/jitmeet", new DefaultPacketExtensionProvider<SSRCInfoPacketExtension>(SSRCInfoPacketExtension.class));
        DefaultPacketExtensionProvider<ColibriConferenceIQ.GracefulShutdown> shutdownProvider = new DefaultPacketExtensionProvider<ColibriConferenceIQ.GracefulShutdown>(ColibriConferenceIQ.GracefulShutdown.class);
        ProviderManager.addExtensionProvider("graceful-shutdown", "http://jitsi.org/protocol/colibri", shutdownProvider);
    }

    private void addChildExtension(ColibriConferenceIQ.Channel channel, ExtensionElement childExtension) {
        if (childExtension instanceof PayloadTypePacketExtension) {
            PayloadTypePacketExtension payloadType = (PayloadTypePacketExtension)childExtension;
            if ("opus".equals(payloadType.getName()) && payloadType.getChannels() != 2) {
                payloadType.setChannels(2);
            }
            channel.addPayloadType(payloadType);
        } else if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            channel.setTransport(transport);
        } else if (childExtension instanceof SourcePacketExtension) {
            channel.addSource((SourcePacketExtension)childExtension);
        } else if (childExtension instanceof SourceGroupPacketExtension) {
            SourceGroupPacketExtension sourceGroup = (SourceGroupPacketExtension)childExtension;
            channel.addSourceGroup(sourceGroup);
        } else if (childExtension instanceof RTPHdrExtPacketExtension) {
            RTPHdrExtPacketExtension rtpHdrExtPacketExtension = (RTPHdrExtPacketExtension)childExtension;
            channel.addRtpHeaderExtension(rtpHdrExtPacketExtension);
        } else {
            logger.error("Ignoring a child of 'channel' of unknown type: " + childExtension);
        }
    }

    private void addChildExtension(ColibriConferenceIQ.ChannelBundle bundle, ExtensionElement childExtension) {
        if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            bundle.setTransport(transport);
        }
    }

    private void addChildExtension(ColibriConferenceIQ.SctpConnection sctpConnection, ExtensionElement childExtension) {
        if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            sctpConnection.setTransport(transport);
        }
    }

    private ExtensionElement parseExtension(XmlPullParser parser2, String name, String namespace) throws XmlPullParserException, IOException, SmackParsingException {
        ExtensionElement extension;
        ExtensionElementProvider<ExtensionElement> extensionProvider = ProviderManager.getExtensionProvider(name, namespace);
        if (extensionProvider == null) {
            logger.warn(() -> "Should parse {" + namespace + "}:" + name + ", but found no extension provider");
            this.throwAway(parser2, name);
            extension = null;
        } else {
            extension = (ExtensionElement)extensionProvider.parse(parser2);
        }
        return extension;
    }

    @Override
    public ColibriConferenceIQ parse(XmlPullParser parser2, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ColibriConferenceIQ iq;
        String namespace = parser2.getNamespace();
        if ("conference".equals(parser2.getName()) && "http://jitsi.org/protocol/colibri".equals(namespace)) {
            String rtcstatsEnabled;
            String callstatsEnabled;
            String meetingId;
            String conferenceName;
            String conferenceGID;
            ColibriConferenceIQ conference = new ColibriConferenceIQ();
            String conferenceID = parser2.getAttributeValue("", "id");
            if (conferenceID != null && conferenceID.length() != 0) {
                conference.setID(conferenceID);
            }
            if ((conferenceGID = parser2.getAttributeValue("", "gid")) != null && conferenceGID.length() != 0) {
                conference.setGID(conferenceGID);
            }
            if (StringUtils.isNotEmpty(conferenceName = parser2.getAttributeValue("", "name"))) {
                conference.setName(JidCreate.entityBareFrom(conferenceName));
            }
            if (StringUtils.isNotEmpty(meetingId = parser2.getAttributeValue("", "meeting-id"))) {
                conference.setMeetingId(meetingId);
            }
            if (StringUtils.isNotEmpty(callstatsEnabled = parser2.getAttributeValue("", "callstats-enabled"))) {
                conference.setCallStatsEnabled(Boolean.parseBoolean(callstatsEnabled));
            }
            if (StringUtils.isNotEmpty(rtcstatsEnabled = parser2.getAttributeValue("", "rtcstats-enabled"))) {
                conference.setRtcStatsEnabled(Boolean.parseBoolean(rtcstatsEnabled));
            }
            boolean done = false;
            ColibriConferenceIQ.Channel channel = null;
            ColibriConferenceIQ.RTCPTerminationStrategy rtcpTerminationStrategy = null;
            ColibriConferenceIQ.SctpConnection sctpConnection = null;
            ColibriConferenceIQ.ChannelBundle bundle = null;
            ColibriConferenceIQ.Content content = null;
            ColibriConferenceIQ.Recording recording = null;
            ColibriConferenceIQ.Endpoint conferenceEndpoint = null;
            StringBuilder ssrc2 = null;
            while (!done) {
                switch (parser2.next()) {
                    case END_ELEMENT: {
                        String name = parser2.getName();
                        if ("conference".equals(name)) {
                            done = true;
                            break;
                        }
                        if ("channel".equals(name)) {
                            content.addChannel(channel);
                            channel = null;
                            break;
                        }
                        if ("sctpconnection".equals(name)) {
                            if (sctpConnection != null) {
                                content.addSctpConnection(sctpConnection);
                            }
                            sctpConnection = null;
                            break;
                        }
                        if ("channel-bundle".equals(name)) {
                            if (bundle == null) break;
                            if (conference.addChannelBundle(bundle) != null) {
                                logger.warn("Replacing a channel-bundle with the sameID (not a valid Colibri packet).");
                            }
                            bundle = null;
                            break;
                        }
                        if ("endpoint".equals(name)) {
                            if (conference.addEndpoint(conferenceEndpoint) != null) {
                                logger.warn("Replacing an endpoint element with the sameID (not a valid Colibri packet).");
                            }
                            conferenceEndpoint = null;
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            String s2 = ssrc2.toString().trim();
                            if (s2.length() != 0) {
                                int i = s2.startsWith("-") ? Integer.parseInt(s2) : (int)Long.parseLong(s2);
                                channel.addSSRC(i);
                            }
                            ssrc2 = null;
                            break;
                        }
                        if ("content".equals(name)) {
                            conference.addContent(content);
                            content = null;
                            break;
                        }
                        if ("rtcp-termination-strategy".equals(name)) {
                            conference.setRTCPTerminationStrategy(rtcpTerminationStrategy);
                            rtcpTerminationStrategy = null;
                            break;
                        }
                        if ("recording".equals(name)) {
                            conference.setRecording(recording);
                            recording = null;
                            break;
                        }
                        if (!"graceful-shutdown".equals(name)) break;
                        conference.setGracefulShutdown(true);
                        break;
                    }
                    case START_ELEMENT: {
                        String id;
                        String channelBundleId;
                        String name = parser2.getName();
                        if ("channel".equals(name)) {
                            String rtpPort;
                            String rtpLevelRelayType;
                            String rtcpPort;
                            String receivingSimulcastLayer;
                            String simulcastMode;
                            String lastN;
                            String initiator;
                            String channelID;
                            String host;
                            String packetDelay;
                            String expire;
                            String endpoint;
                            String type2 = parser2.getAttributeValue("", "type");
                            channel = "octo".equals(type2) ? new ColibriConferenceIQ.OctoChannel() : new ColibriConferenceIQ.Channel();
                            String direction = parser2.getAttributeValue("", "direction");
                            if (direction != null && direction.length() != 0) {
                                channel.setDirection(direction);
                            }
                            if (StringUtils.isNotEmpty(endpoint = parser2.getAttributeValue("", "endpoint"))) {
                                channel.setEndpoint(endpoint);
                            }
                            if (StringUtils.isNotEmpty(channelBundleId = parser2.getAttributeValue("", "channel-bundle-id"))) {
                                channel.setChannelBundleId(channelBundleId);
                            }
                            if ((expire = parser2.getAttributeValue("", "expire")) != null && expire.length() != 0) {
                                channel.setExpire(Integer.parseInt(expire));
                            }
                            if (StringUtils.isNotEmpty(packetDelay = parser2.getAttributeValue("", "packet-delay"))) {
                                channel.setPacketDelay(Integer.parseInt(packetDelay));
                            }
                            if ((host = parser2.getAttributeValue("", "host")) != null && host.length() != 0) {
                                channel.setHost(host);
                            }
                            if ((channelID = parser2.getAttributeValue("", "id")) != null && channelID.length() != 0) {
                                channel.setID(channelID);
                            }
                            if ((initiator = parser2.getAttributeValue("", "initiator")) != null && initiator.length() != 0) {
                                channel.setInitiator(Boolean.valueOf(initiator));
                            }
                            if ((lastN = parser2.getAttributeValue("", "last-n")) != null && lastN.length() != 0) {
                                channel.setLastN(Integer.parseInt(lastN));
                            }
                            if (StringUtils.isNotEmpty(simulcastMode = parser2.getAttributeValue("", "simulcast-mode"))) {
                                channel.setSimulcastMode(SimulcastMode.fromString(simulcastMode));
                            }
                            if ((receivingSimulcastLayer = parser2.getAttributeValue("", "receive-simulcast-layer")) != null && receivingSimulcastLayer.length() != 0) {
                                channel.setReceivingSimulcastLayer(Integer.parseInt(receivingSimulcastLayer));
                            }
                            if ((rtcpPort = parser2.getAttributeValue("", "rtcpport")) != null && rtcpPort.length() != 0) {
                                channel.setRTCPPort(Integer.parseInt(rtcpPort));
                            }
                            if ((rtpLevelRelayType = parser2.getAttributeValue("", "rtp-level-relay-type")) != null && rtpLevelRelayType.length() != 0) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if ((rtpPort = parser2.getAttributeValue("", "rtpport")) == null || rtpPort.length() == 0) break;
                            channel.setRTPPort(Integer.parseInt(rtpPort));
                            break;
                        }
                        if ("channel-bundle".equals(name)) {
                            String bundleId = parser2.getAttributeValue("", "id");
                            if (!StringUtils.isNotEmpty(bundleId)) break;
                            bundle = new ColibriConferenceIQ.ChannelBundle(bundleId);
                            break;
                        }
                        if ("rtcp-termination-strategy".equals(name)) {
                            rtcpTerminationStrategy = new ColibriConferenceIQ.RTCPTerminationStrategy();
                            String strategyName = parser2.getAttributeValue("", "name");
                            if (strategyName == null || strategyName.length() == 0) break;
                            rtcpTerminationStrategy.setName(strategyName);
                            break;
                        }
                        if ("relay".equals(name)) {
                            id = parser2.getAttributeValue("", "id");
                            if (id == null || !(channel instanceof ColibriConferenceIQ.OctoChannel)) break;
                            ((ColibriConferenceIQ.OctoChannel)channel).addRelay(id);
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            ssrc2 = new StringBuilder();
                            break;
                        }
                        if ("content".equals(name)) {
                            content = new ColibriConferenceIQ.Content();
                            String contentName = parser2.getAttributeValue("", "name");
                            if (contentName == null || contentName.length() == 0) break;
                            content.setName(contentName);
                            break;
                        }
                        if ("recording".equals(name)) {
                            String stateStr = parser2.getAttributeValue("", "state");
                            String token = parser2.getAttributeValue("", "token");
                            recording = new ColibriConferenceIQ.Recording(stateStr, token);
                            break;
                        }
                        if ("sctpconnection".equals(name)) {
                            String expire;
                            String initiator;
                            String port2;
                            String endpoint = parser2.getAttributeValue("", "endpoint");
                            String connID = parser2.getAttributeValue("", "id");
                            if (StringUtils.isEmpty(connID) && StringUtils.isEmpty(endpoint)) {
                                sctpConnection = null;
                                break;
                            }
                            sctpConnection = new ColibriConferenceIQ.SctpConnection();
                            if (StringUtils.isNotEmpty(connID)) {
                                sctpConnection.setID(connID);
                            }
                            if (StringUtils.isNotEmpty(endpoint)) {
                                sctpConnection.setEndpoint(endpoint);
                            }
                            if (StringUtils.isNotEmpty(port2 = parser2.getAttributeValue("", "port"))) {
                                sctpConnection.setPort(Integer.parseInt(port2));
                            }
                            if (StringUtils.isNotEmpty(channelBundleId = parser2.getAttributeValue("", "channel-bundle-id"))) {
                                sctpConnection.setChannelBundleId(channelBundleId);
                            }
                            if (StringUtils.isNotEmpty(initiator = parser2.getAttributeValue("", "initiator"))) {
                                sctpConnection.setInitiator(Boolean.valueOf(initiator));
                            }
                            if (!StringUtils.isNotEmpty(expire = parser2.getAttributeValue("", "expire"))) break;
                            sctpConnection.setExpire(Integer.parseInt(expire));
                            break;
                        }
                        if ("endpoint".equals(name)) {
                            id = parser2.getAttributeValue("", "id");
                            String displayName = parser2.getAttributeValue("", "displayname");
                            String statsId = parser2.getAttributeValue("", "stats-id");
                            if (!StringUtils.isNotEmpty(id)) break;
                            conferenceEndpoint = new ColibriConferenceIQ.Endpoint(id, statsId, displayName);
                            break;
                        }
                        if (channel == null && sctpConnection == null && bundle == null) break;
                        String peName = null;
                        String peNamespace = null;
                        if ("transport".equals(name) && "urn:xmpp:jingle:transports:ice-udp:1".equals(parser2.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:ice-udp:1";
                        } else if ("payload-type".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("rtcp-fb".equals(name) && "urn:xmpp:jingle:apps:rtp:rtcp-fb:0".equals(parser2.getNamespace())) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("rtp-hdrext".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("transport".equals(name) && "urn:xmpp:jingle:transports:raw-udp:1".equals(parser2.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:raw-udp:1";
                        } else if ("source".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser2.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        } else if ("ssrc-group".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser2.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        } else if ("rid-group".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser2.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        }
                        if (peName == null) {
                            this.throwAway(parser2, name);
                            break;
                        }
                        ExtensionElement extension = this.parseExtension(parser2, peName, peNamespace);
                        if (extension == null) break;
                        if (channel != null) {
                            this.addChildExtension(channel, extension);
                            break;
                        }
                        if (sctpConnection != null) {
                            this.addChildExtension(sctpConnection, extension);
                            break;
                        }
                        this.addChildExtension(bundle, extension);
                        break;
                    }
                    case TEXT_CHARACTERS: {
                        if (ssrc2 == null) break;
                        ssrc2.append(parser2.getText());
                    }
                }
            }
            iq = conference;
        } else {
            iq = null;
        }
        return iq;
    }

    private void throwAway(XmlPullParser parser2, String name) throws XmlPullParserException, IOException, SmackParsingException {
        while (XmlPullParser.Event.END_ELEMENT != parser2.next() || !name.equals(parser2.getName())) {
        }
    }
}

