/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.SCCSHistoryParser;
import org.opensolaris.opengrok.history.SCCSget;

public class SCCSRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.SCCS";
    public static final String CMD_FALLBACK = "sccs";
    private Map<String, String> authors_cache;
    private static final Pattern AUTHOR_PATTERN = Pattern.compile("^([\\d.]+)\\s+(\\S+)");
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("^([\\d.]+)\\s+");

    public SCCSRepository() {
        this.type = "SCCS";
        this.datePattern = "yy/MM/dd";
    }

    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        try {
            File history = SCCSHistoryParser.getSCCSFile(parent, basename);
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            return SCCSget.getRevision(this.cmd, history, rev);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while getting revision", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAuthors(File file) throws IOException {
        this.authors_cache = new HashMap<String, String>();
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("prs");
        argv.add("-e");
        argv.add("-d");
        argv.add(":I: :P:");
        argv.add(file.getCanonicalPath());
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(file.getCanonicalFile().getParentFile());
        Process process = null;
        try {
            process = pb.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                int lineno = 0;
                while ((line = in.readLine()) != null) {
                    ++lineno;
                    Matcher matcher = AUTHOR_PATTERN.matcher(line);
                    if (matcher.find()) {
                        String rev = matcher.group(1);
                        String auth = matcher.group(2);
                        this.authors_cache.put(rev, auth);
                        continue;
                    }
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find authors in line {0}: [{1}]", new Object[]{lineno, line});
                }
            }
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    process.destroy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation annotate(File file, String revision) throws IOException {
        this.getAuthors(file);
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("get");
        argv.add("-m");
        argv.add("-p");
        if (revision != null) {
            argv.add("-r" + revision);
        }
        argv.add(file.getCanonicalPath());
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(file.getCanonicalFile().getParentFile());
        Process process = null;
        try {
            process = pb.start();
            Annotation a = new Annotation(file.getName());
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                int lineno = 0;
                while ((line = in.readLine()) != null) {
                    ++lineno;
                    Matcher matcher = ANNOTATION_PATTERN.matcher(line);
                    if (matcher.find()) {
                        String rev = matcher.group(1);
                        String author = this.authors_cache.get(rev);
                        if (author == null) {
                            author = "unknown";
                        }
                        a.addLine(rev, author, true);
                        continue;
                    }
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find annotations in line {0}: [{1}]", new Object[]{lineno, line});
                }
            }
            Annotation annotation = a;
            return annotation;
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    process.destroy();
                }
            }
        }
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean fileHasHistory(File file) {
        String parent = file.getParent();
        String name = file.getName();
        File f = new File(parent + "/SCCS/s." + name);
        return f.exists();
    }

    @Override
    boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File f = new File(file, "codemgr_wsdata");
            if (f.isDirectory()) {
                return true;
            }
            f = new File(file, "Codemgr_wsdata");
            if (f.isDirectory()) {
                return true;
            }
            return new File(file, "SCCS").isDirectory();
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = SCCSRepository.checkCmd(this.cmd, "help", "help");
            if (!this.working.booleanValue()) {
                this.working = SCCSRepository.checkCmd(this.cmd, "--version");
            }
        }
        return this.working;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return false;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new SCCSHistoryParser().parse(file, this);
    }
}

