/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.spider;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.view.View;

public class SpiderPanel
extends AbstractPanel {
    private JSplitPane splitPane = null;
    private JPanel leftPanel = null;
    private JPanel rightPanel = null;
    private JLabel jLabel = null;
    private JTextArea txtURIFound = null;
    private JScrollPane jScrollPane = null;
    private JLabel jLabel1 = null;
    private JTextArea txtURISkip = null;
    private JScrollPane jScrollPane1 = null;

    public SpiderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(700, 214);
        this.setName("Spider");
        this.add((Component)this.getSplitPane(), this.getSplitPane().getName());
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setName("splitPane");
            this.splitPane.setDividerSize(3);
            this.splitPane.setDividerLocation(120);
            this.splitPane.setOrientation(0);
            this.splitPane.setTopComponent(this.getLeftPanel());
            this.splitPane.setBottomComponent(this.getRightPanel());
            this.splitPane.setResizeWeight(0.5);
        }
        return this.splitPane;
    }

    private JPanel getLeftPanel() {
        if (this.leftPanel == null) {
            this.jLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.leftPanel = new JPanel();
            this.leftPanel.setLayout(new GridBagLayout());
            this.jLabel.setText("URI found during crawl:");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints2.anchor = 18;
            this.leftPanel.add((Component)this.jLabel, gridBagConstraints);
            this.leftPanel.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.leftPanel;
    }

    private JPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.jLabel1 = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new GridBagLayout());
            this.jLabel1.setText("URI found but out of crawl scope:");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.ipady = 24;
            this.rightPanel.add((Component)this.jLabel1, gridBagConstraints);
            this.rightPanel.add((Component)this.getJScrollPane1(), gridBagConstraints2);
        }
        return this.rightPanel;
    }

    JTextArea getTxtURIFound() {
        if (this.txtURIFound == null) {
            this.txtURIFound = new JTextArea();
            this.txtURIFound.setFont(new Font("Dialog", 0, 11));
            this.txtURIFound.setEditable(false);
            this.txtURIFound.setLineWrap(true);
            this.txtURIFound.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.txtURIFound;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtURIFound());
            this.jScrollPane.setFont(new Font("Dialog", 0, 11));
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.jScrollPane;
    }

    JTextArea getTxtURISkip() {
        if (this.txtURISkip == null) {
            this.txtURISkip = new JTextArea();
            this.txtURISkip.setEditable(false);
            this.txtURISkip.setFont(new Font("Dialog", 0, 11));
            this.txtURISkip.setLineWrap(true);
            this.txtURISkip.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.txtURISkip;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getTxtURISkip());
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        }
        return this.jScrollPane1;
    }

    void appendFound(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.getTxtURIFound().append(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SpiderPanel.this.getTxtURIFound().append(string);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void appendFoundButSkip(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.getTxtURISkip().append(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SpiderPanel.this.getTxtURISkip().append(string);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clear() {
        this.getTxtURIFound().setText("");
        this.getTxtURISkip().setText("");
    }
}

