/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import gnu.javax.imageio.bmp.DecodeBF16;
import gnu.javax.imageio.bmp.DecodeBF32;
import gnu.javax.imageio.bmp.DecodeRGB1;
import gnu.javax.imageio.bmp.DecodeRGB24;
import gnu.javax.imageio.bmp.DecodeRGB4;
import gnu.javax.imageio.bmp.DecodeRGB8;
import gnu.javax.imageio.bmp.DecodeRLE4;
import gnu.javax.imageio.bmp.DecodeRLE8;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public abstract class BMPDecoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;

    public static BMPDecoder getDecoder(BMPFileHeader fh, BMPInfoHeader ih) {
        switch (ih.getCompression()) {
            case 0: {
                switch (ih.getBitCount()) {
                    case 32: {
                        return new DecodeBF32(fh, ih, true);
                    }
                    case 24: {
                        return new DecodeRGB24(fh, ih);
                    }
                    case 16: {
                        return new DecodeBF16(fh, ih, true);
                    }
                    case 8: {
                        return new DecodeRGB8(fh, ih);
                    }
                    case 4: {
                        return new DecodeRGB4(fh, ih);
                    }
                    case 1: {
                        return new DecodeRGB1(fh, ih);
                    }
                }
                return null;
            }
            case 1: {
                return new DecodeRLE8(fh, ih);
            }
            case 2: {
                return new DecodeRLE4(fh, ih);
            }
            case 3: {
                switch (ih.getBitCount()) {
                    case 16: {
                        return new DecodeBF16(fh, ih, false);
                    }
                    case 32: {
                        return new DecodeBF32(fh, ih, false);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public abstract BufferedImage decode(ImageInputStream var1) throws IOException, BMPException;

    protected int[] readBitMasks(ImageInputStream in) throws IOException {
        int[] bitmasks = new int[3];
        byte[] temp = new byte[12];
        if (in.read(temp) != 12) {
            throw new IOException("Couldn't read bit masks.");
        }
        this.offset += 12L;
        ByteBuffer buf = ByteBuffer.wrap(temp);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        bitmasks[0] = buf.getInt();
        bitmasks[1] = buf.getInt();
        bitmasks[2] = buf.getInt();
        return bitmasks;
    }

    protected IndexColorModel readPalette(ImageInputStream in) throws IOException {
        int N = this.infoHeader.getNumberOfPaletteEntries();
        byte[] r = new byte[N];
        byte[] g = new byte[N];
        byte[] b = new byte[N];
        int i = 0;
        while (i < N) {
            byte[] RGBquad = new byte[4];
            if (in.read(RGBquad) != 4) {
                throw new IOException("Error reading palette information.");
            }
            r[i] = RGBquad[2];
            g[i] = RGBquad[1];
            b[i] = RGBquad[0];
            ++i;
        }
        this.offset += (long)(4 * N);
        return new IndexColorModel(8, N, r, g, b);
    }

    protected void skipToImage(ImageInputStream in) throws IOException {
        byte[] d = new byte[1];
        long n = this.fileHeader.getOffset() - this.offset;
        int i = 0;
        while ((long)i < n) {
            in.read(d);
            ++i;
        }
    }

    public BMPDecoder(BMPFileHeader fh, BMPInfoHeader ih) {
        this.fileHeader = fh;
        this.infoHeader = ih;
        this.offset = 54L;
    }
}

