/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class DefaultPreviewPanel
extends JPanel {
    private static int largeGap = 6;
    private static int smallGap = 2;
    private static int squareSize = 36;
    private static int textPadding = 4;
    private static int rightSideRectWidth = 60;
    private static String sample = "Sample Text   Sample Text";
    static /* synthetic */ Class class$javax$swing$JColorChooser;

    public void paint(Graphics g) {
        JColorChooser chooser;
        super.paint(g);
        Color currentColor = null;
        Class clazz = class$javax$swing$JColorChooser;
        if (clazz == null) {
            clazz = class$javax$swing$JColorChooser = DefaultPreviewPanel.class("[Ljavax.swing.JColorChooser;", false);
        }
        if ((chooser = (JColorChooser)SwingUtilities.getAncestorOfClass(clazz, this)) != null) {
            currentColor = chooser.getColor();
        }
        Color saved = g.getColor();
        Insets insets = this.getInsets();
        int down = insets.top + squareSize + largeGap;
        int currX = insets.left;
        this.paintSquare(g, currX, insets.top, Color.WHITE, currentColor, Color.WHITE, -1, -1, -1);
        this.paintSquare(g, currX, down, currentColor, null, null, -1, -1, -1);
        this.paintSquare(g, currX += squareSize + largeGap, insets.top, Color.BLACK, currentColor, Color.WHITE, -1, -1, -1);
        this.paintSquare(g, currX, down, Color.WHITE, currentColor, null, -1, -1, -1);
        this.paintSquare(g, currX += squareSize + largeGap, insets.top, Color.WHITE, currentColor, Color.BLACK, -1, -1, -1);
        this.paintSquare(g, currX, down, Color.BLACK, currentColor, null, -1, -1, -1);
        FontMetrics fm = g.getFontMetrics();
        int strWidth = fm.stringWidth(sample);
        int strHeight = fm.getHeight();
        currX += squareSize + largeGap;
        int boxWidth = 2 * textPadding + strWidth;
        int boxHeight = 2 * textPadding + strHeight;
        int first = insets.top + textPadding;
        int second = insets.top + boxHeight + smallGap;
        int third = insets.top + 2 * (boxHeight + smallGap);
        g.setColor(Color.WHITE);
        g.fillRect(currX, third, boxWidth, boxHeight);
        g.setColor(currentColor);
        g.drawString(sample, currX + textPadding, first + textPadding + fm.getAscent());
        g.fillRect(currX, second, boxWidth, boxHeight);
        g.drawString(sample, currX + textPadding, third + textPadding + fm.getAscent());
        g.setColor(Color.BLACK);
        g.drawString(sample, currX + textPadding, second + textPadding + fm.getAscent());
        g.setColor(Color.WHITE);
        g.fillRect(currX += boxWidth + largeGap, insets.top, rightSideRectWidth, squareSize + largeGap / 2);
        g.setColor(currentColor);
        g.fillRect(currX, insets.top + squareSize + largeGap / 2, rightSideRectWidth, squareSize + largeGap / 2);
        g.setColor(saved);
    }

    private final void paintSquare(Graphics g, int x, int y, Color first, Color second, Color third, int firstSize, int secondSize, int thirdSize) {
        Color saved = g.getColor();
        if (firstSize == -1) {
            firstSize = squareSize;
        }
        if (secondSize == -1) {
            secondSize = squareSize * 2 / 3;
        }
        if (thirdSize == -1) {
            thirdSize = squareSize / 3;
        }
        int secondOffset = (firstSize - secondSize) / 2;
        int thirdOffset = (firstSize - thirdSize) / 2;
        if (first == null) {
            return;
        }
        g.setColor(first);
        g.fillRect(x, y, firstSize, firstSize);
        if (second == null) {
            return;
        }
        g.setColor(second);
        g.fillRect(x + secondOffset, y + secondOffset, secondSize, secondSize);
        if (third == null) {
            return;
        }
        g.setColor(third);
        g.fillRect(x + thirdOffset, y + thirdOffset, thirdSize, thirdSize);
        g.setColor(saved);
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        g.dispose();
        int strWidth = fm.stringWidth(sample);
        int strHeight = fm.getHeight();
        int h1 = (strHeight + 2 * textPadding) * 3 + 2 * smallGap;
        int h2 = 2 * squareSize + largeGap;
        int height = Math.max(h1, h2);
        int width = 3 * (squareSize + largeGap) + strWidth + 2 * textPadding + largeGap + rightSideRectWidth;
        Insets insets = this.getInsets();
        return new Dimension(width + insets.right + insets.left, height + insets.top + insets.bottom);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    DefaultPreviewPanel() {
        this.setBorder(new PreviewBorder());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PreviewBorder
    implements Border {
        private static final int edge = 20;
        private static final int lead = 5;
        private static final int gap = 3;

        public Insets getBorderInsets(Component c) {
            return new Insets(20, 20, 20, 20);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color saved = g.getColor();
            FontMetrics fm = g.getFontMetrics();
            g.setColor(Color.BLACK);
            g.drawLine(x + 10, y + 10, x + 10, y + height - 10);
            g.drawLine(x + 10, y + height - 10, x + width - 10, y + height - 10);
            g.drawLine(x + width - 10, y + 10, x + width - 10, y + height - 10);
            g.drawLine(x + 10, y + 10, x + 10 + 5, y + 10);
            int strwidth = fm.stringWidth("Preview");
            g.drawString("Preview", x + 10 + 5 + 3, y + 10 + fm.getAscent() / 2);
            g.drawLine(x + 5 + 10 + strwidth + 6, y + 10, x + width - 10, y + 10);
            g.setColor(saved);
        }

        PreviewBorder() {
        }
    }
}

