/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.RTextArea;

public class CaretAndSelectionOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    private JComboBox insCaretCombo;
    private JComboBox overCaretCombo;
    private JSpinner blinkRateSpinner;
    private RColorSwatchesButton caretColorButton;
    private RColorSwatchesButton selColorButton;
    private RColorSwatchesButton markAllColorButton;
    private JCheckBox selectedTextColorCB;
    private RColorSwatchesButton selectedTextColorButton;
    private JCheckBox roundedSelCheckBox;
    private JButton systemSelectionButton;
    private JCheckBox enableMOCheckBox;
    private RColorSwatchesButton moColorButton;
    private JCheckBox secLangCB;
    private JLabel[] secLangLabels;
    private RColorSwatchesButton[] secLangButtons;
    private static final int SEC_LANG_COUNT = 3;
    private static final String PROPERTY = "property";

    public CaretAndSelectionOptionPanel() {
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextarea.CaretAndSelectionOptionPanel");
        this.setName(msg.getString("Title"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        Box caretPanel = Box.createVerticalBox();
        caretPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Carets")));
        JPanel temp = new JPanel(new SpringLayout());
        JLabel insLabel = new JLabel(msg.getString("InsertCaret"));
        this.insCaretCombo = CaretAndSelectionOptionPanel.createCaretComboBox(msg);
        this.insCaretCombo.setActionCommand("InsertCaretCombo");
        this.insCaretCombo.addActionListener(this);
        insLabel.setLabelFor(this.insCaretCombo);
        JLabel overLabel = new JLabel(msg.getString("OverwriteCaret"));
        this.overCaretCombo = CaretAndSelectionOptionPanel.createCaretComboBox(msg);
        this.overCaretCombo.setActionCommand("OverwriteCaretCombo");
        this.overCaretCombo.addActionListener(this);
        overLabel.setLabelFor(this.overCaretCombo);
        JLabel caretDelayLabel = new JLabel(msg.getString("BlinkRate"));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(500, 0, 10000, 50);
        this.blinkRateSpinner = new JSpinner(spinnerModel);
        this.blinkRateSpinner.addChangeListener(this);
        caretDelayLabel.setLabelFor(this.blinkRateSpinner);
        JLabel caretColorLabel = new JLabel(msg.getString("Color"));
        this.caretColorButton = new RColorSwatchesButton();
        this.caretColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        caretColorLabel.setLabelFor((Component)this.caretColorButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.caretColorButton, "Before");
        if (o.isLeftToRight()) {
            temp.add(insLabel);
            temp.add(this.insCaretCombo);
            temp.add(overLabel);
            temp.add(this.overCaretCombo);
            temp.add(caretDelayLabel);
            temp.add(this.blinkRateSpinner);
            temp.add(caretColorLabel);
            temp.add(buttonPanel);
        } else {
            temp.add(this.insCaretCombo);
            temp.add(insLabel);
            temp.add(this.overCaretCombo);
            temp.add(overLabel);
            temp.add(this.blinkRateSpinner);
            temp.add(caretDelayLabel);
            temp.add(buttonPanel);
            temp.add(caretColorLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)temp, (int)4, (int)2, (int)0, (int)0, (int)5, (int)5);
        caretPanel.add(temp);
        caretPanel.add(Box.createVerticalStrut(5));
        topPanel.add(caretPanel);
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createSelectionPanel(msg, o));
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createMarkOccurrencesPanel(msg, o));
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.createSecondaryLanguagesPanel(msg, o));
        topPanel.add(Box.createVerticalStrut(10));
        JButton rdButton = new JButton(msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        this.addLeftAligned(topPanel, rdButton);
        this.add(topPanel, "North");
        this.applyComponentOrientation(o);
        msg = null;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object source = e.getSource();
        if ("RestoreDefaults".equals(command)) {
            Color defaultCaretColor = RTextArea.getDefaultCaretColor();
            Color defaultSelectionColor = RSyntaxTextArea.getDefaultSelectionColor();
            Color defaultMarkAllColor = RTextArea.getDefaultMarkAllHighlightColor();
            Color defaultMarkOccurrencesColor = new Color(224, 224, 224);
            Color defaultSelectedTextColor = Color.white;
            CaretStyle defaultInsertCaret = CaretStyle.THICK_VERTICAL_LINE_STYLE;
            CaretStyle defaultOverwriteCaret = CaretStyle.BLOCK_STYLE;
            Integer defaultCaretBlinkRate = new Integer(500);
            Color[] defaultSecLangColor = new Color[]{new Color(0xFFF0CC), new Color(14352090), new Color(0xFFE0F0)};
            if (!(this.getCaretColor().equals(defaultCaretColor) && this.getSelectionColor().equals(defaultSelectionColor) && this.getMarkAllHighlightColor().equals(defaultMarkAllColor) && this.getCaretStyle(0) == defaultInsertCaret && this.getCaretStyle(1) == defaultOverwriteCaret && this.blinkRateSpinner.getValue().equals(defaultCaretBlinkRate) && !this.getRoundedSelection() && this.enableMOCheckBox.isSelected() && this.moColorButton.getColor().equals(defaultMarkOccurrencesColor) && !this.selectedTextColorCB.isSelected() && this.selectedTextColorButton.getColor().equals(defaultSelectedTextColor) && !this.secLangCB.isSelected() && defaultSecLangColor[0].equals(this.secLangButtons[0]) && defaultSecLangColor[1].equals(this.secLangButtons[1]) && defaultSecLangColor[2].equals(this.secLangButtons[2]))) {
                this.setCaretColor(defaultCaretColor);
                this.setSelectionColor(defaultSelectionColor);
                this.setMarkAllHighlightColor(defaultMarkAllColor);
                this.setCaretStyle(0, defaultInsertCaret);
                this.setCaretStyle(1, defaultOverwriteCaret);
                this.blinkRateSpinner.setValue(defaultCaretBlinkRate);
                this.setRoundedSelection(false);
                this.enableMOCheckBox.setSelected(true);
                this.moColorButton.setEnabled(true);
                this.moColorButton.setColor(defaultMarkOccurrencesColor);
                this.setSelectedTextColorEnabled(false);
                this.selectedTextColorButton.setColor(Color.white);
                this.setHighlightSecondaryLanguages(false);
                for (int i = 0; i < 3; ++i) {
                    this.secLangButtons[i].setColor(defaultSecLangColor[i]);
                }
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, null, defaultCaretColor);
            }
        } else if ("InsertCaretCombo".equals(command)) {
            int style = this.insCaretCombo.getSelectedIndex();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, -1, style);
        } else if ("OverwriteCaretCombo".equals(command)) {
            int style = this.overCaretCombo.getSelectedIndex();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, -1, style);
        } else if ("RoundedSelectionCheckBox".equals(command)) {
            boolean selected = this.roundedSelCheckBox.isSelected();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        } else if (this.selectedTextColorCB == source) {
            boolean selected = ((JCheckBox)source).isSelected();
            this.setSelectedTextColorEnabled(selected);
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        } else if (this.systemSelectionButton == source) {
            JTextArea textArea = new JTextArea();
            Color systemSelectionColor = textArea.getSelectionColor();
            Color selectedTextColor = textArea.getSelectedTextColor();
            if (!(systemSelectionColor.equals(this.selColorButton.getColor()) && this.selectedTextColorCB.isSelected() && this.selectedTextColorButton.equals(selectedTextColor))) {
                this.selColorButton.setColor(systemSelectionColor);
                this.setSelectedTextColorEnabled(true);
                this.selectedTextColorButton.setColor(selectedTextColor);
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, false, true);
            }
        } else if ("MarkOccurrences".equals(command)) {
            boolean selected = this.enableMOCheckBox.isSelected();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
            this.moColorButton.setEnabled(selected);
        } else if (this.secLangCB == source) {
            boolean selected = ((JCheckBox)source).isSelected();
            this.setHighlightSecondaryLanguages(selected);
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        }
    }

    private static final JComboBox createCaretComboBox(ResourceBundle msg) {
        JComboBox<String> combo = new JComboBox<String>();
        UIUtil.fixComboOrientation(combo);
        combo.addItem(msg.getString("CaretVerticalLine"));
        combo.addItem(msg.getString("CaretUnderline"));
        combo.addItem(msg.getString("CaretBlock"));
        combo.addItem(msg.getString("CaretRectangle"));
        combo.addItem(msg.getString("CaretThickVerticalLine"));
        return combo;
    }

    private Box createSecondaryLanguagesPanel(ResourceBundle msg, ComponentOrientation o) {
        Box p = Box.createVerticalBox();
        p.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("SecondaryLanguages")));
        this.secLangCB = new JCheckBox(msg.getString("HighlightSecondaryLanguages"));
        this.secLangCB.addActionListener(this);
        this.addLeftAligned(p, this.secLangCB);
        this.secLangLabels = new JLabel[3];
        this.secLangButtons = new RColorSwatchesButton[3];
        for (int i = 0; i < 3; ++i) {
            this.secLangButtons[i] = new RColorSwatchesButton();
            this.secLangButtons[i].addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
            this.secLangLabels[i] = new JLabel(msg.getString("HighlightSecondaryLanguages.Color" + (i + 1)));
            this.secLangLabels[i].setLabelFor((Component)this.secLangButtons[i]);
        }
        JPanel temp = new JPanel(new SpringLayout());
        if (o.isLeftToRight()) {
            temp.add(this.secLangLabels[0]);
            temp.add((Component)this.secLangButtons[0]);
            temp.add(Box.createVerticalStrut(20));
            temp.add(this.secLangLabels[1]);
            temp.add((Component)this.secLangButtons[1]);
            temp.add(Box.createVerticalStrut(20));
            temp.add(this.secLangLabels[2]);
            temp.add((Component)this.secLangButtons[2]);
        } else {
            temp.add((Component)this.secLangButtons[0]);
            temp.add(this.secLangLabels[0]);
            temp.add(Box.createVerticalStrut(20));
            temp.add((Component)this.secLangButtons[1]);
            temp.add(this.secLangLabels[1]);
            temp.add(Box.createVerticalStrut(20));
            temp.add((Component)this.secLangButtons[2]);
            temp.add(this.secLangLabels[2]);
        }
        UIUtil.makeSpringCompactGrid((Container)temp, (int)1, (int)8, (int)0, (int)0, (int)5, (int)5);
        this.addLeftAligned(p, temp, 0, 20);
        return p;
    }

    private Box createSelectionPanel(ResourceBundle msg, ComponentOrientation o) {
        Box p = Box.createVerticalBox();
        p.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Selection")));
        this.selColorButton = new RColorSwatchesButton();
        this.selColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        JLabel selLabel = new JLabel(msg.getString("SelColor"));
        selLabel.setLabelFor((Component)this.selColorButton);
        this.markAllColorButton = new RColorSwatchesButton();
        this.markAllColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        JLabel markAllLabel = new JLabel(msg.getString("MarkAllColor"));
        markAllLabel.setLabelFor((Component)this.markAllColorButton);
        this.selectedTextColorCB = new JCheckBox(msg.getString("SelectedTextColor"));
        this.selectedTextColorCB.addActionListener(this);
        this.selectedTextColorButton = new RColorSwatchesButton();
        this.selectedTextColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        JPanel contents = new JPanel(new SpringLayout());
        Dimension d = new Dimension(5, 5);
        if (o.isLeftToRight()) {
            contents.add(selLabel);
            contents.add((Component)this.selColorButton);
            contents.add(Box.createHorizontalStrut(40));
            contents.add(markAllLabel);
            contents.add((Component)this.markAllColorButton);
            contents.add(this.selectedTextColorCB);
            contents.add((Component)this.selectedTextColorButton);
            contents.add(Box.createHorizontalStrut(40));
            contents.add(Box.createRigidArea(d));
            contents.add(Box.createRigidArea(d));
        } else {
            contents.add((Component)this.markAllColorButton);
            contents.add(markAllLabel);
            contents.add(Box.createHorizontalStrut(40));
            contents.add((Component)this.selColorButton);
            contents.add(selLabel);
            contents.add((Component)this.selectedTextColorButton);
            contents.add(this.selectedTextColorCB);
            contents.add(Box.createHorizontalStrut(40));
            contents.add(Box.createRigidArea(d));
            contents.add(Box.createRigidArea(d));
        }
        UIUtil.makeSpringCompactGrid((Container)contents, (int)2, (int)5, (int)0, (int)0, (int)5, (int)5);
        this.systemSelectionButton = new JButton(msg.getString("SystemSelection"));
        this.systemSelectionButton.addActionListener(this);
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)this.systemSelectionButton, "North");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)contents, "Before");
        temp.add((Component)temp2, "After");
        p.add(temp);
        this.roundedSelCheckBox = new JCheckBox(msg.getString("RoundSel"));
        this.roundedSelCheckBox.setActionCommand("RoundedSelectionCheckBox");
        this.roundedSelCheckBox.addActionListener(this);
        this.addLeftAligned(p, this.roundedSelCheckBox);
        return p;
    }

    private Box createMarkOccurrencesPanel(ResourceBundle msg, ComponentOrientation o) {
        Box p = Box.createVerticalBox();
        p.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("MarkOccurrences")));
        this.enableMOCheckBox = new JCheckBox(msg.getString("EnableMarkOccurrences"));
        this.enableMOCheckBox.setActionCommand("MarkOccurrences");
        this.enableMOCheckBox.addActionListener(this);
        this.moColorButton = new RColorSwatchesButton();
        this.moColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        Box box = this.createHorizontalBox();
        box.add(this.enableMOCheckBox);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)this.moColorButton);
        box.add(Box.createHorizontalGlue());
        p.add(box);
        return p;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setCaretColor(this.getCaretColor());
        mainView.setSelectionColor(this.getSelectionColor());
        mainView.setMarkAllHighlightColor(this.getMarkAllHighlightColor());
        mainView.setRoundedSelectionEdges(this.getRoundedSelection());
        mainView.setCaretStyle(0, this.getCaretStyle(0));
        mainView.setCaretStyle(1, this.getCaretStyle(1));
        mainView.setCaretBlinkRate(this.getBlinkRate());
        mainView.setMarkOccurrences(this.enableMOCheckBox.isSelected());
        mainView.setMarkOccurrencesColor(this.moColorButton.getColor());
        mainView.setSelectedTextColor(CaretAndSelectionOptionPanel.getColor(this.selectedTextColorButton));
        mainView.setUseSelectedTextColor(this.selectedTextColorCB.isSelected());
        mainView.setHighlightSecondaryLanguages(this.secLangCB.isSelected());
        for (int i = 0; i < 3; ++i) {
            mainView.setSecondaryLanguageColor(i, this.secLangButtons[i].getColor());
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public int getBlinkRate() {
        return (Integer)this.blinkRateSpinner.getValue();
    }

    public Color getCaretColor() {
        return this.caretColorButton.getColor();
    }

    public CaretStyle getCaretStyle(int mode) {
        int ordinal = 0;
        ordinal = mode == 0 ? this.insCaretCombo.getSelectedIndex() : this.overCaretCombo.getSelectedIndex();
        return CaretStyle.values()[ordinal];
    }

    private static final Color getColor(RColorSwatchesButton button) {
        return new Color(button.getColor().getRGB());
    }

    public Color getMarkAllHighlightColor() {
        return this.markAllColorButton.getColor();
    }

    public boolean getRoundedSelection() {
        return this.roundedSelCheckBox.isSelected();
    }

    public Color getSelectionColor() {
        return CaretAndSelectionOptionPanel.getColor(this.selColorButton);
    }

    public JComponent getTopJComponent() {
        return this.caretColorButton;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("RColorButton.colorChanged".equals(e.getPropertyName())) {
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, e.getOldValue(), e.getNewValue());
        }
    }

    private void setBlinkRate(int blinkRate) {
        this.blinkRateSpinner.setValue(new Integer(blinkRate));
    }

    private void setCaretColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.caretColorButton.setColor(color);
    }

    private void setCaretStyle(int mode, CaretStyle style) {
        switch (mode) {
            case 0: {
                this.insCaretCombo.setSelectedIndex(style.ordinal());
                break;
            }
            case 1: {
                this.overCaretCombo.setSelectedIndex(style.ordinal());
                break;
            }
            default: {
                throw new IllegalArgumentException("mode must be 0 or 1");
            }
        }
    }

    private void setHighlightSecondaryLanguages(boolean highlight) {
        this.secLangCB.setSelected(highlight);
        for (int i = 0; i < 3; ++i) {
            this.secLangLabels[i].setEnabled(highlight);
            this.secLangButtons[i].setEnabled(highlight);
        }
    }

    private void setMarkAllHighlightColor(Color color) {
        if (color != null) {
            this.markAllColorButton.setColor(color);
        }
    }

    private void setRoundedSelection(boolean selected) {
        this.roundedSelCheckBox.setSelected(selected);
    }

    private void setSelectionColor(Color color) {
        if (color != null) {
            this.selColorButton.setColor(color);
        }
    }

    private void setSelectedTextColorEnabled(boolean enabled) {
        this.selectedTextColorCB.setSelected(enabled);
        this.selectedTextColorButton.setEnabled(enabled);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setCaretColor(mainView.getCaretColor());
        this.setSelectionColor(mainView.getSelectionColor());
        this.setMarkAllHighlightColor(mainView.getMarkAllHighlightColor());
        this.setRoundedSelection(mainView.getRoundedSelectionEdges());
        this.setCaretStyle(0, mainView.getCaretStyle(0));
        this.setCaretStyle(1, mainView.getCaretStyle(1));
        this.setBlinkRate(mainView.getCaretBlinkRate());
        this.enableMOCheckBox.setSelected(mainView.getMarkOccurrences());
        this.moColorButton.setEnabled(this.enableMOCheckBox.isSelected());
        this.moColorButton.setColor(mainView.getMarkOccurrencesColor());
        this.setSelectedTextColorEnabled(mainView.getUseSelectedTextColor());
        this.selectedTextColorButton.setColor(mainView.getSelectedTextColor());
        this.setHighlightSecondaryLanguages(mainView.getHighlightSecondaryLanguages());
        for (int i = 0; i < 3; ++i) {
            this.secLangButtons[i].setColor(mainView.getSecondaryLanguageColor(i));
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(PROPERTY, null, this.blinkRateSpinner.getValue());
    }
}

