/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class BusyLabel
extends JLabel {
    private Timer timer;
    private boolean busy;
    private BusyIcon icon = new BusyIcon();

    public BusyLabel() {
        this.setIcon(this.icon);
        this.timer = new Timer(125, this.busy());
        this.timer.setRepeats(false);
    }

    public void start() {
        this.busy = true;
        this.timer.restart();
    }

    public void stop() {
        this.busy = false;
    }

    private ActionListener busy() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (BusyLabel.this.busy) {
                    BusyLabel.this.icon.roll();
                    BusyLabel.this.repaint();
                    BusyLabel.this.timer.restart();
                } else {
                    BusyLabel.this.icon.stop();
                    BusyLabel.this.repaint();
                }
            }
        };
    }

    class BusyIcon
    implements Icon {
        private int startIndex;
        List<Color> colors = new ArrayList<Color>();

        BusyIcon() {
            this.colors.add(new Color(178, 178, 178));
            this.colors.add(new Color(153, 153, 153));
            this.colors.add(new Color(128, 128, 128));
            this.colors.add(new Color(102, 102, 102));
            this.colors.add(new Color(51, 51, 51));
            this.colors.add(new Color(26, 26, 26));
            this.colors.add(new Color(0, 0, 0));
            this.colors.add(new Color(0, 0, 0));
        }

        void setIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public void stop() {
            this.startIndex = 0;
        }

        public void roll() {
            --this.startIndex;
            if (this.startIndex < 0) {
                this.startIndex = 7;
            }
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            for (int i = 0; i < 8; ++i) {
                int tx = 0;
                int ty = 0;
                Color c = BusyLabel.this.busy ? this.colors.get((i + this.startIndex) % 8) : this.colors.get(0);
                switch (i) {
                    case 0: {
                        tx = 10;
                        ty = 2;
                        break;
                    }
                    case 1: {
                        tx = 12;
                        ty = 6;
                        break;
                    }
                    case 2: {
                        tx = 10;
                        ty = 10;
                        break;
                    }
                    case 3: {
                        tx = 6;
                        ty = 12;
                        break;
                    }
                    case 4: {
                        tx = 2;
                        ty = 10;
                        break;
                    }
                    case 5: {
                        tx = 0;
                        ty = 6;
                        break;
                    }
                    case 6: {
                        tx = 2;
                        ty = 2;
                        break;
                    }
                    case 7: {
                        tx = 6;
                        ty = 0;
                    }
                }
                g.setColor(c);
                g.drawLine(x + tx + 0, y + ty + 1, x + tx + 0, y + ty + 2);
                g.drawLine(x + tx + 1, y + ty + 0, x + tx + 1, y + ty + 3);
                g.drawLine(x + tx + 2, y + ty + 0, x + tx + 2, y + ty + 3);
                g.drawLine(x + tx + 3, y + ty + 1, x + tx + 3, y + ty + 2);
            }
        }
    }
}

