/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmeld.JMeld;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelManager {
    private static LookAndFeelManager instance = new LookAndFeelManager();

    private LookAndFeelManager() {
        this.init();
    }

    public static LookAndFeelManager getInstance() {
        return instance;
    }

    private void init() {
        try {
            PlasticLookAndFeel.setTabStyle((String)"metal");
            System.setProperty("Plastic.defaultTheme", "MySkyBluer");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void install() {
        try {
            String lookAndFeelClassName = this.getDefaultLookAndFeelClassName();
            String lookAndFeelName = JMeldSettings.getInstance().getEditor().getLookAndFeelName();
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!ObjectUtil.equals(info.getName(), lookAndFeelName)) continue;
                lookAndFeelClassName = info.getClassName();
                break;
            }
            UIManager.setLookAndFeel(lookAndFeelClassName);
            LookAndFeelFactory.installJideExtension();
            Component root = SwingUtilities.getRoot(JMeld.getJMeldPanel());
            if (root != null) {
                SwingUtilities.updateComponentTreeUI(root);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getInstalledLookAndFeelName() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!ObjectUtil.equals(info.getClassName(), lf.getClass().getName())) continue;
            return info.getName();
        }
        return lf.getName();
    }

    private String getDefaultLookAndFeelClassName() {
        if (System.getProperty("java.version").startsWith("1.7")) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return Plastic3DLookAndFeel.class.getName();
    }

    public List<String> getInstalledLookAndFeels() {
        ArrayList<String> result = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            result.add(info.getName());
        }
        return result;
    }
}

