/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.util.ImageUtil;

public class WidgetFactory {
    public static JMenuItem getMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        ImageIcon icon = (ImageIcon)action.getValue("SmallIcon");
        if (icon != null) {
            item.setDisabledIcon(ImageUtil.createTransparentIcon(icon));
        }
        return item;
    }

    public static JButton getToolBarButton(Action action) {
        EditorSettings settings = JMeldSettings.getInstance().getEditor();
        JButton button = new JButton(action);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setFocusable(false);
        EditorSettings.ToolbarButtonIcon toolbarButtonIcon = settings.getToolbarButtonIcon();
        ImageIcon icon = null;
        if (toolbarButtonIcon == EditorSettings.ToolbarButtonIcon.SMALL) {
            icon = (ImageIcon)action.getValue("SmallIcon");
        } else if (toolbarButtonIcon == EditorSettings.ToolbarButtonIcon.LARGE) {
            icon = (ImageIcon)action.getValue(MeldAction.LARGE_ICON_KEY);
        }
        button.setIcon(icon);
        button.setDisabledIcon(ImageUtil.createTransparentIcon(icon));
        if (!settings.isToolbarButtonTextEnabled()) {
            button.setText("");
        }
        Dimension size = button.getPreferredSize();
        if (size.height > size.width) {
            size.width = size.height;
        }
        button.setPreferredSize(size);
        return button;
    }
}

