/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jmeld.ui.StatusBar;
import org.jmeld.util.StopWatch;
import org.jmeld.util.StringUtil;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.node.FileNode;
import org.jmeld.util.node.JMDiffNode;
import org.jmeld.util.node.VersionControlBaseNode;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.VersionControlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionControlDiff
extends FolderDiff {
    private File directory;
    private JMDiffNode rootNode;
    private Map<String, JMDiffNode> nodes;

    public VersionControlDiff(File directory, FolderDiff.Mode mode) {
        super(mode);
        this.directory = directory;
        try {
            this.setLeftFolderShortName(directory.getName());
            this.setRightFolderShortName("");
            this.setLeftFolderName(directory.getCanonicalPath());
            this.setRightFolderName("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public JMDiffNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Collection<JMDiffNode> getNodes() {
        return this.nodes.values();
    }

    @Override
    public void diff() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        StatusBar.getInstance().start();
        StatusBar.getInstance().setState("Start scanning directories...", new Object[0]);
        this.rootNode = new JMDiffNode("<root>", false);
        this.nodes = new HashMap<String, JMDiffNode>();
        List<VersionControlIF> versionControlList = VersionControlUtil.getVersionControl(this.directory);
        if (versionControlList.isEmpty()) {
            return;
        }
        VersionControlIF versionControl = versionControlList.get(0);
        StatusResult statusResult = versionControl.executeStatus(this.directory);
        for (StatusResult.Entry entry : statusResult.getEntryList()) {
            File file = new File(entry.getName());
            JMDiffNode node = this.addNode(entry.getName(), !file.isDirectory());
            FileNode fileNode = new FileNode(entry.getName(), file);
            node.setBufferNodeLeft(new VersionControlBaseNode(versionControl, entry, fileNode, file));
            node.setBufferNodeRight(fileNode);
            switch (entry.getStatus()) {
                case modified: 
                case conflicted: 
                case missing: 
                case dontknow: {
                    node.setCompareState(JMDiffNode.Compare.NotEqual);
                    break;
                }
                case unversioned: 
                case added: {
                    node.setCompareState(JMDiffNode.Compare.LeftMissing);
                    break;
                }
                case removed: {
                    node.setCompareState(JMDiffNode.Compare.RightMissing);
                    break;
                }
                case clean: 
                case ignored: {
                    node.setCompareState(JMDiffNode.Compare.Equal);
                }
            }
        }
        StatusBar.getInstance().setState("Ready comparing directories (took " + stopWatch.getElapsedTime() / 1000L + " seconds)", new Object[0]);
        StatusBar.getInstance().stop();
    }

    private JMDiffNode addNode(String name, boolean leaf) {
        JMDiffNode node = this.nodes.get(name);
        if (node == null) {
            node = this.addNode(new JMDiffNode(name, leaf));
        }
        return node;
    }

    private JMDiffNode addNode(JMDiffNode node) {
        JMDiffNode parent;
        this.nodes.put(node.getName(), node);
        String parentName = node.getParentName();
        if (StringUtil.isEmpty(parentName)) {
            parent = this.rootNode;
        } else {
            parent = this.nodes.get(parentName);
            if (parent == null) {
                parent = this.addNode(new JMDiffNode(parentName, false));
                FileNode fn = new FileNode(parentName, new File(this.directory, parentName));
                parent.setBufferNodeRight(fn);
                parent.setBufferNodeLeft(fn);
            }
        }
        parent.addChild(node);
        return node;
    }

    public void print() {
        this.rootNode.print("");
    }

    public static void main(String[] args) {
        VersionControlDiff diff = new VersionControlDiff(new File(args[0]), FolderDiff.Mode.TWO_WAY);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        diff.diff();
        System.out.println("diff took " + stopWatch.getElapsedTime() + " msec.");
        diff.print();
    }
}

