/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusResult {
    private File path;
    private Set<Entry> entryList = new HashSet<Entry>();

    public StatusResult(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    public void addEntry(String name, Status status) {
        Entry entry = new Entry(name, status);
        if (this.entryList.contains(entry)) {
            return;
        }
        this.entryList.add(entry);
    }

    public List<Entry> getEntryList() {
        ArrayList<Entry> list = new ArrayList<Entry>(this.entryList);
        Collections.sort(list);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        modified('M', "vcModified"),
        added('A', "vcAdded"),
        removed('D', "vcRemoved"),
        clean(' ', "vcClean"),
        conflicted('C', "vcConflicted"),
        ignored('I', "vcIgnored"),
        unversioned('?', "vcUnversioned"),
        missing('!', "vcMissing"),
        dontknow('#', "vcMissing");

        private char shortText;
        private String iconName;

        private Status(char shortTexti, String iconName) {
            this.shortText = this.shortText;
            this.iconName = iconName;
        }

        public char getShortText() {
            return this.shortText;
        }

        public String getIconName() {
            return this.iconName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry
    implements Comparable<Entry> {
        private String name;
        private Status status;

        Entry(String name, Status status) {
            this.name = name;
            this.status = status;
        }

        public String getName() {
            return this.name;
        }

        public Status getStatus() {
            return this.status;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.name.compareTo(entry.name);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.name.equals(((Entry)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

