/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.svn;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.util.Result;
import org.jmeld.vc.DiffIF;
import org.jmeld.vc.svn.DiffData;
import org.jmeld.vc.svn.SubversionVersionControl;
import org.jmeld.vc.util.VcCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCmd
extends VcCmd<DiffData> {
    private File file;
    private boolean recursive;
    private BufferedReader reader;
    private String unreadLine;

    public DiffCmd(File file, boolean recursive) {
        this.file = file;
        this.recursive = recursive;
    }

    public Result execute() {
        super.execute("svn", "diff", "--non-interactive", "--no-diff-deleted", this.recursive ? "" : "-N", this.file.getPath());
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        DiffData diffData = new DiffData();
        this.reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String path;
            while ((path = this.readIndex()) != null) {
                JMDelta delta;
                System.out.println("path = " + path);
                JMRevision revision = new JMRevision(null, null);
                diffData.addTarget(path, revision);
                this.readLine();
                this.readLine();
                this.readLine();
                while ((delta = this.readDelta()) != null) {
                    revision.add(delta);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.setResult(Result.FALSE("Parse failed"));
        }
        this.setResultData(diffData);
    }

    private String readIndex() throws IOException {
        String indexMarker = "Index: ";
        String line = this.readLine();
        if (line == null || !line.startsWith("Index: ")) {
            return null;
        }
        return line.substring("Index: ".length());
    }

    private JMDelta readDelta() throws IOException {
        Pattern deltaPattern = Pattern.compile("@@ -(\\d*),(\\d*) \\+(\\d*),(\\d*) @@");
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        Matcher m = deltaPattern.matcher(line);
        if (!m.matches()) {
            this.unreadLine(line);
            return null;
        }
        JMChunk originalChunk = new JMChunk(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)));
        JMChunk revisedChunk = new JMChunk(Integer.valueOf(m.group(3)), Integer.valueOf(m.group(4)));
        JMDelta delta = new JMDelta(originalChunk, revisedChunk);
        while ((line = this.readLine()) != null) {
            if (line.startsWith(" ") || line.startsWith("+") || line.startsWith("-")) continue;
            this.unreadLine(line);
            break;
        }
        System.out.println("delta = " + delta);
        return delta;
    }

    private void unreadLine(String unreadLine) {
        this.unreadLine = unreadLine;
    }

    private String readLine() throws IOException {
        if (this.unreadLine != null) {
            String line = this.unreadLine;
            this.unreadLine = null;
            return line;
        }
        return this.reader.readLine();
    }

    public static void main(String[] args) {
        DiffIF result = new SubversionVersionControl().executeDiff(new File(args[0]), true);
        if (result != null) {
            for (DiffIF.TargetIF targetIF : result.getTargetList()) {
                System.out.println(targetIF.getPath() + " " + targetIF.getRevision());
            }
        }
    }
}

