/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyTableAdaptor;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyTableListener;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.StatementEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.ScriptWriter;

public class CopyScripter
extends CopyTableAdaptor
implements CopyTableListener {
    @Override
    public void copyStarted(CopyEvent e) {
        this.initializeScript(e.getSessionInfoProvider());
    }

    @Override
    public void statementExecuted(StatementEvent e) {
        String sql = e.getStatement();
        if (e.getStatementType() == 3) {
            String[] values = e.getBindValues();
            ScriptWriter.write(sql, values);
        } else {
            ScriptWriter.write(sql);
        }
    }

    @Override
    public void copyFinished(int seconds) {
        this.finalizeScript();
    }

    private void initializeScript(SessionInfoProvider prov) {
        ISession source = prov.getSourceSession();
        ISession dest = prov.getDestSession();
        ScriptWriter.open(source, dest);
    }

    private void finalizeScript() {
        ScriptWriter.close();
    }
}

